/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer.modes;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolUniverseEnum;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.item.linkable.HandHeldDeviceUtils;
import dev.tauri.jsg.item.linkable.dialer.IUniverseDialerScreen;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerClientActionEnum;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.item.linkable.dialer.modes.screen.UDManualDialScreen;
import dev.tauri.jsg.packet.packets.linkable.UniverseDialerActionPacketToServer;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class UDManualDialMode
extends UniverseDialerMode {
    public static final String C_SELECTED_GLYPH = "selectedGlyph";
    public static final String C_EDIT_ADDRESS = "address";
    private final UDManualDialScreen screen = new UDManualDialScreen();

    public UDManualDialMode() {
        super(JSGApi.rl("manual_dialing"), "item.jsg.universe_dialer.manual_dialing", JSGBlockTags.DIALER_NEARBY_LINKABLE, (level, pos) -> {
            StargateUniverseBaseBE uniBE;
            BlockEntity patt2306$temp = level.m_7702_(pos);
            return patt2306$temp instanceof StargateUniverseBaseBE && (uniBE = (StargateUniverseBaseBE)patt2306$temp).isMerged();
        });
    }

    @Override
    public IUniverseDialerScreen getScreen() {
        return this.screen;
    }

    @Override
    public void inventoryTick(ItemStack stack, CompoundTag compound, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, compound, world, entity, itemSlot, isSelected);
        if (!compound.m_128441_("linkedPos")) {
            return;
        }
        BlockPos linkedPos = BlockPos.m_122022_((long)compound.m_128454_("linkedPos"));
        StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)world.m_7702_(linkedPos);
        if (gateTile == null) {
            return;
        }
        HandHeldDeviceUtils.addrToBytes(((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddress(), compound, "dialedAddress");
        ((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialingSequence().ifPresentOrElse(s -> HandHeldDeviceUtils.addrToBytes((StargateAddressDynamic)s.getOriginalAddress(), compound, "toDialAddress"), () -> {
            if (((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddressSize() > 0) {
                HandHeldDeviceUtils.addrToBytes(((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddress(), compound, "toDialAddress");
            } else {
                HandHeldDeviceUtils.addrToBytes(new StargateAddressDynamic(gateTile.getSymbolType()), compound, "toDialAddress");
            }
        });
        compound.m_128405_("gateStatus", ((StargateAbstractDialingManager)gateTile.getDialingManager()).getStargateState().ordinal());
    }

    @Override
    public void handlePacketToServer(UniverseDialerClientActionEnum action, CompoundTag compound, UniverseDialerActionPacketToServer packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        if (action == UniverseDialerClientActionEnum.ADDRESS_CHANGE) {
            int symbolOffset = compound.m_128451_(C_SELECTED_GLYPH);
            symbolOffset = packet.next ? --symbolOffset : ++symbolOffset;
            compound.m_128405_(C_SELECTED_GLYPH, symbolOffset);
            JSGSoundHelper.playSoundToPlayer(player, SoundEvent.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
        }
    }

    @Override
    public boolean onUse(CompoundTag compound, ItemStack stack, Level world, Player player, InteractionHand hand, boolean shift) {
        int symbolId;
        if (world.f_46443_) {
            return false;
        }
        CompoundTag addressTag = compound.m_128469_(C_EDIT_ADDRESS);
        StargateAddressDynamic address = new StargateAddressDynamic(SymbolTypeRegistry.UNIVERSE);
        address.deserializeNBT(addressTag);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (shift) {
            StargateUniverseBaseBE gateTile;
            BlockPos linkedPos = BlockPos.m_122022_((long)compound.m_128454_("linkedPos"));
            BlockEntity linkedTe = world.m_7702_(linkedPos);
            if (!(linkedTe instanceof StargateUniverseBaseBE) || !(gateTile = (StargateUniverseBaseBE)linkedTe).isMerged()) {
                JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
                return false;
            }
            switch (((StargateAbstractDialingManager)gateTile.getDialingManager()).getStargateState()) {
                case IDLE: {
                    if (((StargateAbstractDialingManager)gateTile.getDialingManager()).canAbortDialing() && ((StargateAbstractDialingManager)gateTile.getDialingManager()).abortDialingSequence()) {
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                        JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                        break;
                    }
                    address = address.addOriginIfMissingAndImmutable();
                    Boolean fastDial = gateTile.getConfig().getValueOrDefault(StargateConfigOptions.Universe.FAST_DIALING);
                    ((StargateAbstractDialingManager)gateTile.getDialingManager()).dialAddress(address, false, false, fastDial != false ? EnumDialingType.FAST : EnumDialingType.REMOTE);
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.dial_start"), true);
                    JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                    break;
                }
                case ENGAGED_INITIATING: {
                    ((StargateAbstractDialingManager)gateTile.getDialingManager()).attemptClose(StargateClosedReasonEnum.REQUESTED);
                    JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                    break;
                }
                case ENGAGED: {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"tile.jsg.dhd_block.incoming_wormhole_warn"), true);
                    JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
                    break;
                }
                default: {
                    if (((StargateAbstractDialingManager)gateTile.getDialingManager()).abortDialingSequence()) {
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                        JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                        break;
                    }
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.gate_busy"), true);
                    JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
                }
            }
            return true;
        }
        int symbolOffset = compound.m_128451_(C_SELECTED_GLYPH);
        for (symbolId = symbolOffset % SymbolUniverseEnum.values().length; symbolId < 0; symbolId += SymbolUniverseEnum.values().length) {
        }
        if (symbolId == 0) {
            if (address.popLast() == null) {
                JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
                return false;
            }
            compound.m_128365_(C_EDIT_ADDRESS, (Tag)address.serializeNBT());
            JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
            return true;
        }
        SymbolUniverseEnum symbol = SymbolTypeRegistry.UNIVERSE.valueOf(symbolId);
        if (address.size() >= 9 || address.size() > 0 && address.getLast().origin() || symbol.origin() && address.size() < 6) {
            JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
            return false;
        }
        address.addSymbol(symbol);
        compound.m_128365_(C_EDIT_ADDRESS, (Tag)address.serializeNBT());
        JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
        return true;
    }
}

