/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer.modes;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.item.linkable.dialer.modes.UDNearbyMode;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

@ParametersAreNonnullByDefault
public class UDMemoryMode
extends UDNearbyMode {
    public UDMemoryMode() {
        super(JSG.rl("memory"), "item.jsg.universe_dialer.mode_saved", JSGBlockTags.DIALER_MEMORY_LINKABLE, (level, pos) -> {
            StargateUniverseBaseBE uniBE;
            BlockEntity be = level.m_7702_(pos);
            return be instanceof StargateUniverseBaseBE && (uniBE = (StargateUniverseBaseBE)be).isMerged();
        });
    }

    @Override
    public void onLinkUpdated(boolean isLinked, BlockPos linkedPos, CompoundTag compound, ItemStack stack, ServerLevel world, Entity entity) {
        if (isLinked && entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            JSGSoundHelper.playSoundToPlayer(sp, SoundEvent.UNIVERSE_DIALER_CONNECTED, entity.m_20183_());
        }
    }

    @Override
    public boolean onUse(CompoundTag compound, ItemStack stack, Level world, Player player, InteractionHand hand, boolean shift) {
        if (shift) {
            ListTag entries;
            if (world.f_46443_) {
                return false;
            }
            byte selectedEntry = compound.m_128445_("selected");
            if (selectedEntry >= (entries = compound.m_128437_("entries", 10)).size()) {
                return false;
            }
            entries.remove((int)selectedEntry);
            compound.m_128365_("entries", (Tag)entries);
            if (selectedEntry >= entries.size()) {
                selectedEntry = (byte)(selectedEntry - 1);
            }
            compound.m_128344_("selected", selectedEntry);
            stack.m_41751_(compound);
            return true;
        }
        return super.onUse(compound, stack, world, player, hand, false);
    }

    public void addEntry(StargateAddress address, int[] symbolsToDisplay, int originId, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag modeTag = this.getTag(tag);
        ListTag list = modeTag.m_128437_("entries", 10);
        CompoundTag addressTag = address.serializeNBT();
        addressTag.m_128385_("symbolsToDisplay", symbolsToDisplay);
        addressTag.m_128405_("originId", originId);
        list.add((Object)addressTag);
        modeTag.m_128365_("entries", (Tag)list);
        stack.m_41751_(tag);
    }
}

