/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.item.linkable.HandHeldDeviceRenderer;
import dev.tauri.jsg.loader.texture.Texture;
import java.awt.Color;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

public class UDModesRenderUtils {
    public static void drawWaringGlyph(PoseStack stack, Color color) {
        stack.m_85836_();
        stack.m_85837_(-1.2, -0.75, 0.0);
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        RenderSystem.enableDepthTest();
        Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/universe_warning.png"));
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        HandHeldDeviceRenderer.drawTexturedRect(0.0f, 0.0f, 0.0f, 0.24f, 0.24f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85849_();
        stack.m_85849_();
    }

    @ParametersAreNonnullByDefault
    public static void drawAddress(int yOffset, boolean selected, PoseStack stack, @Nullable String name, EnumStargateState gateStatus, StargateAddressDynamic address, @Nullable StargateAddressDynamic toDialAddress, @Nullable StargateAddressDynamic dialedAddress) {
        int[] symbolsToDisplay = new int[address.size()];
        for (int i = 0; i < address.size(); ++i) {
            symbolsToDisplay[i] = i + 1;
        }
        UDModesRenderUtils.drawAddress(yOffset, selected, stack, name, gateStatus, symbolsToDisplay, address, toDialAddress, dialedAddress);
    }

    public static void drawAddress(int yOffset, boolean selected, PoseStack stack, @Nullable String name, EnumStargateState gateStatus, int[] symbolsToDisplay, StargateAddress address, @Nullable StargateAddressDynamic toDialAddress, @Nullable StargateAddressDynamic dialedAddress) {
        boolean engage_poo;
        boolean isIdle = gateStatus.idle();
        int dialed = -1;
        boolean isDialingThisAddr = false;
        if (toDialAddress != null && toDialAddress.equals(address)) {
            dialed = 0;
            isDialingThisAddr = true;
        }
        if (dialedAddress != null && isDialingThisAddr) {
            dialed = dialedAddress.getSize();
        }
        if (dialed == 0 && isIdle) {
            dialed = -1;
        }
        boolean bl = engage_poo = isDialingThisAddr && dialedAddress != null && dialedAddress.contains((SymbolInterface)dialedAddress.getSymbolType().getOrigin());
        if (name != null) {
            Object entryName = name;
            if (dialed > -1) {
                entryName = (String)entryName + " (" + dialed + ")";
            }
            HandHeldDeviceRenderer.drawStringWithShadow(-0.12f, -0.5f - 0.2f * (float)yOffset, (String)entryName, selected, false, true, dialed >= 0, gateStatus);
        } else {
            int symbolPos = 0;
            for (int i : symbolsToDisplay) {
                Object symbol;
                boolean engage_s = i <= dialed;
                Object object = symbol = i > address.getSize() ? address.getSymbolType().getOrigin() : address.get(i - 1);
                if (symbol.origin()) {
                    engage_s = engage_poo;
                }
                UDModesRenderUtils.renderSymbol(stack, yOffset, symbolPos, symbol, isDialingThisAddr, selected, engage_s, gateStatus);
                ++symbolPos;
                if (symbol.origin()) break;
            }
        }
    }

    public static void renderSymbol(PoseStack stack, int yOffset, int symbolPos, SymbolInterface symbol, boolean dialing, boolean isActive, boolean engage, EnumStargateState stargateState) {
        stack.m_85836_();
        stack.m_85837_(-0.2, -0.75, 0.0);
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        HandHeldDeviceRenderer.renderSymbol(yOffset, symbolPos, symbol, dialing, isActive, engage, stargateState);
        stack.m_85849_();
        stack.m_85849_();
    }
}

