/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.stargate;

import dev.tauri.jsg.api.item.ICreativeThing;
import dev.tauri.jsg.api.item.IIrisItem;
import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class IrisItem
extends JSGItem
implements ICreativeThing,
IIrisItem {
    public boolean creativeIris = false;
    public boolean isShield = false;
    public final EnumIrisType type;
    public int durability = 0;
    public ItemStack repairableItem = ItemStack.f_41583_;

    public static IrisItem createCreative() {
        IrisItem i = new IrisItem(new Item.Properties(), EnumIrisType.IRIS_CREATIVE);
        i.creativeIris = true;
        return i;
    }

    public static IrisItem createShield() {
        IrisItem i = new IrisItem(new Item.Properties(), EnumIrisType.SHIELD);
        i.isShield = true;
        return i;
    }

    public static IrisItem createDurability(int durability, ItemStack repairableItem, EnumIrisType type) {
        IrisItem i = new IrisItem(new Item.Properties().m_41503_(durability), type);
        i.durability = durability;
        i.repairableItem = repairableItem;
        return i;
    }

    public IrisItem(Item.Properties props, EnumIrisType type) {
        super(props, TabRegistry.TAB_UPGRADES);
        this.type = type;
    }

    @Override
    public boolean isCreativeOnly() {
        return this.creativeIris;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.creativeIris) {
            return;
        }
        if (this.isShield) {
            return;
        }
        super.setDamage(stack, damage);
        if (this.getMaxDamage(stack) <= damage) {
            stack.m_41764_(0);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_5524_(), components, tooltipFlag);
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        if (this.creativeIris) {
            return false;
        }
        if (this.isShield) {
            return false;
        }
        if (this.repairableItem == null || this.repairableItem.m_41619_()) {
            return false;
        }
        return stack.m_41720_() == this.repairableItem.m_41720_();
    }

    @Override
    public boolean isCreative() {
        return this.creativeIris;
    }

    @Override
    public boolean isShield() {
        return this.isShield;
    }

    @Override
    public EnumIrisType getType() {
        return this.type;
    }
}

