/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.tooltips;

import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.power.general.SmallEnergyStorage;
import dev.tauri.jsg.api.util.JSGItemStackHandler;
import dev.tauri.jsg.item.tooltips.ServerStargateInventoryTooltip;
import dev.tauri.jsg.loader.texture.Texture;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ClientStargateInventoryTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("jsg", "textures/gui/itemstack_container_stargate.png");
    protected final ItemStack stack;

    public ClientStargateInventoryTooltip(ServerStargateInventoryTooltip serverTooltip) {
        this.stack = serverTooltip.stack();
    }

    public int m_142103_() {
        if (!this.stack.m_41782_()) {
            return 0;
        }
        return 57;
    }

    public int m_142069_(Font font) {
        if (!this.stack.m_41782_()) {
            return 0;
        }
        return 90;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        if (!this.stack.m_41782_()) {
            return;
        }
        GuiHelper.currentStack = graphics.m_280168_();
        CompoundTag compound = this.stack.m_41784_();
        int offsetY = 0;
        InventoryRenderEnergyResult energyResult = new InventoryRenderEnergyResult(0, 0, 0);
        if (compound.m_128441_("itemHandler")) {
            JSGItemStackHandler handler = new JSGItemStackHandler(1);
            handler.deserializeNBT(compound.m_128469_("itemHandler"));
            energyResult = this.renderInventory(font, x, y, graphics, handler, compound);
            offsetY += 44;
        }
        SmallEnergyStorage energyStorage = new SmallEnergyStorage();
        if (compound.m_128441_("stargateEnergyManager")) {
            energyStorage.deserializeNBT(compound.m_128469_("stargateEnergyManager").m_128469_("energyStorage"));
        }
        this.renderEnergyStorage(font, x, y + offsetY, graphics, energyResult, energyStorage);
    }

    protected void renderEnergyStorage(Font font, int x, int y, GuiGraphics graphics, InventoryRenderEnergyResult inventoryRenderEnergyResult, SmallEnergyStorage energyStorage) {
        Texture.bindTextureWithMc(TEXTURE_LOCATION);
        GuiHelper.drawModalRectWithCustomSizedTexture(x, y, 0.0f, 44.0f, 90, 7, 128.0f, 128.0f);
        int energyStored = energyStorage.getEnergyStored() + inventoryRenderEnergyResult.additionalEnergy();
        int maxEnergyStored = energyStorage.getMaxEnergyStored() + inventoryRenderEnergyResult.additionalCapacity();
        int blockedSlots = inventoryRenderEnergyResult.blockedOutSlots();
        int maxWidth = 87;
        for (int i = 2; i >= 3 - blockedSlots; --i) {
            maxWidth -= 22;
            GuiHelper.drawModalRectWithCustomSizedTexture(x + 23 + 22 * i, y + 1, 0.0f, 52.0f, 22, 5, 128.0f, 128.0f);
        }
        int width = Math.round((float)energyStored / (float)maxEnergyStored * (float)maxWidth);
        GuiHelper.drawGradientRect(graphics.m_280168_(), x + 1, y + 1, x + 1 + width, y + 6, -3397592, -9234922);
    }

    protected InventoryRenderEnergyResult renderInventory(Font font, int x, int y, GuiGraphics graphics, JSGItemStackHandler itemStackHandler, CompoundTag compound) {
        int capacitorsCount = 3;
        int maxCapacitors = 3;
        int additionalEnergy = 0;
        int additionalCapacity = 0;
        if (compound.m_128441_("config")) {
            try {
                BEConfig config = new BEConfig(() -> {}, StargateConfigOptions.Classic.HOLDER);
                config.deserializeNBT(compound.m_128469_("config"));
                Optional<Integer> capsMaybe = config.getValue(StargateConfigOptions.Classic.MAX_CAPACITORS);
                if (capsMaybe.isPresent()) {
                    maxCapacitors = capsMaybe.get();
                }
            }
            catch (Exception config) {
                // empty catch block
            }
        }
        if (itemStackHandler.getSize() > 0) {
            capacitorsCount = 0;
            Texture.bindTextureWithMc(TEXTURE_LOCATION);
            GuiHelper.drawModalRectWithCustomSizedTexture(x, y, 0.0f, 0.0f, 90, 40, 128.0f, 128.0f);
            for (int i = 2; i >= maxCapacitors; --i) {
                GuiHelper.drawModalRectWithCustomSizedTexture(x + 1 + 18 * i, y + 23, 0.0f, 58.0f, 16, 16, 128.0f, 128.0f);
            }
            for (int slot = 0; slot < itemStackHandler.getSize(); ++slot) {
                ItemStack item = itemStackHandler.getStackInSlot(slot);
                if (slot < 4) {
                    this.renderItemStack(item, x + 18 * slot, y, graphics, font, slot);
                    continue;
                }
                if (slot < 7) {
                    this.renderItemStack(item, x + 18 * (slot - 4), y + 22, graphics, font, slot);
                    Optional energyCap = item.getCapability(ForgeCapabilities.ENERGY).resolve();
                    if (!energyCap.isPresent()) continue;
                    additionalEnergy += ((IEnergyStorage)energyCap.get()).getEnergyStored();
                    additionalCapacity += ((IEnergyStorage)energyCap.get()).getMaxEnergyStored();
                    ++capacitorsCount;
                    continue;
                }
                if (slot == 10) {
                    this.renderItemStack(item, x + 72, y + 22, graphics, font, slot);
                    continue;
                }
                if (slot != 11) continue;
                this.renderItemStack(item, x + 72, y, graphics, font, slot);
            }
        }
        if (capacitorsCount > 3) {
            capacitorsCount = 3;
        }
        return new InventoryRenderEnergyResult(additionalEnergy, additionalCapacity, 3 - capacitorsCount);
    }

    protected void renderItemStack(ItemStack item, int x, int y, GuiGraphics graphics, Font font, int slot) {
        graphics.m_280256_(item, x + 1, y + 1, slot);
        graphics.m_280370_(font, item, x + 1, y + 1);
    }

    public record InventoryRenderEnergyResult(int additionalEnergy, int additionalCapacity, int blockedOutSlots) {
    }
}

