/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.jub;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.capability.JSGCapabilities;
import dev.tauri.jsg.jub.JUB;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JUBDevice {
    protected JUB bus;
    @NotNull
    public final BlockEntity be;

    public abstract void onChanged();

    public JUBDevice(@NotNull BlockEntity be) {
        this.be = be;
    }

    public JUB getBus() {
        return this.bus;
    }

    public BlockPos getBlockPos() {
        return this.be.m_58899_();
    }

    public void disconnectFromBus() {
        this.disconnectFromBus(false);
    }

    public void disconnectFromBus(boolean silent) {
        if (this.bus != null) {
            this.bus.deviceDisconnected(this, silent);
        }
        this.bus = null;
        JSG.logger.info("Disconnected from bus!");
    }

    public void connectToBus(@NotNull JUB bus) {
        this.connectToBus(bus, false);
    }

    public void connectToBus(@NotNull JUB bus, boolean silent) {
        if (this.bus != null) {
            this.bus.deviceDisconnected(this, silent);
        }
        this.bus = bus;
        bus.deviceConnected(this, silent);
        JSG.logger.info("Connected to bus!");
    }

    protected void sendPacket(String name, Object data, @Nullable JUBDevice target) {
        JUB bus = this.getBus();
        if (bus == null) {
            return;
        }
        bus.sendPacket(name, data, target, this);
    }

    protected abstract void packetReceived(String var1, Object var2, JUBDevice var3);

    @Nullable
    public IEnergyStorage getEnergyStorage() {
        return null;
    }

    public void updateBusDevices(Level level, BlockPos posChanged) {
        boolean wasRemoved;
        BlockEntity changedBE = level.m_7702_(posChanged);
        boolean bl = wasRemoved = changedBE == null || changedBE.getCapability(JSGCapabilities.JUST_UNIVERSAL_BUS).resolve().isEmpty();
        if (wasRemoved) {
            JUB deviceBus = this.getBus();
            if (deviceBus == null) {
                return;
            }
            for (JUBDevice d : deviceBus.getConnectedDevices()) {
                if (!d.getBlockPos().equals((Object)posChanged)) continue;
                deviceBus.invalidate();
                JUB jubNew = new JUB();
                this.connectToBus(jubNew, true);
                this.updateBusConnection(this, new HashMap<BlockPos, JUBDevice>(), jubNew);
                break;
            }
        } else {
            JSG.logger.info(BlockHelper.blockPosToBetterString(posChanged));
            JUBDevice changedBECap = (JUBDevice)changedBE.getCapability(JSGCapabilities.JUST_UNIVERSAL_BUS).resolve().get();
            if (this.getBus() == null) {
                if (changedBECap.getBus() == null) {
                    changedBECap.connectToBus(new JUB());
                    this.connectToBus(changedBECap.getBus());
                } else {
                    this.connectToBus(changedBECap.getBus());
                }
            } else if (changedBECap.getBus() == null) {
                changedBECap.connectToBus(this.getBus());
            } else if (!this.getBus().equals(changedBECap.getBus())) {
                this.connectToBus(changedBECap.getBus());
            }
        }
    }

    @NotNull
    private HashMap<BlockPos, JUBDevice> updateBusConnection(JUBDevice source, HashMap<BlockPos, JUBDevice> map, JUB newBus) {
        Level level = this.be.m_58904_();
        if (level == null) {
            return map;
        }
        for (Direction dir : Direction.values()) {
            Optional capOpt;
            BlockEntity newBE;
            BlockPos newPos = source.getBlockPos().m_121955_(dir.m_122436_());
            if (map.containsKey(newPos) || (newBE = level.m_7702_(newPos)) == null || (capOpt = newBE.getCapability(JSGCapabilities.JUST_UNIVERSAL_BUS).resolve()).isEmpty()) continue;
            if (((JUBDevice)capOpt.get()).getBus() != newBus) {
                ((JUBDevice)capOpt.get()).connectToBus(newBus, true);
            }
            map.put(newPos, (JUBDevice)capOpt.get());
            this.updateBusConnection((JUBDevice)capOpt.get(), map, newBus);
        }
        return map;
    }
}

