/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.listener;

import dev.tauri.jsg.api.block.util.IHighlightBlock;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import dev.tauri.jsg.screen.gui.sggenerator.LevelGenerationScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientListener {
    public static boolean initMainMenu = true;

    @SubscribeEvent
    public static void onDrawHighlight(RenderHighlightEvent.Block event) {
        Level level = event.getCamera().m_90592_().m_9236_();
        BlockPos pos = event.getTarget().m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        boolean cancelled = false;
        if (block instanceof IHighlightBlock) {
            IHighlightBlock hb = (IHighlightBlock)block;
            cancelled = !hb.renderHighlight(state, (BlockGetter)level, pos);
        }
        event.setCanceled(cancelled);
    }

    @SubscribeEvent
    public static void onSounds(PlaySoundEvent event) {
        if (event.getSound() != null && event.getSound().m_7904_().toString().equalsIgnoreCase("minecraft:music.menu")) {
            event.setSound(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGuiOpen(ScreenEvent.Opening event) {
        if (!event.isCanceled() && event.getScreen() instanceof LevelLoadingScreen) {
            event.setNewScreen((Screen)new LevelGenerationScreen());
            return;
        }
        if (!JSGConfig.General.disableJSGMainMenu.get() && !event.isCanceled() && event.getCurrentScreen() instanceof TitleScreen) {
            event.setNewScreen((Screen)new GuiCustomMainMenu());
            if (initMainMenu) {
                GuiCustomMainMenu.menuDisplayed = -1L;
                initMainMenu = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGuiOpen(ScreenEvent.Init.Post event) {
        if (!event.isCanceled() && event.getScreen() instanceof LevelLoadingScreen) {
            Minecraft.m_91087_().m_91346_((Screen)new LevelGenerationScreen());
            return;
        }
        if (!JSGConfig.General.disableJSGMainMenu.get() && !event.isCanceled() && event.getScreen() instanceof TitleScreen) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiCustomMainMenu());
            if (initMainMenu) {
                GuiCustomMainMenu.menuDisplayed = -1L;
                initMainMenu = false;
            }
        }
    }
}

