/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.listener;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.entity.behaviour.DialGateBehaviour;
import dev.tauri.jsg.helpers.registry.block.OreBlockVariant;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.VillagerRegistry;
import dev.tauri.jsg.registry.util.VillagerUtil;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.util.CreativeItemsChecker;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeListener {
    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent e) {
        Player p = e.getEntity();
        ItemStack i = e.getItem().m_32055_();
        if (CreativeItemsChecker.canInteractWith(i, p.m_7500_())) {
            return;
        }
        e.setCanceled(true);
    }

    @SubscribeEvent
    public static void onClickWithCrystalSeed(PlayerInteractEvent.RightClickBlock e) {
        Map<CrystalColor, RegistryObject<Block>> newBlockMap;
        if (e.getUseItem() == Event.Result.ALLOW) {
            return;
        }
        if (e.getUseBlock() == Event.Result.ALLOW) {
            return;
        }
        ItemStack item = e.getEntity().m_21120_(e.getHand());
        if (item.m_41619_()) {
            return;
        }
        BlockHitResult bHit = e.getHitVec();
        BlockState block = e.getLevel().m_8055_(bHit.m_82425_());
        if (block.m_60795_()) {
            return;
        }
        OreBlockVariant crystalBuddingBase = OreBlockVariant.fromBlock(block, () -> BlockRegistry.CRYSTAL_BLOCK);
        if (crystalBuddingBase == null) {
            return;
        }
        CrystalColor crystalItemColor = CrystalColor.fromItem(item, () -> ItemRegistry.CRYSTAL_SEEDS);
        if (crystalBuddingBase == OreBlockVariant.SELF) {
            CrystalColor crystalBlockColor = CrystalColor.fromBlock(block, () -> BlockRegistry.CRYSTAL_BLOCK);
            if (crystalBlockColor == null) {
                return;
            }
            if (crystalBlockColor != crystalItemColor) {
                return;
            }
        }
        if ((newBlockMap = BlockRegistry.UNSTABLE_CRYSTAL_BUDDING.get((Object)crystalBuddingBase)) == null) {
            return;
        }
        RegistryObject<Block> newBlock = newBlockMap.get((Object)crystalItemColor);
        if (newBlock == null) {
            return;
        }
        if (!e.getEntity().m_7500_()) {
            item.m_41774_(1);
        }
        BlockState newState = (BlockState)((Block)newBlock.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0));
        e.getLevel().m_7731_(bHit.m_82425_(), newState, 3);
        e.getLevel().m_5594_(null, bHit.m_82425_(), SoundEvents.f_144048_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void onVillagerSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (!(mob instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)mob;
        if (VillagerRegistry.isPriest(villager.m_7141_().m_35571_())) {
            villager.m_6274_().m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new DialGateBehaviour()))));
        }
        if (villager.m_7141_().m_35571_() == VillagerRegistry.SLAVE_MINER.get()) {
            villager.m_6274_().m_21903_(Activity.f_37980_, VillagerUtil.getWorkPackageForSlave(blockState -> BlockRegistry.ORE_NAQUADAH.values().stream().map(RegistryObject::get).anyMatch(block -> block == blockState.m_60734_()), 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT)));
            villager.m_35311_().m_6836_(0, new ItemStack((ItemLike)Items.f_42385_));
        }
        VillagerRegistry.checkAndGetCustomType(villager).ifPresent(villagerType -> villager.m_34375_(villager.m_7141_().m_35567_(villagerType)));
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        VillagerRegistry.registerTrades(event);
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        DHDAbstractBE dhdTile;
        boolean isSnowball = event.getProjectile() instanceof Snowball;
        HitResult result = event.getRayTraceResult();
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        BlockEntity be = event.getProjectile().m_9236_().m_7702_(BlockPos.m_274446_((Position)event.getRayTraceResult().m_82450_()));
        BlockEntity be2 = event.getProjectile().m_9236_().m_7702_(BlockPos.m_274446_((Position)event.getRayTraceResult().m_82450_().m_82520_(0.0, -1.0, 0.0)));
        if (!(be instanceof DHDAbstractBE)) {
            if (!(be2 instanceof DHDAbstractBE)) {
                return;
            }
            DHDAbstractBE dhdTile2 = (DHDAbstractBE)be2;
            dhdTile = dhdTile2;
        } else {
            DHDAbstractBE dhdTile1 = (DHDAbstractBE)be;
            dhdTile = dhdTile1;
        }
        if (!dhdTile.isLinked()) {
            return;
        }
        Object gate = dhdTile.getLinkedDevice();
        if (gate != null) {
            if (((StargateAbstractDialingManager)((StargateAbstractBaseBE)gate).getDialingManager()).getDialedAddress().size() == 6) {
                dhdTile.pushSymbolButton((SymbolInterface)dhdTile.getSymbolType().getOrigin(), null, false);
                return;
            }
            if (((StargateAbstractDialingManager)((StargateAbstractBaseBE)gate).getDialingManager()).getDialedAddress().size() == 7 && dhdTile.getSymbolType().getBRB() != null) {
                dhdTile.pushSymbolButton((SymbolInterface)dhdTile.getSymbolType().getBRB(), null, false);
                return;
            }
        }
        int symbolsCount = isSnowball ? 3 : 1;
        Random r = new Random();
        for (int i = 0; i < symbolsCount; ++i) {
            dhdTile.pushSymbolButton((SymbolInterface)dhdTile.getSymbolType().getRandomSymbol(r), null, false);
        }
    }
}

