/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader;

import dev.tauri.jsg.JSG;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;

public class FolderLoader {
    public static List<String> getAllFiles(Class<?> clazz, String modId, String path, String ... suffixes) throws IOException {
        ArrayList<String> out = new ArrayList<String>();
        AtomicReference<File> jarFile = new AtomicReference<File>();
        ModList.get().getModContainerById(modId).ifPresentOrElse(container -> jarFile.set(container.getModInfo().getOwningFile().getFile().getFilePath().toFile()), () -> {});
        if (jarFile.get() == null) {
            return out;
        }
        String classPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        int separatorIndex = classPath.lastIndexOf("!");
        if (separatorIndex != -1 && classPath.lastIndexOf(".jar") != -1) {
            JarFile jar = new JarFile(jarFile.get());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || !FolderLoader.endsWith(name, suffixes)) continue;
                out.add(name);
            }
            jar.close();
        } else {
            JSG.logger.info("We are in dev environment... Opening normal folder...");
            FolderLoader.getAllFilesDev(jarFile, out, suffixes);
        }
        return out;
    }

    private static boolean endsWith(String in, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!in.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static void getAllFilesDev(AtomicReference<File> jarFile, List<String> out, String ... suffixes) throws IOException {
        File resDir = new File(jarFile.get().getParentFile(), "main/");
        try (Stream<Path> stream = Files.walk(resDir.toPath(), new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> FolderLoader.endsWith(f.toFile().getName(), suffixes)).map(f -> resDir.toPath().relativize((Path)f)).forEach(f -> out.add(f.toString().replace('\\', '/')));
        }
    }
}

