/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.NativeImage;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginsLoader;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.loader.model.OBJLoader;
import dev.tauri.jsg.loader.texture.Texture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.progress.ProgressMeter;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public class PointOfOriginsLoader
implements IPointOfOriginsLoader {
    private final LoadersHolder loaders;
    @Nullable
    private File configFolder;
    private final Map<String, IPointOfOriginType> TYPES_TO_LOAD = new HashMap<String, IPointOfOriginType>();
    private final Map<IPointOfOriginType, Map<ResourceLocation, PointOfOrigin>> LOADED_ORIGINS = new HashMap<IPointOfOriginType, Map<ResourceLocation, PointOfOrigin>>();
    private final Map<IPointOfOriginType, List<ResourceLocation>> ORIGINS_TO_LOAD = new HashMap<IPointOfOriginType, List<ResourceLocation>>();

    public PointOfOriginsLoader(LoadersHolder loaders, @Nullable File configFolder) {
        this.loaders = loaders;
        this.configFolder = configFolder;
    }

    public void setConfigFolder(File configFolder) {
        this.configFolder = configFolder;
    }

    @Override
    public Optional<Map<ResourceLocation, PointOfOrigin>> getLoadedOrigins(IPointOfOriginType type) {
        return Optional.ofNullable(this.LOADED_ORIGINS.get(type));
    }

    @Override
    public Map<IPointOfOriginType, Map<ResourceLocation, PointOfOrigin>> getLoadedOrigins() {
        return new HashMap<IPointOfOriginType, Map<ResourceLocation, PointOfOrigin>>(this.LOADED_ORIGINS);
    }

    @Override
    public Map<IPointOfOriginType, List<ResourceLocation>> getRegisteredPointOfOrigins() {
        return new HashMap<IPointOfOriginType, List<ResourceLocation>>(this.ORIGINS_TO_LOAD);
    }

    @Override
    public void registerPoOType(IPointOfOriginType type) {
        this.TYPES_TO_LOAD.put(type.getPoONamespaceIdentifier(), type);
    }

    @Override
    public Optional<IPointOfOriginType> getPoOType(String namespace) {
        return Optional.ofNullable(this.TYPES_TO_LOAD.get(namespace));
    }

    @Override
    public void loadServer() {
        this.ORIGINS_TO_LOAD.clear();
        if (this.configFolder == null) {
            return;
        }
        File jsonFile = new File(this.configFolder, "jsg/PointOfOrigins.json");
        if (!jsonFile.exists()) {
            this.writeServer(jsonFile, (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
                for (IPointOfOriginType type : this.TYPES_TO_LOAD.values()) {
                    map.put(type.getPoONamespaceIdentifier(), type.getPoODefaults().stream().map(ResourceLocation::toString).toList());
                }
            }));
        }
        if (!jsonFile.exists()) {
            JSG.logger.error("Error while trying to read origins: FILE NOT FOUND");
            return;
        }
        try (FileReader fr = new FileReader(jsonFile);){
            Type jsonType = new TypeToken<Map<String, List<String>>>(){}.getType();
            HashMap<String, List<String>> inputMap = new HashMap<String, List<String>>((Map)new GsonBuilder().create().fromJson((Reader)fr, jsonType));
            boolean changed = false;
            for (IPointOfOriginType defaultType : this.TYPES_TO_LOAD.values()) {
                String typeId = defaultType.getPoONamespaceIdentifier();
                if (!inputMap.containsKey(typeId) || ((List)inputMap.get(typeId)).isEmpty()) {
                    inputMap.put(typeId, defaultType.getPoODefaults().stream().map(ResourceLocation::toString).toList());
                    changed = true;
                }
                this.ORIGINS_TO_LOAD.put(defaultType, ((List)inputMap.get(typeId)).stream().map(ResourceLocation::new).toList());
            }
            if (this.tryLoadAddons(inputMap) || changed) {
                this.writeServer(jsonFile, inputMap);
            }
        }
        catch (Exception e) {
            JSG.logger.error("Error while trying to read origins:", e);
        }
    }

    protected boolean tryLoadAddons(Map<String, List<String>> jsgPoOMap) {
        if (this.configFolder == null) {
            return false;
        }
        File assetsFolder = new File(this.configFolder.getParentFile(), "assets/");
        if (!assetsFolder.exists() || !assetsFolder.isDirectory()) {
            return false;
        }
        Type jsonType = new TypeToken<Map<String, List<String>>>(){}.getType();
        AtomicBoolean changed = new AtomicBoolean(false);
        Arrays.stream(Objects.requireNonNull(assetsFolder.listFiles(File::isDirectory))).forEach(namespaceFolder -> {
            File loaderJson = new File((File)namespaceFolder, "/loader/PointOfOrigins.json");
            if (!loaderJson.exists()) {
                return;
            }
            try (FileReader addonJson = new FileReader(loaderJson);){
                HashMap addonInputMap = new HashMap((Map)new GsonBuilder().create().fromJson((Reader)addonJson, jsonType));
                for (IPointOfOriginType defaultType : this.TYPES_TO_LOAD.values()) {
                    String typeId = defaultType.getPoONamespaceIdentifier();
                    if (!addonInputMap.containsKey(typeId) || ((List)addonInputMap.get(typeId)).isEmpty()) continue;
                    List jsgPoOTypeList = jsgPoOMap.getOrDefault(typeId, new ArrayList());
                    jsgPoOTypeList.addAll(((List)addonInputMap.get(typeId)).stream().filter(origin -> !jsgPoOTypeList.contains(origin)).toList());
                    jsgPoOMap.put(typeId, jsgPoOTypeList);
                    changed.set(true);
                    this.ORIGINS_TO_LOAD.put(defaultType, ((List)jsgPoOMap.get(typeId)).stream().map(ResourceLocation::new).toList());
                }
            }
            catch (Exception e) {
                JSG.logger.error("Error while trying to read origins from addon {}:", (Object)namespaceFolder.getName(), (Object)e);
            }
            if (!loaderJson.delete()) {
                JSG.logger.error("Failed to delete addon's PoO loader file {}", (Object)loaderJson.getAbsolutePath());
            }
        });
        return changed.get();
    }

    private void writeServer(File jsonFile, Map<String, List<String>> outputMap) {
        Type jsonType = new TypeToken<Map<String, List<String>>>(){}.getType();
        String outputJson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2, 4}).create().toJson(outputMap, jsonType);
        try (FileWriter fw = new FileWriter(jsonFile);){
            fw.write(outputJson);
        }
        catch (Exception e) {
            JSG.logger.error("Error while trying to write origins:", e);
        }
    }

    @Override
    public int getTotalCount() {
        int count = 0;
        for (Map.Entry<IPointOfOriginType, List<ResourceLocation>> e : this.ORIGINS_TO_LOAD.entrySet()) {
            count += e.getValue().size();
        }
        return count;
    }

    @Override
    public void loadResources(ProgressMeter progressMeter) {
        if (this.configFolder == null) {
            return;
        }
        HashMap<IPointOfOriginType, Map> map = new HashMap<IPointOfOriginType, Map>();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        for (Map.Entry<IPointOfOriginType, List<ResourceLocation>> typeEntry : this.ORIGINS_TO_LOAD.entrySet()) {
            IPointOfOriginType type = typeEntry.getKey();
            List<ResourceLocation> originsLocations = typeEntry.getValue();
            Map typeMap = map.getOrDefault(type, new HashMap());
            for (ResourceLocation originLocation : originsLocations) {
                String olNamespace = originLocation.m_135827_();
                String olPath = originLocation.m_135815_();
                String texturesPath = "textures/point_of_origins/" + type.getPoONamespaceIdentifier() + "/" + olPath + "/";
                File texturesLoc = new File(this.configFolder.getParentFile(), "assets/" + olNamespace + "/" + texturesPath);
                for (String texType : type.getPoOTexturesTypes()) {
                    File texLoc = new File(texturesLoc, texType);
                    ResourceLocation texResourceLocation = new ResourceLocation(olNamespace, texturesPath + texType);
                    try {
                        InputStream inputStream = this.getInputStreamForResource(texLoc, texResourceLocation, resourceManager);
                        try {
                            NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
                            this.loaders.texture().putTexture(texResourceLocation, new Texture(image, texResourceLocation));
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        JSG.logger.error("Error while loading resource " + String.valueOf(texResourceLocation) + " at " + texLoc.getAbsolutePath(), e);
                    }
                }
                String modelsPath = "models/point_of_origins/" + type.getPoONamespaceIdentifier() + "/" + olPath + "/";
                File modelsLoc = new File(this.configFolder.getParentFile(), "assets/" + olNamespace + "/" + modelsPath);
                for (String modelType : type.getPoOModelsTypes()) {
                    File modelLoc = new File(modelsLoc, modelType);
                    ResourceLocation modelResourceLocation = new ResourceLocation(olNamespace, modelsPath + modelType);
                    try {
                        InputStream inputStream = this.getInputStreamForResource(modelLoc, modelResourceLocation, resourceManager);
                        try {
                            this.loaders.model().putModel(modelResourceLocation, OBJLoader.loadModel(inputStream));
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        JSG.logger.error("Error while loading resource " + String.valueOf(modelResourceLocation) + " at " + modelLoc.getAbsolutePath(), e);
                    }
                }
                typeMap.put(originLocation, new PointOfOrigin(originLocation, type));
                progressMeter.increment();
            }
            map.put(type, typeMap);
        }
        this.LOADED_ORIGINS.putAll(map);
    }

    @Override
    @Nullable
    public PointOfOrigin getOriginFor(IPointOfOriginType type, ResourceKey<Level> dimension, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlayInstance) {
        return StargateDimensionConfig.INSTANCE.getOrigin(type, dimension, biomeOverlayInstance);
    }

    private InputStream getInputStreamForResource(File assetsLocation, ResourceLocation localLocation, ResourceManager resourceManager) throws IOException {
        if (!assetsLocation.exists()) {
            Optional localResource = resourceManager.m_213713_(localLocation);
            if (localResource.isEmpty()) {
                throw new IOException("localResource is empty");
            }
            return ((Resource)localResource.get()).m_215507_();
        }
        return new FileInputStream(assetsLocation);
    }
}

