/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.model;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.client.model.IModelLoader;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.loader.FolderLoader;
import dev.tauri.jsg.loader.model.OBJLoader;
import dev.tauri.jsg.loader.model.OBJModel;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import org.jetbrains.annotations.NotNull;

public class ModelLoader
implements IModelLoader {
    private final String modId;
    private final Class<?> modMainClass;
    public final String modelsPath;
    private final Map<ResourceLocation, OBJModel> LOADED_MODELS = new HashMap<ResourceLocation, OBJModel>();
    public static final OBJModel EMPTY_MODEL = new OBJModel(new float[0], new float[0], new float[0], new int[0]);

    public ModelLoader(String modId, Class<?> modMainClass) {
        this.modId = modId;
        this.modMainClass = modMainClass;
        this.modelsPath = "assets/" + modId + "/models/tesr";
        JSG.logger.info("Created ModelLoader for domain {}", (Object)modId);
    }

    @Override
    @NotNull
    public OBJModel getModel(ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return EMPTY_MODEL;
        }
        OBJModel model = this.LOADED_MODELS.get(resourceLocation);
        if (model == null) {
            return EMPTY_MODEL;
        }
        return model;
    }

    @Override
    public boolean isModelLoaded(ResourceLocation resourceLocation) {
        return this.LOADED_MODELS.containsKey(resourceLocation);
    }

    @Override
    public void loadModels() {
        AtomicReference<String> modName = new AtomicReference<String>("");
        ModList.get().getModContainerById(this.modId).ifPresentOrElse(container -> modName.set(container.getModInfo().getDisplayName()), () -> {});
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            this.LOADED_MODELS.clear();
            List<String> modelPaths = FolderLoader.getAllFiles(this.modMainClass, this.modId, this.modelsPath, ".obj");
            long start = System.currentTimeMillis();
            ProgressMeter progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - Loading Models"), (int)modelPaths.size());
            JSG.logger.info("Started loading models for domain {}...", (Object)this.modId);
            for (String modelPath : modelPaths) {
                if (JSGConfig.Debug.logLoadingTextures.get()) {
                    JSG.logger.info("Loading model: {} for domain {}", (Object)modelPath, (Object)this.modId);
                }
                String modelResourcePath = modelPath.replaceFirst("assets/" + this.modId + "/", "");
                ResourceLocation location = new ResourceLocation(this.modId, modelResourcePath);
                Resource resource = (Resource)resourceManager.m_213713_(location).orElseThrow();
                InputStream stream = resource.m_215507_();
                this.LOADED_MODELS.put(location, OBJLoader.loadModel(stream));
                stream.close();
                ++JSG.ClientModEvents.LoadingStats.loadedModels;
                if (JSGConfig.Debug.logLoadingTextures.get()) {
                    JSG.logger.info("Model {} for domain {} loaded!", (Object)modelPath, (Object)this.modId);
                }
                progress.increment();
                StartupNotificationManager.addModMessage((String)("Loaded " + this.modId + ":" + modelResourcePath.replaceFirst("textures/tesr/", "")));
            }
            progress.complete();
            JSG.logger.info("Loaded {} models for domain {} in {} ms", modelPaths.size(), this.modId, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            JSG.logger.error("Error while loading models for mod {}", (Object)this.modMainClass.toString(), (Object)e);
            ++JSG.ClientModEvents.LoadingStats.notLoadedModels;
        }
    }

    @Override
    public ResourceLocation getModelResource(String model) {
        return new ResourceLocation(this.modId, "models/tesr/" + model);
    }

    @Override
    public void putModel(ResourceLocation resourceLocation, AbstractOBJModel model) {
        this.LOADED_MODELS.put(resourceLocation, (OBJModel)model);
    }
}

