/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.client.texture.ITexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Texture
extends DynamicTexture
implements ITexture {
    public static Texture EMPTY_TEXTURE = null;
    private final ResourceLocation resourceLocation;

    public Texture(NativeImage image, ResourceLocation resourceLocation) {
        super(image);
        this.resourceLocation = resourceLocation;
        Minecraft.m_91087_().m_91097_().m_118495_(resourceLocation, (AbstractTexture)this);
    }

    public static Texture getEmptyTexture() {
        if (EMPTY_TEXTURE == null) {
            EMPTY_TEXTURE = new Texture(new NativeImage(16, 16, false), new ResourceLocation("jsg", "null"));
        }
        return EMPTY_TEXTURE;
    }

    @Override
    public void bindTexture() {
        AbstractOBJModel.setActiveTexture(this.resourceLocation);
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
                GlStateManager._bindTexture((int)this.m_117963_());
            });
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
            GlStateManager._bindTexture((int)this.m_117963_());
        }
    }

    public void deleteTexture() {
        super.close();
    }

    public static void bindTextureWithMc(ResourceLocation location) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
    }
}

