/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.texture;

import com.mojang.blaze3d.platform.NativeImage;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.loader.FolderLoader;
import dev.tauri.jsg.loader.texture.Texture;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;

public class TextureLoader
implements ITextureLoader {
    private final String modId;
    private final Class<?> modMainClass;
    public final String texturesPath;
    private final Map<ResourceLocation, Texture> LOADED_TEXTURES = new HashMap<ResourceLocation, Texture>();

    public TextureLoader(String modId, Class<?> modMainClass) {
        this.modId = modId;
        this.modMainClass = modMainClass;
        this.texturesPath = "assets/" + modId + "/textures/tesr";
        JSG.logger.info("Created TextureLoader for domain {}", (Object)modId);
    }

    @Override
    public Texture getTexture(ResourceLocation resourceLocation) {
        Texture tex = this.LOADED_TEXTURES.get(resourceLocation);
        if (tex == null) {
            return Texture.getEmptyTexture();
        }
        return tex;
    }

    @Override
    public boolean isTextureLoaded(ResourceLocation resourceLocation) {
        return this.LOADED_TEXTURES.containsKey(resourceLocation);
    }

    @Override
    public void loadTextures() {
        AtomicReference<String> modName = new AtomicReference<String>("");
        ModList.get().getModContainerById(this.modId).ifPresentOrElse(container -> modName.set(container.getModInfo().getDisplayName()), () -> {});
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            for (Texture texture : this.LOADED_TEXTURES.values()) {
                texture.deleteTexture();
            }
            this.LOADED_TEXTURES.clear();
            ArrayList<String> texturePaths = new ArrayList<String>();
            ArrayList<String> ehPaths = new ArrayList<String>();
            for (String texturePath : FolderLoader.getAllFiles(this.modMainClass, this.modId, this.texturesPath, ".png", ".jpg")) {
                if ((texturePath = texturePath.replaceFirst("assets/" + this.modId + "/", "")).contains("animated")) {
                    ehPaths.add(texturePath);
                    continue;
                }
                texturePaths.add(texturePath);
            }
            long start = System.currentTimeMillis();
            ProgressMeter progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - Loading Textures"), (int)texturePaths.size());
            JSG.logger.info("Started loading textures for domain {}...", (Object)this.modId);
            for (String texturePath : texturePaths) {
                this.loadTexture(progress, texturePath, resourceManager);
            }
            progress.complete();
            JSG.logger.info("Loaded {} textures for domain {} in {} ms", texturePaths.size(), this.modId, System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - Animated Textures"), (int)ehPaths.size());
            JSG.logger.info("Started loading animated textures for domain {}...", (Object)this.modId);
            for (String texturePath : ehPaths) {
                this.loadTexture(progress, texturePath, resourceManager);
            }
            progress.complete();
            JSG.logger.info("Loaded {} animated textures for domain {} in {} ms", ehPaths.size(), this.modId, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            JSG.logger.error("Failed to load texture ", e);
        }
    }

    protected void loadTexture(ProgressMeter progress, String texturePath, ResourceManager resourceManager) {
        texturePath = texturePath.replaceFirst("assets/" + this.modId + "/", "");
        ResourceLocation resourceLocation = new ResourceLocation(this.modId, texturePath);
        try {
            if (JSGConfig.Debug.logLoadingTextures.get()) {
                JSG.logger.info("Loading texture: {} for domain {}", (Object)texturePath, (Object)this.modId);
            }
            Resource resource = (Resource)resourceManager.m_213713_(resourceLocation).orElseThrow();
            InputStream stream = resource.m_215507_();
            NativeImage image = NativeImage.m_85058_((InputStream)stream);
            this.LOADED_TEXTURES.put(resourceLocation, new Texture(image, resourceLocation));
            if (texturePath.contains("template")) {
                this.saveTransparentEH(image, texturePath, resourceManager);
            }
            ++JSG.ClientModEvents.LoadingStats.loadedTextures;
            if (JSGConfig.Debug.logLoadingTextures.get()) {
                JSG.logger.info("Texture {} for domain {} loaded!", (Object)texturePath, (Object)this.modId);
            }
            progress.increment();
            StartupNotificationManager.addModMessage((String)("Loaded " + this.modId + ":" + texturePath.replaceFirst("textures/tesr/", "")));
        }
        catch (IOException e) {
            ++JSG.ClientModEvents.LoadingStats.notLoadedTextures;
            JSG.logger.error("Failed to load texture {}", (Object)texturePath, (Object)e);
        }
    }

    @Override
    public ResourceLocation getTextureResource(String texture) {
        return new ResourceLocation(this.modId, "textures/tesr/" + texture);
    }

    @Override
    public void putTexture(ResourceLocation resourceLocation, ITexture texture) {
        this.LOADED_TEXTURES.put(resourceLocation, (Texture)texture);
    }

    private void saveTransparentEH(NativeImage image, String name, ResourceManager resourceManager) throws IOException {
        long start;
        name = name.replaceFirst("template", "overlay").replaceFirst("\\.jpg", ".png");
        File file = new File(JSG.modConfigDir.getParentFile(), "/assets/" + this.modId + "/textures/generated/" + name.replaceFirst("textures/", ""));
        ResourceLocation resourceLocation = new ResourceLocation(this.modId, name);
        Optional resourceOpt = resourceManager.m_213713_(resourceLocation);
        if (resourceOpt.isPresent()) {
            long start2 = System.currentTimeMillis();
            JSG.logger.info("Loading event horizon texture overlay from Resource Pack... ({})", (Object)name);
            this.LOADED_TEXTURES.put(resourceLocation, new Texture(NativeImage.m_85058_((InputStream)((Resource)resourceOpt.get()).m_215507_()), resourceLocation));
            JSG.logger.info("Texture from RP ({}) loaded in {} ms", (Object)name, (Object)(System.currentTimeMillis() - start2));
            StartupNotificationManager.addModMessage((String)("Loaded " + name));
            return;
        }
        if (!file.exists()) {
            start = System.currentTimeMillis();
            JSG.logger.info("Creating event horizon texture overlay... ({})", (Object)name);
            NativeImage ehTransparent = new NativeImage(image.m_84982_(), image.m_85084_(), false);
            for (int x = 0; x < image.m_84982_(); ++x) {
                for (int y = 0; y < image.m_85084_(); ++y) {
                    Color pixelRGBA = new Color(image.m_84985_(x, y), false);
                    int rgba = 0xFFFFFF | pixelRGBA.getBlue() << 24;
                    ehTransparent.m_84988_(x, y, rgba);
                }
            }
            boolean ignored = file.getParentFile().mkdirs();
            ehTransparent.m_85056_(file);
            ehTransparent.close();
            JSG.logger.info("Event horizon texture overlay ({}) created in {} ms", (Object)name, (Object)(System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        JSG.logger.info("Loading previously generated texture... ({})", (Object)name);
        InputStream stream = file.toURI().toURL().openStream();
        this.LOADED_TEXTURES.put(resourceLocation, new Texture(NativeImage.m_85058_((InputStream)stream), resourceLocation));
        JSG.logger.info("Texture ({}) loaded in {} ms", (Object)name, (Object)(System.currentTimeMillis() - start));
        StartupNotificationManager.addModMessage((String)("Loaded generated " + name));
    }
}

