/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.multistructure.mergehelper;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.multistructure.merging.IMergeHelper;
import dev.tauri.jsg.api.stargate.StargateSizeEnum;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.block.stargate.StargateAbstractBaseBlock;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractMemberBE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public abstract class StargateAbstractMergeHelper
implements IMergeHelper,
ITickable {
    public static final JSGAxisAlignedBB BASE_SEARCH_BOX_SMALL = new JSGAxisAlignedBB(-3.0, -7.0, -0.5, 3.0, 7.0, 0.5);
    public static final JSGAxisAlignedBB BASE_SEARCH_BOX_LARGE = new JSGAxisAlignedBB(-5.0, -9.0, -0.5, 5.0, 9.0, 0.5);
    public Direction horizontalFacing = Direction.SOUTH;
    public Direction verticalFacing = Direction.SOUTH;
    public BlockPos basePos;
    public final StargateAbstractBaseBE stargate;
    public StargateSizeEnum stargateSize = StargateSizeEnum.MEDIUM;
    private BlockPos topBlock = null;
    private BlockPos topBlockAboveBase = null;

    public static JSGAxisAlignedBB getSearchBox(@Nonnull StargateSizeEnum size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSizeEnum.SMALL, StargateSizeEnum.MEDIUM -> BASE_SEARCH_BOX_SMALL;
            case StargateSizeEnum.LARGE -> BASE_SEARCH_BOX_LARGE;
        };
    }

    @Override
    public void tick(@NotNull Level level) {
        BlockState state = this.stargate.m_58900_();
        if (state.m_60734_() instanceof StargateAbstractBaseBlock && (this.horizontalFacing != state.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY) || this.verticalFacing != JSGProperties.getDirectionByVerticalFacing((Integer)state.m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY)) || this.basePos != this.stargate.m_58899_())) {
            this.horizontalFacing = (Direction)state.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
            this.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)state.m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
            this.basePos = this.stargate.m_58899_();
        }
    }

    @Nullable
    public static StargateAbstractBaseBE findBaseTile(Level level, BlockPos memberPos, Direction facing, Direction verticalFacing, Block baseBlock) {
        JSGAxisAlignedBB globalBox = StargateAbstractMergeHelper.getSearchBox(JSGConfig.Stargate.stargateSize.get()).rotate(facing, verticalFacing).offset(memberPos);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)globalBox.getMinBlockPos(), (BlockPos)globalBox.getMaxBlockPos())) {
            if (level.m_8055_(pos).m_60734_() != baseBlock) continue;
            return (StargateAbstractBaseBE)level.m_7702_(pos);
        }
        return null;
    }

    public StargateAbstractMergeHelper(@Nonnull StargateAbstractBaseBE stargate) {
        this.stargate = stargate;
    }

    public abstract List<BlockPos> getRings();

    public abstract Block getRingBlock();

    @Override
    public Map<BlockPos, BlockState> getBlocks() {
        return this.getBlocks(true);
    }

    public Map<BlockPos, BlockState> getBlocks(boolean offsetAndRotate) {
        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
        Iterator<BlockPos> iterator = this.getRings().iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            BlockPos newPos = pos = iterator.next();
            if (offsetAndRotate) {
                newPos = this.stargate.relative(pos);
            }
            map.put(newPos, (BlockState)((BlockState)((BlockState)this.getRingBlock().m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)this.horizontalFacing)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(this.verticalFacing)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(offsetAndRotate && Objects.requireNonNull(this.stargate.m_58904_()).m_6425_(newPos).m_76152_() == Fluids.f_76193_)));
        }
        return map;
    }

    @Override
    public BlockPos getTopBlock() {
        if (this.topBlock == null) {
            this.topBlock = BlockHelper.getHighest(this.getBlocks(false).keySet().stream().toList());
        }
        if (this.topBlock == null) {
            return this.basePos;
        }
        return this.stargate.relative(this.topBlock);
    }

    @Override
    public BlockPos getTopBlockAboveBase() {
        if (this.topBlockAboveBase == null) {
            this.topBlockAboveBase = BlockHelper.getHighestWithXZCords(this.getBlocks(false).keySet().stream().toList(), 0, 0);
        }
        if (this.topBlockAboveBase == null) {
            return this.basePos;
        }
        return this.stargate.relative(this.topBlockAboveBase);
    }

    @Override
    public boolean shouldBeMerged() {
        return this.stargate.isMerged();
    }

    @Override
    public boolean checkMergeState() {
        Level level = this.stargate.m_58904_();
        if (level == null) {
            return false;
        }
        boolean shouldBeMerged = true;
        for (Map.Entry<BlockPos, BlockState> entry : this.getBlocks().entrySet()) {
            BlockState state = level.m_8055_(entry.getKey());
            if (state.m_60734_() == entry.getValue().m_60734_() && state.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY) == entry.getValue().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY) && ((Integer)state.m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY)).equals(entry.getValue().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY))) continue;
            shouldBeMerged = false;
            break;
        }
        return shouldBeMerged;
    }

    @Override
    public void updateMemberStateAndCheck(Boolean force) {
        boolean shouldBeMerged;
        Level level = this.stargate.m_58904_();
        if (level == null) {
            return;
        }
        boolean bl = shouldBeMerged = force != null ? force.booleanValue() : this.checkMergeState();
        if (shouldBeMerged != this.stargate.isMerged()) {
            if (shouldBeMerged) {
                this.stargate.onGateMerged();
            } else {
                this.stargate.onGateBroken();
            }
            this.stargate.setMerged(shouldBeMerged);
            this.stargate.m_6596_();
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.getBlocks().entrySet()) {
            BlockState state = level.m_8055_(entry.getKey());
            if (state.m_60734_() != entry.getValue().m_60734_()) continue;
            BlockEntity be = level.m_7702_(entry.getKey());
            if (be instanceof StargateAbstractMemberBE) {
                StargateAbstractMemberBE castedBe = (StargateAbstractMemberBE)be;
                castedBe.setBaseTile(shouldBeMerged ? this.stargate.m_58899_() : null);
            }
            if ((Boolean)state.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != shouldBeMerged) continue;
            level.m_7731_(entry.getKey(), (BlockState)state.m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(!shouldBeMerged)), 3);
        }
        this.stargate.m_6596_();
    }

    @Nonnull
    public Block getMatchBlock(boolean chevron) {
        return this.getRingBlock();
    }

    @Override
    @Nonnull
    public List<IMergeHelper.MemberAutoBuildBlock> getAbsentBlockPositions(Level world, boolean chevron) {
        ArrayList<IMergeHelper.MemberAutoBuildBlock> result = new ArrayList<IMergeHelper.MemberAutoBuildBlock>();
        Block matchBlock = this.getMatchBlock(chevron);
        for (Map.Entry<BlockPos, BlockState> e : this.getBlocks().entrySet()) {
            BlockPos pos;
            if (e.getValue().m_60734_() != matchBlock || !world.m_8055_(pos = e.getKey()).m_247087_() && !world.m_8055_(pos).m_60795_()) continue;
            result.add(new IMergeHelper.MemberAutoBuildBlock(pos, e.getValue()));
        }
        return result;
    }

    @Override
    public Direction getHorizontalFacing() {
        return this.horizontalFacing;
    }

    @Override
    public Direction getVerticalFacing() {
        return this.verticalFacing;
    }
}

