/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.packet.PositionedPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class LinkChangedStateToClient
extends PositionedPacket {
    BlockPos linkedPos;

    public LinkChangedStateToClient(BlockPos source, BlockPos linkedPos) {
        super(source);
        this.linkedPos = linkedPos;
    }

    public LinkChangedStateToClient(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        if (this.linkedPos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.linkedPos);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.linkedPos = buf.m_130135_();
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> {
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p == null) {
                return;
            }
            Level level = p.m_9236_();
            BlockEntity be = level.m_7702_(this.pos);
            if (be instanceof ILinkable) {
                ILinkable linkable = (ILinkable)be;
                linkable.setLinkedDevice(this.linkedPos);
            }
        });
    }
}

