/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.api.packet.JSGPacket;
import java.nio.charset.StandardCharsets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PageNotebookSetNameToServer
extends JSGPacket {
    private InteractionHand hand;
    private String name;

    public PageNotebookSetNameToServer(InteractionHand hand, String name) {
        this.hand = hand;
        this.name = name;
    }

    public PageNotebookSetNameToServer(FriendlyByteBuf buf) {
        this.fromBytes(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.hand = buf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        int size = buf.readInt();
        this.name = buf.readCharSequence(size, StandardCharsets.UTF_8).toString();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ServerLevel world = player.m_284548_();
        ctx.enqueueWork(() -> {
            ItemStack stack = player.m_21120_(this.hand);
            CompoundTag compound = stack.m_41784_();
            CompoundTag display = new CompoundTag();
            display.m_128359_("Name", this.name);
            compound.m_128365_("display", (Tag)display);
            stack.m_41751_(compound);
        });
    }
}

