/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.api.packet.JSGPacket;
import dev.tauri.jsg.screen.inventory.OpenTabHolderInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SetOpenTabSlotIdToServer
extends JSGPacket {
    public List<Integer> openTabSlotIds;

    public SetOpenTabSlotIdToServer() {
    }

    public SetOpenTabSlotIdToServer(List<Integer> openTabSlotIds) {
        this.openTabSlotIds = new ArrayList<Integer>(openTabSlotIds);
    }

    public SetOpenTabSlotIdToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.openTabSlotIds.size());
        for (Integer slot : this.openTabSlotIds) {
            buf.writeInt(slot.intValue());
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.openTabSlotIds = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.openTabSlotIds.add(buf.readInt());
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ArrayList<Integer> openTabSlotIds = new ArrayList<Integer>(this.openTabSlotIds);
        ctx.enqueueWork(() -> {
            AbstractContainerMenu container = player.f_36096_;
            if (container instanceof OpenTabHolderInterface) {
                OpenTabHolderInterface c = (OpenTabHolderInterface)container;
                c.getOpenTabsSlotsIds().clear();
                c.getOpenTabsSlotsIds().addAll(openTabSlotIds);
            }
        });
    }
}

