/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.api.sound.IPositionedSound;
import dev.tauri.jsg.api.sound.client.JSGSoundHelperClient;
import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.sound.PositionedSound;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SoundPositionedPlayToClient
extends PositionedPacket {
    public IPositionedSound soundEnum;
    public boolean play;

    public SoundPositionedPlayToClient(BlockPos pos, IPositionedSound soundEnum, boolean play) {
        super(pos);
        this.soundEnum = soundEnum;
        this.play = play;
    }

    public SoundPositionedPlayToClient(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.soundEnum.getOrdinal());
        buf.writeBoolean(this.play);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.soundEnum = PositionedSound.get(buf.readInt());
        this.play = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> JSGSoundHelperClient.playPositionedSoundClientSide(this.pos, this.soundEnum, this.play));
    }
}

