/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.linkable;

import dev.tauri.jsg.api.packet.JSGPacket;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerClientActionEnum;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UniverseDialerActionPacketToServer
extends JSGPacket {
    public UniverseDialerClientActionEnum action;
    public InteractionHand hand;
    public boolean next;

    public UniverseDialerActionPacketToServer(UniverseDialerClientActionEnum action, InteractionHand hand, boolean next) {
        this.action = action;
        this.hand = hand;
        this.next = next;
    }

    public UniverseDialerActionPacketToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.writeBoolean(this.next);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.action = UniverseDialerClientActionEnum.values()[buf.readInt()];
        this.hand = buf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.next = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> {
            CompoundTag compound;
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21120_(this.hand);
            if (stack.m_41720_() != ItemRegistry.UNIVERSE_DIALER.get()) {
                return;
            }
            if (!stack.m_41782_()) {
                return;
            }
            if (stack.m_41720_() == ItemRegistry.UNIVERSE_DIALER.get() && stack.m_41782_() && (compound = stack.m_41783_()) != null) {
                UniverseDialerMode mode = UniverseDialerMode.valueOf(new ResourceLocation(compound.m_128461_("selectedMode"))).orElse(UniverseDialerMode.getDefault());
                CompoundTag modeTag = compound.m_128469_(String.valueOf(mode.id) + "_tag");
                if (this.action == UniverseDialerClientActionEnum.MODE_CHANGE) {
                    mode = this.next ? mode.next() : mode.prev();
                    compound.m_128359_("selectedMode", mode.id.toString());
                    JSGSoundHelper.playSoundToPlayer(player, SoundEvent.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
                    return;
                }
                mode.handlePacketToServer(this.action, modeTag, this, ctx);
            }
        });
    }
}

