/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.stargate;

import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.traveler.IStargateTraveler;
import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.teleportation.traveler.PlayerTraveler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class StargatePlayerMotionToServer
extends PositionedPacket {
    private int entityId;
    private Vec3 motion;
    private boolean wrongWayTravel;

    public StargatePlayerMotionToServer(int entityId, BlockPos pos, Vec3 motion, boolean wrongWayTravel) {
        super(pos);
        this.entityId = entityId;
        this.motion = motion;
        this.wrongWayTravel = wrongWayTravel;
    }

    public StargatePlayerMotionToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.entityId);
        buf.writeDouble(this.motion.f_82479_);
        buf.writeDouble(this.motion.f_82480_);
        buf.writeDouble(this.motion.f_82481_);
        buf.writeBoolean(this.wrongWayTravel);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.entityId = buf.readInt();
        double motionX = buf.readDouble();
        double motionY = buf.readDouble();
        double motionZ = buf.readDouble();
        this.motion = new Vec3(motionX, motionY, motionZ);
        this.wrongWayTravel = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            BlockEntity blockEntity = world.m_7702_(this.pos);
            if (!(blockEntity instanceof Stargate)) {
                return;
            }
            Stargate stargate = (Stargate)blockEntity;
            StargateEventHorizonManager eh = (StargateEventHorizonManager)stargate.getEventHorizonManager();
            IStargateTraveler<?> traveler = eh.getTraveler((Entity)player, this.motion);
            if (!(traveler instanceof PlayerTraveler)) {
                if (this.wrongWayTravel) {
                    return;
                }
                if (traveler != null) {
                    eh.remove(traveler);
                }
                return;
            }
            PlayerTraveler pTraveler = (PlayerTraveler)traveler;
            if (this.wrongWayTravel) {
                pTraveler.confirmKillWrongTravel();
                return;
            }
            pTraveler.confirmSend();
        });
    }
}

