/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.registry;

import com.google.common.collect.Maps;
import dev.tauri.jsg.Constants;
import dev.tauri.jsg.api.block.util.IItemBlock;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.api.item.JSGBlockItem;
import dev.tauri.jsg.block.LemonBlock;
import dev.tauri.jsg.block.PrinterBlock;
import dev.tauri.jsg.block.ToasterBlock;
import dev.tauri.jsg.block.capacitor.CapacitorBlock;
import dev.tauri.jsg.block.cartouche.CartoucheType;
import dev.tauri.jsg.block.crystal.CrystalBudType;
import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.block.dialhomedevice.DHDMilkyWayBlock;
import dev.tauri.jsg.block.dialhomedevice.DHDPegasusBlock;
import dev.tauri.jsg.block.invisible.InvisibleBlock;
import dev.tauri.jsg.block.invisible.IrisBlock;
import dev.tauri.jsg.block.stargate.StargateMilkyWayBaseBlock;
import dev.tauri.jsg.block.stargate.StargateMilkyWayMemberBlock;
import dev.tauri.jsg.block.stargate.StargateMovieBaseBlock;
import dev.tauri.jsg.block.stargate.StargateMovieMemberBlock;
import dev.tauri.jsg.block.stargate.StargateOrlinBaseBlock;
import dev.tauri.jsg.block.stargate.StargateOrlinMemberBlock;
import dev.tauri.jsg.block.stargate.StargatePegasusBaseBlock;
import dev.tauri.jsg.block.stargate.StargatePegasusMemberBlock;
import dev.tauri.jsg.block.stargate.StargateTollanBaseBlock;
import dev.tauri.jsg.block.stargate.StargateTollanMemberBlock;
import dev.tauri.jsg.block.stargate.StargateUniverseBaseBlock;
import dev.tauri.jsg.block.stargate.StargateUniverseMemberBlock;
import dev.tauri.jsg.block.stargate.redstone.StargateRedstoneDialerI;
import dev.tauri.jsg.block.stargate.redstone.StargateRedstoneStateO;
import dev.tauri.jsg.helpers.registry.block.BlockRegistryHelperGeneric;
import dev.tauri.jsg.helpers.registry.block.BlockRegistryHelperOre;
import dev.tauri.jsg.helpers.registry.block.OreBlockVariant;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"jsg");
    public static final RegistryObject<Block> INVISIBLE_BLOCK = REGISTER.register("invisible_block", InvisibleBlock::new);
    public static final RegistryObject<Block> IRIS_BLOCK = REGISTER.register("iris_block", IrisBlock::new);
    public static final RegistryObject<Block> STARGATE_ORLIN_BASE_BLOCK = REGISTER.register("stargate_orlin_base_block", StargateOrlinBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_ORLIN_MEMBER_BLOCK = REGISTER.register("stargate_orlin_member_block", StargateOrlinMemberBlock::new);
    public static final RegistryObject<Block> STARGATE_MILKYWAY_BASE_BLOCK = REGISTER.register("stargate_milkyway_base_block", StargateMilkyWayBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_MILKYWAY_CHEVRON_BLOCK = REGISTER.register("stargate_milkyway_chevron_block", StargateMilkyWayMemberBlock.StargateMilkyWayChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_MILKYWAY_RING_BLOCK = REGISTER.register("stargate_milkyway_ring_block", StargateMilkyWayMemberBlock.StargateMilkyWayRingBlock::new);
    public static final RegistryObject<Block> STARGATE_PEGASUS_BASE_BLOCK = REGISTER.register("stargate_pegasus_base_block", StargatePegasusBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_PEGASUS_CHEVRON_BLOCK = REGISTER.register("stargate_pegasus_chevron_block", StargatePegasusMemberBlock.StargatePegasusChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_PEGASUS_RING_BLOCK = REGISTER.register("stargate_pegasus_ring_block", StargatePegasusMemberBlock.StargatePegasusRingBlock::new);
    public static final RegistryObject<Block> STARGATE_UNIVERSE_BASE_BLOCK = REGISTER.register("stargate_universe_base_block", StargateUniverseBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_UNIVERSE_CHEVRON_BLOCK = REGISTER.register("stargate_universe_chevron_block", StargateUniverseMemberBlock.StargateUniverseChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_UNIVERSE_RING_BLOCK = REGISTER.register("stargate_universe_ring_block", StargateUniverseMemberBlock.StargateUniverseRingBlock::new);
    public static final RegistryObject<Block> STARGATE_TOLLAN_BASE_BLOCK = REGISTER.register("stargate_tollan_base_block", StargateTollanBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_TOLLAN_CHEVRON_BLOCK = REGISTER.register("stargate_tollan_chevron_block", StargateTollanMemberBlock.StargateTollanChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_TOLLAN_RING_BLOCK = REGISTER.register("stargate_tollan_ring_block", StargateTollanMemberBlock.StargateTollanRingBlock::new);
    public static final RegistryObject<Block> STARGATE_MOVIE_BASE_BLOCK = REGISTER.register("stargate_movie_base_block", StargateMovieBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_MOVIE_CHEVRON_BLOCK = REGISTER.register("stargate_movie_chevron_block", StargateMovieMemberBlock.StargateMovieChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_MOVIE_RING_BLOCK = REGISTER.register("stargate_movie_ring_block", StargateMovieMemberBlock.StargateMovieRingBlock::new);
    public static final RegistryObject<Block> DHD_MILKYWAY = REGISTER.register("dhd_milkyway", DHDMilkyWayBlock::new);
    public static final RegistryObject<Block> DHD_PEGASUS = REGISTER.register("dhd_pegasus", DHDPegasusBlock::new);
    public static final RegistryObject<Block> CAPACITOR_BLOCK = REGISTER.register("capacitor_block", () -> new CapacitorBlock(false));
    public static final RegistryObject<Block> CAPACITOR_BLOCK_CREATIVE = REGISTER.register("capacitor_block_creative", () -> new CapacitorBlock(true));
    public static final RegistryObject<Block> SG_REDSTONE_STATE_O_BLOCK = REGISTER.register("sg_redstone_state_output_block", StargateRedstoneStateO::new);
    public static final RegistryObject<Block> SG_REDSTONE_DIALER_I_BLOCK = REGISTER.register("sg_redstone_dialer_input_block", StargateRedstoneDialerI::new);
    public static final Map<OreBlockVariant, RegistryObject<Block>> ORE_NAQUADAH = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("naquadah_ore")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildAll();
    public static final Map<OreBlockVariant, RegistryObject<Block>> ORE_TITANIUM = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("titanium_ore")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildAll();
    public static final Map<OreBlockVariant, RegistryObject<Block>> ORE_TRINIUM = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("trinium_ore")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildAll();
    public static final RegistryObject<Block> RAW_ORE_NAQUADAH_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("raw_naquadah_ore_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_).m_284180_(MapColor.f_283784_)).buildGeneric();
    public static final RegistryObject<Block> RAW_ORE_TITANIUM_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("raw_titanium_ore_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_).m_284180_(MapColor.f_283818_)).buildGeneric();
    public static final RegistryObject<Block> RAW_ORE_TRINIUM_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("raw_trinium_ore_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_).m_284180_(MapColor.f_283779_)).buildGeneric();
    public static final RegistryObject<Block> NAQUADAH_RAW_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("naquadah_alloy_raw_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283784_)).buildGeneric();
    public static final RegistryObject<Block> NAQUADAH_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("naquadah_alloy_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283869_)).buildGeneric();
    public static final RegistryObject<Block> NAQUADAH_REFINED_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("naquadah_alloy_refined_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283812_)).buildGeneric();
    public static final RegistryObject<Block> TITANIUM_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("titanium_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283906_)).buildGeneric();
    public static final RegistryObject<Block> TRINIUM_BLOCK = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("trinium_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283942_)).buildGeneric();
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BLOCK = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("{color}_crystal_block")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)).buildCrystalBlock();
    public static final Map<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> CRYSTAL_BUDDING = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("budding_{color}_crystal")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152491_)).buildCrystalBuddings();
    public static final Map<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> UNSTABLE_CRYSTAL_BUDDING = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("unstable_budding_{color}_crystal")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152491_)).buildCrystalUnstableBuddings(() -> CRYSTAL_BUDDING, () -> CRYSTAL_BLOCK);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BUD_SMALL = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("small_{color}_crystal_bud")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildCrystalBuds(CrystalBudType.SMALL);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BUD_MEDIUM = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("medium_{color}_crystal_bud")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildCrystalBuds(CrystalBudType.MEDIUM);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BUD_LARGE = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("large_{color}_crystal_bud")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildCrystalBuds(CrystalBudType.LARGE);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_CLUSTER = ((BlockRegistryHelperOre.OreBlockBuilder)((BlockRegistryHelperOre.OreBlockBuilder)Constants.JSG_ORE_HELPER.builder("{color}_crystal_cluster")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildCrystalBuds(CrystalBudType.CLUSTER);
    public static final RegistryObject<Block> ABYDOS_SAND = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("abydos_sand")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(MapColor.f_283832_)).buildFallingGeneric();
    public static final RegistryObject<Block> BRAZIER_COAL = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("brazier_coal")).clearTooltip().setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50353_).m_284180_(MapColor.f_283927_)).buildGeneric();
    public static final RegistryObject<Block> TOASTER = REGISTER.register("toaster", ToasterBlock::new);
    public static final RegistryObject<Block> PRINTER = REGISTER.register("printer", PrinterBlock::new);
    public static final RegistryObject<Block> LEMON_BLOCK = REGISTER.register("lemon", LemonBlock::new);
    public static final RegistryObject<Block> STATIC_SMOOTH_SANDSTONE = ((BlockRegistryHelperGeneric.GenericBlockBuilder)((BlockRegistryHelperGeneric.GenericBlockBuilder)Constants.JSG_BLOCK_HELPER.builder("static_smooth_sandstone")).clearTooltip().setProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50471_).m_278166_(PushReaction.BLOCK)).setInTabs((List)List.of(TabRegistry.TAB_BUILDING_BLOCKS))).buildGeneric();
    public static final Map<String, Supplier<BlockState>> CARTOUCHES_BLOCKS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put("stone", () -> ((Block)Blocks.f_50069_).m_49966_());
        map.put("smooth_sandstone", () -> ((Block)Blocks.f_50471_).m_49966_());
        map.put("smooth_red_sandstone", () -> ((Block)Blocks.f_50473_).m_49966_());
        map.put("polished_diorite", () -> ((Block)Blocks.f_50281_).m_49966_());
        map.put("polished_granite", () -> ((Block)Blocks.f_50175_).m_49966_());
        map.put("polished_deepslate", () -> ((Block)Blocks.f_152555_).m_49966_());
        map.put("prismarine_bricks", () -> ((Block)Blocks.f_50378_).m_49966_());
        map.put("netherrack", () -> ((Block)Blocks.f_50134_).m_49966_());
        map.put("nether_bricks", () -> ((Block)Blocks.f_50197_).m_49966_());
        map.put("red_nether_bricks", () -> ((Block)Blocks.f_50452_).m_49966_());
        map.put("smooth_basalt", () -> ((Block)Blocks.f_152597_).m_49966_());
        map.put("end_stone_bricks", () -> ((Block)Blocks.f_50443_).m_49966_());
        map.put("purpur_block", () -> ((Block)Blocks.f_50492_).m_49966_());
    });
    public static final Map<String, Map<CartoucheType, RegistryObject<Block>>> CARTOUCHES = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        for (Map.Entry<String, Supplier<BlockState>> b : CARTOUCHES_BLOCKS.entrySet()) {
            map.put(b.getKey(), CartoucheType.registerTypes(() -> REGISTER, b.getKey() + "_cartouche", b.getValue()));
        }
    });

    public static void register(IEventBus bus) {
        for (RegistryObject i : REGISTER.getEntries().stream().toList()) {
            RegistryObject registryObject = ItemRegistry.REGISTER.register(i.getId().m_135815_(), () -> {
                Object patt15145$temp;
                List<RegistryObject<CreativeModeTab>> tabs = List.of();
                Object patt15004$temp = i.get();
                if (patt15004$temp instanceof ITabbedItem) {
                    ITabbedItem t = (ITabbedItem)patt15004$temp;
                    tabs = t.getTabs();
                }
                if ((patt15145$temp = i.get()) instanceof IItemBlock) {
                    IItemBlock itemBlock = (IItemBlock)patt15145$temp;
                    return itemBlock.getItemBlock();
                }
                return new JSGBlockItem((Block)i.get(), new Item.Properties(), tabs);
            });
        }
        REGISTER.register(bus);
    }
}

