/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.registry;

import dev.tauri.jsg.Constants;
import dev.tauri.jsg.api.integration.Integrations;
import dev.tauri.jsg.block.cartouche.CartoucheType;
import dev.tauri.jsg.item.JSGMusicDiscItem;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TabRegistry {
    public static final DeferredRegister<CreativeModeTab> REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"jsg");
    public static final RegistryObject<CreativeModeTab> TAB_TRANSPORTATION = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("transportation", () -> new ItemStack((ItemLike)BlockRegistry.STARGATE_MILKYWAY_BASE_BLOCK.get()));
    public static final RegistryObject<CreativeModeTab> TAB_RESOURCES = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("resources", () -> new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ALLOY.get()));
    public static final RegistryObject<CreativeModeTab> TAB_BUILDING_BLOCKS = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("building_blocks", () -> new ItemStack((ItemLike)BlockRegistry.NAQUADAH_BLOCK.get()));
    public static final RegistryObject<CreativeModeTab> TAB_TOOLS = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("tools", () -> new ItemStack((ItemLike)ItemRegistry.ADMIN_CONTROLLER.get()));
    public static final RegistryObject<CreativeModeTab> TAB_UPGRADES = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("upgrades", () -> new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_STARGATE.get()));
    public static final RegistryObject<CreativeModeTab> TAB_ENERGY = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("energy", () -> new ItemStack((ItemLike)BlockRegistry.CAPACITOR_BLOCK.get()));
    public static final RegistryObject<CreativeModeTab> TAB_FLUIDS = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("fluids", () -> new ItemStack((ItemLike)FluidRegistry.MOLTEN_NAQUADAH_REFINED.bucket.get()));
    public static final RegistryObject<CreativeModeTab> TAB_MACHINES = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("machines", () -> new ItemStack((ItemLike)BlockRegistry.PRINTER.get()));
    public static final RegistryObject<CreativeModeTab> TAB_CARTOUCHES = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("cartouches", () -> new ItemStack((ItemLike)BlockRegistry.CARTOUCHES.get("stone").get((Object)CartoucheType.SEVEN_POO).get()));
    public static RegistryObject<CreativeModeTab> TAB_INTEGRATIONS;

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }

    @SubscribeEvent
    public static void buildTabsContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.accept(ItemRegistry.EGG_MASTADGE);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.accept(ItemRegistry.FOOD_CHOCOLATE_BAR);
            event.accept(ItemRegistry.FOOD_LEMON);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            for (RegistryObject<JSGMusicDiscItem> r : ItemRegistry.RECORDS.values()) {
                event.accept(r);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_257028_) {
            event.accept(BlockRegistry.SG_REDSTONE_DIALER_I_BLOCK);
            event.accept(BlockRegistry.SG_REDSTONE_STATE_O_BLOCK);
        }
    }

    static {
        Integrations.CREATE.addOnLoad(() -> {
            if (TAB_INTEGRATIONS != null) {
                return;
            }
            TAB_INTEGRATIONS = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("integrations", () -> new ItemStack((ItemLike)ItemRegistry.GEAR_TITANIUM.get()));
        });
        Integrations.TCONSTRUCT.addOnLoad(() -> {
            if (TAB_INTEGRATIONS != null) {
                return;
            }
            TAB_INTEGRATIONS = Constants.JSG_TAB_HELPER.createCreativeTabWithItemStack("integrations", () -> new ItemStack((ItemLike)ItemRegistry.GEAR_TITANIUM.get()));
        });
    }
}

