/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.cartouche;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.client.renderer.BlockRenderer;
import dev.tauri.jsg.api.client.renderer.LinkableRenderer;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.block.cartouche.CartoucheBlock;
import dev.tauri.jsg.block.cartouche.CartoucheType;
import dev.tauri.jsg.blockentity.cartouche.CartoucheBE;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import dev.tauri.jsg.renderer.cartouche.CartoucheRendererState;
import java.awt.Color;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CartoucheRenderer
implements BlockEntityRenderer<CartoucheBE>,
LinkableRenderer {
    protected CartoucheType type;

    public CartoucheRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRenderOffScreen(CartoucheBE be) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void render(CartoucheBE be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = be.m_58904_();
        CartoucheRendererState state = be.renderStateClient;
        if (state == null) {
            return;
        }
        if (level == null) {
            return;
        }
        BlockPos pos = be.m_58899_();
        if (level.m_8055_(pos).m_61145_((Property)BlockStateProperties.f_61409_).orElse(-1) != 0) {
            return;
        }
        poseStack.m_85836_();
        if (JSGConfig.Debug.renderBoundingBoxes.get() || Minecraft.m_91087_().m_91290_().m_114377_()) {
            be.getRenderBoundingBox().inset(be.m_58899_()).render((Component)Component.m_237113_((String)"RenderBox"), poseStack, buffer);
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(RotationUtil.getRotation(be.m_58900_()));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -0.5, -1.0);
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        Block block = be.m_58900_().m_60734_();
        if (block instanceof CartoucheBlock) {
            CartoucheBlock cartoucheBlock = (CartoucheBlock)block;
            Supplier<BlockState> material = cartoucheBlock.material;
            Direction texDirection = be.m_58900_().m_61145_((Property)JSGProperties.FACING_VERTICAL_PROPERTY).filter(i -> i != 0).map(JSGProperties::getDirectionByVerticalFacing).orElse(be.m_58900_().m_61145_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY).orElse(Direction.SOUTH));
            TextureAtlasSprite sprite = BlockRenderer.getSprite(material.get(), texDirection);
            if (sprite != null) {
                ITexture.bindTextureWithMc(sprite.m_247685_());
            }
            this.type = cartoucheBlock.type;
            this.type.model.render(poseStack, buffer, packedLight, sprite, true);
        }
        poseStack.m_85849_();
        this.renderAddress(be, partialTick, poseStack, buffer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    @Nullable
    public Vector3f getSymbolCoords(SymbolInterface symbol, int symbolIndex) {
        if (this.type == null) {
            return null;
        }
        if (symbol.origin()) {
            if (!this.type.hasPoo) {
                return null;
            }
            return new Vector3f(-0.1875f, -0.3f, 1.5f);
        }
        if (symbolIndex >= this.type.symbolsCount) {
            return null;
        }
        float x = -0.12449999f;
        float y = 0.24f;
        boolean scale = true;
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case CartoucheType.SIX -> new Vector3f(x, 0.95f - y * (float)symbolIndex, (float)scale);
            case CartoucheType.SEVEN -> new Vector3f(x, 0.95f + y - y * (float)symbolIndex, (float)scale);
            case CartoucheType.EIGHT -> new Vector3f(x, 0.95f + y * 2.0f - y * (float)symbolIndex, (float)scale);
            case CartoucheType.SEVEN_POO -> new Vector3f(x, 1.8499999f - y * (float)symbolIndex, (float)scale);
            case CartoucheType.EIGHT_POO -> new Vector3f(x, 1.8499999f + y / 2.0f - y * (float)symbolIndex, (float)scale);
            case CartoucheType.NINE_POO -> new Vector3f(x, 1.8499999f + y - y * (float)symbolIndex, (float)scale);
        };
    }

    public void renderAddress(CartoucheBE be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        StargateAddressDynamic stargateAddress = be.savedAddress;
        if (stargateAddress == null) {
            return;
        }
        int[] symbolsToDisplay = be.symbolsToDisplay;
        if (symbolsToDisplay == null) {
            symbolsToDisplay = new int[]{};
        }
        for (int symbolId : symbolsToDisplay) {
            SymbolInterface symbol;
            Vector3f coords;
            int i;
            if (symbolId <= 0 || symbolId > 9 || (i = symbolId - 1) >= stargateAddress.size() || (coords = this.getSymbolCoords(symbol = stargateAddress.get(i), i)) == null) continue;
            poseStack.m_85836_();
            poseStack.m_252880_(coords.x, coords.y, -0.465f);
            poseStack.m_85841_(1.3f, 1.3f, 1.3f);
            poseStack.m_85841_(coords.z, coords.z, coords.z);
            CartoucheRenderer.renderSymbol(poseStack, 0.0f, 0.0f, symbol, be.getPointOfOrigin(), packedLight, new Color(be.color.m_41071_(), false), be.shiny);
            poseStack.m_85849_();
        }
    }

    public static void renderSymbol(PoseStack poseStack, float x, float y, SymbolInterface symbol, @Nullable PointOfOrigin origin, int packedLight, Color color, boolean shiny) {
        if (symbol.getSymbolType() == SymbolTypeRegistry.UNIVERSE) {
            CartoucheRenderer.renderSymbol(poseStack, x += 0.04f, y, 0.095f, 0.2f, symbol, origin, color, 0.6f, packedLight, shiny);
        } else {
            CartoucheRenderer.renderSymbol(poseStack, x, y, 0.2f, 0.2f, symbol, origin, color, 0.6f, packedLight, shiny);
        }
    }

    public static void renderSymbol(PoseStack poseStack, float x, float y, float w, float h, SymbolInterface symbol, @Nullable PointOfOrigin origin, Color color, float alpha, int packedLight, boolean shiny) {
        if (shiny) {
            packedLight = 0xF000F0;
        }
        for (int i = 0; i < 2; ++i) {
            float z = 0.0f;
            float xx = x;
            float yy = y;
            if (i == 1) {
                alpha /= 2.0f;
                z += 1.0E-4f;
                xx += 0.005f;
                yy -= 0.005f;
            }
            poseStack.m_85836_();
            float finalXx = xx;
            float finalYy = yy;
            float finalZ = z;
            int finalPackedLight = packedLight;
            float finalAlpha = alpha;
            EmissiveRenderer.renderWithLightOverlay(poseStack, packedLight, shiny, () -> {
                symbol.bindIconTexture(origin);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                Matrix3f normalMat = poseStack.m_85850_().m_252943_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
                bufferbuilder.m_252986_(matrix, finalXx, finalYy, finalZ).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, finalAlpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(finalPackedLight).m_252939_(normalMat, 0.0f, 0.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix, finalXx + w, finalYy, finalZ).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, finalAlpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(finalPackedLight).m_252939_(normalMat, 0.0f, 0.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix, finalXx + w, finalYy + h, finalZ).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, finalAlpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(finalPackedLight).m_252939_(normalMat, 0.0f, 0.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix, finalXx, finalYy + h, finalZ).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, finalAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(finalPackedLight).m_252939_(normalMat, 0.0f, 0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            });
            poseStack.m_85849_();
        }
    }
}

