/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.cartouche;

import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.state.State;
import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;

public class CartoucheRendererState
extends State {
    public StargateAddressDynamic address;
    public PointOfOrigin origin;
    public DyeColor color;
    public boolean shiny;
    public int[] symbolsToDisplay;

    public CartoucheRendererState() {
    }

    @ParametersAreNullableByDefault
    public CartoucheRendererState(StargateAddressDynamic address, PointOfOrigin pointOfOrigin, int[] symbolsToDisplay, DyeColor color, boolean shiny) {
        this.address = address;
        this.origin = pointOfOrigin;
        this.symbolsToDisplay = symbolsToDisplay == null ? new int[]{} : symbolsToDisplay;
        this.color = color;
        this.shiny = shiny;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (this.address != null) {
            buf.writeBoolean(true);
            this.address.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.origin != null) {
            buf.writeBoolean(true);
            this.origin.toBytes(new FriendlyByteBuf(buf));
        } else {
            buf.writeBoolean(false);
        }
        new FriendlyByteBuf(buf).m_130089_(this.symbolsToDisplay);
        buf.writeInt(this.color.m_41060_());
        buf.writeBoolean(this.shiny);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.address = new StargateAddressDynamic(buf);
        }
        if (buf.readBoolean()) {
            this.origin = PointOfOrigin.fromBytes(new FriendlyByteBuf(buf), null);
        }
        this.symbolsToDisplay = new FriendlyByteBuf(buf).m_130100_();
        this.color = DyeColor.m_41053_((int)buf.readInt());
        this.shiny = buf.readBoolean();
    }
}

