/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dialhomedevice;

import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolMilkyWayEnum;
import dev.tauri.jsg.renderer.activation.Activation;
import dev.tauri.jsg.renderer.activation.DHDActivation;
import dev.tauri.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DHDMilkyWayRendererState
extends DHDAbstractRendererState {
    private static final String SYMBOL_TEXTURE_BASE = "textures/tesr/milkyway/dhd/dhd_button_light_";
    private static final String BRB_TEXTURE_BASE = "textures/tesr/milkyway/dhd/dhd_brb_";
    private static final String SYMBOL_TEXTURE_END = "jpg";
    private static final String BRB_TEXTURE_END = "jpg";
    private static final Map<BiomeOverlayRegistry.BiomeOverlayInstance, TextureContainer> BIOME_TEXTURE_MAP = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, TextureContainer>();
    private final Map<SymbolInterface, Integer> BUTTON_STATE_MAP = new HashMap<SymbolInterface, Integer>(38);
    public List<Activation<SymbolInterface>> activationList = new ArrayList<Activation<SymbolInterface>>();

    public DHDMilkyWayRendererState() {
    }

    public DHDMilkyWayRendererState(StargateAddressDynamic addressDialed, boolean brbActive, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverride, boolean stargateIsConnected, BEConfig gateConfig) {
        super(addressDialed, brbActive, biomeOverride, stargateIsConnected, gateConfig);
    }

    @Override
    public DHDMilkyWayRendererState initClient(BlockPos pos, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay, boolean stargateIsConnected) {
        super.initClient(pos, biomeOverlay, stargateIsConnected);
        for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
            if (symbol.brb()) {
                this.BUTTON_STATE_MAP.put(symbol, this.brbActive ? 5 : 0);
                continue;
            }
            this.BUTTON_STATE_MAP.put(symbol, this.addressDialed.contains(symbol) ? 5 : 0);
        }
        return this;
    }

    private boolean isSymbolActiveClientSide(SymbolMilkyWayEnum symbol) {
        return this.BUTTON_STATE_MAP.get(symbol) != 0;
    }

    public void clearSymbols(long totalWorldTime) {
        for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
            if (!this.isSymbolActiveClientSide(symbol)) continue;
            this.activationList.add(new DHDActivation(symbol, totalWorldTime, true));
        }
    }

    public void activateSymbol(long totalWorldTime, SymbolMilkyWayEnum symbol) {
        this.activationList.add(new DHDActivation(symbol, totalWorldTime, false));
    }

    @Override
    public void iterate(Level world, double partialTicks) {
        Activation.iterate(this.activationList, world.m_46467_(), partialTicks, (index, stage) -> this.BUTTON_STATE_MAP.put((SymbolInterface)index, Math.round(stage)));
    }

    public ResourceLocation getButtonTexture(SymbolMilkyWayEnum symbol, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay) {
        TextureContainer container = BIOME_TEXTURE_MAP.get(biomeOverlay);
        if (symbol.brb()) {
            return container.BRB_RESOURCE_MAP.get(this.BUTTON_STATE_MAP.get(symbol));
        }
        return container.SYMBOL_RESOURCE_MAP.get(this.BUTTON_STATE_MAP.get(symbol));
    }

    @Override
    public boolean isButtonActive(SymbolInterface symbol) {
        return this.BUTTON_STATE_MAP.get(symbol) == 5;
    }

    @Override
    public int getActivatedButtons() {
        int count = 0;
        SymbolMilkyWayEnum origin = SymbolTypeRegistry.MILKYWAY.getOrigin();
        for (int state : this.BUTTON_STATE_MAP.values()) {
            if (state <= 0) continue;
            ++count;
        }
        if (this.BUTTON_STATE_MAP.get(origin) > 0) {
            --count;
        }
        return count;
    }

    @Override
    public AbstractSymbolType<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    static {
        for (BiomeOverlayRegistry.BiomeOverlayInstance bo : BiomeOverlayRegistry.values()) {
            BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay = BiomeOverlayRegistry.NORMAL;
            TextureContainer container = new TextureContainer();
            for (int i = 0; i <= 5; ++i) {
                container.SYMBOL_RESOURCE_MAP.put(i, new ResourceLocation("jsg", SYMBOL_TEXTURE_BASE + i + biomeOverlay.getSuffix() + ".jpg"));
                container.BRB_RESOURCE_MAP.put(i, new ResourceLocation("jsg", BRB_TEXTURE_BASE + i + biomeOverlay.getSuffix() + ".jpg"));
            }
            BIOME_TEXTURE_MAP.put(bo, container);
        }
    }

    private static class TextureContainer {
        public final Map<Integer, ResourceLocation> SYMBOL_RESOURCE_MAP = new HashMap<Integer, ResourceLocation>();
        public final Map<Integer, ResourceLocation> BRB_RESOURCE_MAP = new HashMap<Integer, ResourceLocation>();

        private TextureContainer() {
        }
    }
}

