/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.machine;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.client.renderer.IRaycasterButtonsRenderer;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.raycaster.Raycaster;
import dev.tauri.jsg.api.raycaster.util.RayCastedButton;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.block.PrinterBlock;
import dev.tauri.jsg.blockentity.PrinterBE;
import dev.tauri.jsg.item.CartridgeItem;
import dev.tauri.jsg.item.notebook.PageRenderer;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.raycaster.instances.RaycasterPrinter;
import dev.tauri.jsg.registry.ItemRegistry;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class PrinterRenderer
implements BlockEntityRenderer<PrinterBE>,
IRaycasterButtonsRenderer {
    private PoseStack stack;
    private PrinterBE tile;
    private Level level;

    public PrinterRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @Override
    public List<RayCastedButton> getRaycasterButtons() {
        return RaycasterPrinter.BUTTONS;
    }

    @Override
    public Raycaster getRaycaster() {
        return RaycasterPrinter.INSTANCE;
    }

    @ParametersAreNonnullByDefault
    public void render(PrinterBE printerTile, float partialTick, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        this.tile = printerTile;
        this.level = this.tile.m_58904_();
        if (this.level == null) {
            return;
        }
        this.stack = stack;
        if (!(this.level.m_8055_(this.tile.m_58899_()).m_60734_() instanceof PrinterBlock)) {
            return;
        }
        this.renderRaycasterButtons(printerTile, stack, source);
        PageRenderer.currentStack = stack;
        PageRenderer.source = source;
        PageRenderer.light = light;
        GuiHelper.currentStack = stack;
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        Direction direction = ((Direction)this.level.m_8055_(this.tile.m_58899_()).m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY)).m_122424_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252392_.m_252977_(direction.m_122435_()));
        stack.m_85836_();
        RenderSystem.enableBlend();
        Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/arrow_button.png"));
        stack.m_85837_(-0.35, -0.2, 0.15);
        stack.m_252781_(Axis.f_252529_.m_252977_(-22.0f));
        stack.m_85841_(0.1f, 0.1f, 0.1f);
        stack.m_85836_();
        GuiHelper.translateFor3D();
        GuiHelper.drawScaledCustomSizeModalRect(0, 0, 40.0f, 0.0f, 20, 20, 1, 1, 120.0f, 20.0f);
        stack.m_85849_();
        boolean remove = this.tile.symbolsToPrint.contains(this.tile.editPos + 1);
        stack.m_85836_();
        stack.m_85837_(2.05, 0.0, 0.0);
        GuiHelper.translateFor3D();
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6047_()) {
            RenderSystem.setShaderColor((float)(remove ? 1.0f : 0.0f), (float)(remove ? 0.0f : 1.0f), (float)0.0f, (float)1.0f);
            GuiHelper.drawScaledCustomSizeModalRect(0, 0, remove ? 80.0f : 100.0f, 0.0f, 20, 20, 1, 1, 120.0f, 20.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GuiHelper.drawScaledCustomSizeModalRect(0, 0, 20.0f, 0.0f, 20, 20, 1, 1, 120.0f, 20.0f);
        }
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(4.1, 0.0, 0.0);
        GuiHelper.translateFor3D();
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6047_()) {
            RenderSystem.setShaderColor((float)(remove ? 1.0f : 0.0f), (float)(remove ? 0.0f : 1.0f), (float)0.0f, (float)1.0f);
            GuiHelper.drawScaledCustomSizeModalRect(0, 0, remove ? 80.0f : 100.0f, 0.0f, 20, 20, 1, 1, 120.0f, 20.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GuiHelper.drawScaledCustomSizeModalRect(0, 0, 0.0f, 0.0f, 20, 20, 1, 1, 120.0f, 20.0f);
        }
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(6.1499999999999995, 0.0, 0.0);
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GuiHelper.translateFor3D();
        GuiHelper.drawScaledCustomSizeModalRect(0, 0, 100.0f, 0.0f, 20, 20, 1, 1, 120.0f, 20.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85849_();
        RenderSystem.disableBlend();
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(-0.35, -0.19, 0.8);
        stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        this.renderDisplay();
        stack.m_85849_();
        if (!this.tile.inputPages.m_41619_()) {
            this.renderPageInStack();
        }
        if (!this.tile.outputPages.isEmpty()) {
            this.renderOutputPage();
        }
        stack.m_85849_();
    }

    public Pair<Float, Float> getAnimation() {
        float first = 0.0f;
        float second = 0.0f;
        float x = (float)Math.max(0.0, Math.min((double)115.54f, (double)(this.level.m_46467_() - this.tile.printStarted))) / 20.0f;
        if (x >= 0.0f && x <= 1.931f) {
            first = x / 3.862f;
        } else if (x <= 2.45f) {
            first = 0.5f;
        } else if (x <= 2.66f) {
            first = x - 2.45f + 0.5f;
        } else if (x <= 2.88f) {
            first = 0.71f;
        } else if (x <= 3.0f) {
            first = x - 2.88f + 0.71f;
        } else if (x <= 3.206f) {
            first = 0.83f;
        } else if (x <= 3.302f) {
            first = x - 3.206f + 0.83f;
        } else if (x <= 3.5f) {
            first = 0.926f;
        } else if (x <= 3.6f) {
            first = x - 3.5f + 0.926f;
        } else if (x > 3.0f) {
            first = 1.0f;
        }
        if (x >= 4.05f && x <= 4.17f) {
            second = x - 4.17f + 0.12f;
        } else if (x <= 4.36f) {
            second = 0.12f;
        } else if (x <= 4.47f) {
            second = x - 4.47f + 0.23f;
        } else if (x <= 4.64f) {
            second = 0.23f;
        } else if (x <= 4.75f) {
            second = x - 4.75f + 0.34f;
        } else if (x <= 4.95f) {
            second = 0.34f;
        } else if (x <= 5.02f) {
            second = x - 5.02f + 0.412f;
        } else if (x <= 5.14f) {
            second = 0.412f;
        } else if (x <= 5.264f) {
            second = x - 5.264f + 0.53f;
        } else if (x <= 5.305f) {
            second = 0.53f;
        } else if (x <= 5.777f) {
            second = x - 5.777f + 1.0f;
        } else if (x > 5.0f) {
            second = 1.0f;
        }
        if (first > 1.0f) {
            first = 1.0f;
        }
        if (second > 1.0f) {
            second = 1.0f;
        }
        if (first < 0.0f) {
            first = 0.0f;
        }
        if (second < 0.0f) {
            second = 0.0f;
        }
        if (this.tile.printStarted <= 0L) {
            first = 0.0f;
            second = 1.0f;
        }
        return Pair.of((Object)Float.valueOf(first), (Object)Float.valueOf(second));
    }

    protected void renderPageInStack() {
        Float percent = (Float)this.getAnimation().first();
        this.stack.m_85836_();
        this.stack.m_85837_(-0.31, -0.625, -0.5);
        this.stack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
        this.stack.m_85837_(0.0, 0.05, 0.0);
        if (percent.floatValue() < 1.0f) {
            this.stack.m_85836_();
            this.stack.m_85837_(0.0, -0.3 * (double)percent.floatValue(), 0.0);
            this.stack.m_85837_(0.0, 0.0, 0.005 * (double)(this.tile.inputPages.m_41613_() - 1));
            this.stack.m_85841_(0.6f, 0.6f, 0.6f);
            PageRenderer.renderPercentages = Pair.of((Object)Float.valueOf(1.0f - percent.floatValue() * 0.5f), (Object)false);
            PageRenderer.renderByCompound(ItemDisplayContext.FIXED, null);
            PageRenderer.renderPercentages = null;
            this.stack.m_85849_();
        }
        for (int i = 0; i < this.tile.inputPages.m_41613_() - 1; ++i) {
            this.stack.m_85836_();
            this.stack.m_85837_(0.0, 0.0, 0.005 * (double)i);
            this.stack.m_85841_(0.6f, 0.6f, 0.6f);
            PageRenderer.renderByCompound(ItemDisplayContext.FIXED, null);
            this.stack.m_85849_();
        }
        this.stack.m_85849_();
    }

    protected void renderOutputPage() {
        Float percent = (Float)this.getAnimation().second();
        this.stack.m_85836_();
        this.stack.m_85837_(-0.31, -0.73, 0.0);
        if (percent.floatValue() > 0.0f) {
            this.stack.m_85836_();
            this.stack.m_85837_(0.0, 0.005 * (double)(this.tile.outputPages.size() - 1), 0.4 * (double)percent.floatValue());
            this.stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            this.stack.m_85841_(0.6f, 0.6f, 0.6f);
            PageRenderer.renderPercentages = Pair.of((Object)percent, (Object)true);
            PageRenderer.renderByCompound(ItemDisplayContext.FIXED, this.tile.outputPages.getLast().m_41783_());
            PageRenderer.renderPercentages = null;
            this.stack.m_85849_();
        }
        for (int i = 0; i < this.tile.outputPages.size() - 1; ++i) {
            this.stack.m_85836_();
            this.stack.m_85837_(0.0, 0.005 * (double)i, 0.4);
            this.stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            this.stack.m_85841_(0.6f, 0.6f, 0.6f);
            PageRenderer.renderByCompound(ItemDisplayContext.FIXED, this.tile.outputPages.get(i).m_41783_());
            this.stack.m_85849_();
        }
        this.stack.m_85849_();
    }

    protected void renderDisplay() {
        if (this.tile.address == null) {
            return;
        }
        int editPos = this.tile.editPos;
        if (editPos < 0) {
            editPos = 0;
        }
        if (editPos >= this.tile.address.size()) {
            editPos = this.tile.address.size();
        }
        this.stack.m_85836_();
        PageRenderer.renderSymbol(0.05f, 0.0f, this.tile.address.get(editPos), this.tile.origin);
        this.stack.m_85836_();
        this.stack.m_85837_(0.2, 0.8, 0.01);
        this.stack.m_85841_(0.003f, 0.003f, 0.003f);
        this.stack.m_85836_();
        Object title = this.tile.address.get(editPos).getId() + " " + this.tile.address.get(editPos).localize();
        int width = Minecraft.m_91087_().f_91062_.m_92895_((String)title);
        this.stack.m_252880_((float)(-width) / 2.0f, 0.0f, 0.0f);
        PageRenderer.renderText((String)title, 0, false);
        this.stack.m_85849_();
        this.stack.m_85849_();
        this.stack.m_85849_();
        this.stack.m_85836_();
        this.stack.m_85837_(0.65, 0.75, 0.01);
        this.stack.m_85841_(0.2f, 0.2f, 0.2f);
        this.stack.m_85836_();
        this.stack.m_85837_(0.0, 1.1, 0.0);
        this.stack.m_85841_(0.02f, 0.02f, 0.02f);
        this.stack.m_85841_(0.8f, 0.8f, 0.8f);
        title = I18n.format("gui.stargate." + this.tile.address.getSymbolType().getId() + "_address");
        width = Minecraft.m_91087_().f_91062_.m_92895_((String)title);
        this.stack.m_252880_((float)(-width), 0.0f, 0.0f);
        PageRenderer.renderText((String)title, 0, false);
        this.stack.m_85849_();
        int size = this.tile.address.size();
        float offsetX = -0.2f * (float)size;
        RenderSystem.enableBlend();
        for (int i = 0; i < size; ++i) {
            Color underlineColor = this.tile.symbolsToPrint.contains(i + 1) ? Color.GREEN : Color.RED;
            float x = offsetX + 0.2f * (float)i;
            this.stack.m_85836_();
            PageRenderer.renderSymbol(x, 0.1f, this.tile.address.get(i), this.tile.origin, Color.BLACK, 1.0f);
            PageRenderer.renderRect(x, 0.16f, 0.2f, 0.05f, underlineColor, 0.5f);
            if (this.tile.editPos == i) {
                PageRenderer.renderRect(x, 0.21f, 0.2f, 0.025f, Color.CYAN, 0.5f);
            }
            this.stack.m_85849_();
        }
        RenderSystem.disableBlend();
        Map<Color, Double> status = this.tile.getInkStatusAmountOnly();
        this.stack.m_85836_();
        this.stack.m_85837_(-0.7, 0.1, 0.0);
        this.stack.m_85841_(0.008f, 0.008f, 0.008f);
        PageRenderer.renderRect(0.0f, 0.0f, 20.0f, 50.0f, Color.DARK_GRAY, 1.0f);
        PageRenderer.renderRect(25.0f, 0.0f, 20.0f, 50.0f, Color.DARK_GRAY, 1.0f);
        PageRenderer.renderRect(50.0f, 0.0f, 20.0f, 50.0f, Color.DARK_GRAY, 1.0f);
        PageRenderer.renderRect(75.0f, 0.0f, 20.0f, 50.0f, Color.DARK_GRAY, 1.0f);
        this.stack.m_85836_();
        this.stack.m_85837_(0.0, 0.0, 0.01);
        PageRenderer.renderRect(2.0f, -2.0f, 16.0f, 46.0f * status.getOrDefault(((CartridgeItem)ItemRegistry.CARTRIDGE_BLACK.get()).renderColor, 0.0).floatValue(), ((CartridgeItem)ItemRegistry.CARTRIDGE_BLACK.get()).renderColor, 1.0f);
        PageRenderer.renderRect(27.0f, -2.0f, 16.0f, 46.0f * status.getOrDefault(((CartridgeItem)ItemRegistry.CARTRIDGE_CYAN.get()).renderColor, 0.0).floatValue(), ((CartridgeItem)ItemRegistry.CARTRIDGE_CYAN.get()).renderColor, 1.0f);
        PageRenderer.renderRect(52.0f, -2.0f, 16.0f, 46.0f * status.getOrDefault(((CartridgeItem)ItemRegistry.CARTRIDGE_MAGENTA.get()).renderColor, 0.0).floatValue(), ((CartridgeItem)ItemRegistry.CARTRIDGE_MAGENTA.get()).renderColor, 1.0f);
        PageRenderer.renderRect(77.0f, -2.0f, 16.0f, 46.0f * status.getOrDefault(((CartridgeItem)ItemRegistry.CARTRIDGE_YELLOW.get()).renderColor, 0.0).floatValue(), ((CartridgeItem)ItemRegistry.CARTRIDGE_YELLOW.get()).renderColor, 1.0f);
        this.stack.m_85849_();
        this.stack.m_85849_();
        this.stack.m_85849_();
    }
}

