/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.obj;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.model.IOBJModelRenderer;
import dev.tauri.jsg.api.util.vectors.Vector2f;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import dev.tauri.jsg.renderer.shader.RenderTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
public class InGameOBJModelRenderer
extends IOBJModelRenderer<OBJModel> {
    protected final Map<Integer, Map<TextureAtlasSprite, VertexBuffer>> modelBuffersLight = new HashMap<Integer, Map<TextureAtlasSprite, VertexBuffer>>();
    protected final Map<Integer, VertexBuffer> modelBufferNoAtlasLight = new HashMap<Integer, VertexBuffer>();

    public InGameOBJModelRenderer(OBJModel model) {
        super(model);
    }

    @Nullable
    protected VertexBuffer getBuffer(int light, @Nullable TextureAtlasSprite textureAtlasSprite) {
        if (JSG.oculusWrapper.isShaderPackActive()) {
            if (textureAtlasSprite != null) {
                Map<TextureAtlasSprite, VertexBuffer> modelBufferMap = this.modelBuffersLight.get(light);
                if (modelBufferMap != null) {
                    return modelBufferMap.get(textureAtlasSprite);
                }
                return null;
            }
            return this.modelBufferNoAtlasLight.get(light);
        }
        if (textureAtlasSprite != null) {
            return (VertexBuffer)this.modelBuffers.get(textureAtlasSprite);
        }
        return this.modelBufferNoAtlas;
    }

    protected void uploadBuffer(VertexBuffer buffer, BufferBuilder bufferbuilder, int light, @Nullable TextureAtlasSprite textureAtlasSprite, boolean shouldBeginAgain) {
        BufferBuilder.RenderedBuffer rb = bufferbuilder.m_231175_();
        buffer.m_85921_();
        buffer.m_231221_(rb);
        VertexBuffer.m_85931_();
        if (shouldBeginAgain) {
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
        }
        if (JSG.oculusWrapper.isShaderPackActive()) {
            if (textureAtlasSprite != null) {
                Map<TextureAtlasSprite, VertexBuffer> modelBufferMap = this.modelBuffersLight.getOrDefault(light, Maps.newHashMap());
                modelBufferMap.put(textureAtlasSprite, buffer);
                this.modelBuffersLight.put(light, modelBufferMap);
                return;
            }
            this.modelBufferNoAtlasLight.put(light, buffer);
            return;
        }
        if (textureAtlasSprite != null) {
            this.modelBuffers.put(textureAtlasSprite, buffer);
            return;
        }
        this.modelBufferNoAtlas = buffer;
    }

    @Override
    @Nullable
    protected VertexBuffer initModel(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation usedTexture) {
        VertexBuffer modelBuffer = this.getBuffer(light, textureAtlasSprite);
        if (modelBuffer == null) {
            BufferBuilder bufferbuilder;
            VertexConsumer vertexConsumer;
            boolean shouldBeginAgain = false;
            if (usedTexture != null && (vertexConsumer = bufferSource.m_6299_(RenderTypes.OBJ_TYPE.apply(usedTexture, EmissiveRenderer.getShaderInstanceSupplier(emissiveRendering, poseStack, light, null)))) instanceof BufferBuilder) {
                BufferBuilder customBuilder;
                bufferbuilder = customBuilder = (BufferBuilder)vertexConsumer;
                shouldBeginAgain = true;
            } else {
                bufferbuilder = Tesselator.m_85913_().m_85915_();
            }
            modelBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            if (!bufferbuilder.m_85732_()) {
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
            }
            int vertexCount = ((OBJModel)this.model).vertices.length;
            for (int i = 0; i < vertexCount; i += 3) {
                Vector3f normal1 = new Vector3f(((OBJModel)this.model).normals[i], ((OBJModel)this.model).normals[i + 1], ((OBJModel)this.model).normals[i + 2]);
                Vector2f uv1 = new Vector2f(((OBJModel)this.model).textureCoords[i / 3 * 2], ((OBJModel)this.model).textureCoords[i / 3 * 2 + 1]);
                uv1 = InGameOBJModelRenderer.getCorrectUVWithSprite(uv1.getX(), uv1.getY(), textureAtlasSprite);
                bufferbuilder.m_5483_((double)((OBJModel)this.model).vertices[i], (double)((OBJModel)this.model).vertices[i + 1], (double)((OBJModel)this.model).vertices[i + 2]).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uv1.x, uv1.y).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(normal1.x(), normal1.y(), normal1.z()).m_5752_();
            }
            this.uploadBuffer(modelBuffer, bufferbuilder, light, textureAtlasSprite, shouldBeginAgain);
        }
        return modelBuffer;
    }

    @Override
    protected void renderModel(@Nullable VertexBuffer modelBuffer, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation usedTexture) {
        if (modelBuffer == null) {
            return;
        }
        EmissiveRenderer.renderWithLightOverlay(poseStack, light, emissiveRendering, () -> {
            if (noCulling) {
                RenderSystem.disableCull();
            }
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            modelBuffer.m_85921_();
        }, () -> {
            Matrix4f projection = RenderSystem.getProjectionMatrix();
            modelBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projection, Objects.requireNonNull(RenderSystem.getShader()));
            VertexBuffer.m_85931_();
        });
    }
}

