/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.client.model.IModelLoader;
import dev.tauri.jsg.api.client.renderer.BlockRenderer;
import dev.tauri.jsg.api.client.renderer.LinkableRenderer;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.helper.JSGMinecraftHelper;
import dev.tauri.jsg.api.multistructure.IMultiStructureRenderer;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.JSGColorUtil;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.api.util.math.MathHelper;
import dev.tauri.jsg.api.util.vectors.Vector3f;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.renderer.stargate.StargateRendererStatic;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public abstract class StargateAbstractRenderer<S extends StargateAbstractRendererState>
implements LinkableRenderer,
BlockEntityRenderer<StargateAbstractBaseBE<?, ?>>,
IMultiStructureRenderer<StargateAbstractBaseBE<?, ?>> {
    public StargateAbstractBaseBE<?, ?> tileEntity;
    public PoseStack stack;
    public MultiBufferSource source;
    public int combinedLight;
    public Level level;
    public float partialTicks;
    public S rendererState;
    protected static final String EV_HORIZON_OVERLAY_TEXTURE = "textures/tesr/event_horizon_animated_overlay.png";
    protected static final String EV_HORIZON_KAWOOSH_OVERLAY_TEXTURE = "textures/tesr/event_horizon_animated_overlay_kawoosh.png";
    private static final float VORTEX_START = 5.275f;
    private static final float SPEED_FACTOR = 6.0f;
    private static final Map<ResourceLocation, Boolean> EH_RENDERED = new HashMap<ResourceLocation, Boolean>();

    public StargateAbstractRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRenderOffScreen(StargateAbstractBaseBE baseBE) {
        return true;
    }

    public int m_142163_() {
        return 192;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRender(StargateAbstractBaseBE baseBE, Vec3 vec3) {
        return super.m_142756_((BlockEntity)baseBE, vec3);
    }

    @ParametersAreNonnullByDefault
    public void initForGui(StargateAbstractBaseBE<?, ?> tile, GuiGraphics graphics) {
        this.tileEntity = tile;
        this.level = tile.m_58904_();
        this.rendererState = ((StargateAbstractStateManager)tile.getStateManager()).getRendererStateClient();
        this.stack = graphics.m_280168_();
        this.partialTicks = 0.0f;
        this.source = graphics.m_280091_();
        StargateRendererStatic.currentStack = this.stack;
        StargateRendererStatic.packedLight = 0;
    }

    public int getCombinedLight() {
        double count = 0.0;
        double count2 = 0.0;
        double blockSum = 0.0;
        double skySum = 0.0;
        for (Map.Entry<BlockPos, BlockState> block : this.tileEntity.getMergeHelper().getBlocks().entrySet()) {
            for (Direction side : Direction.values()) {
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)block.getKey().m_121955_(side.m_122436_()));
                int blockLight = LightTexture.m_109883_((int)light);
                int skyLight = LightTexture.m_109894_((int)light);
                float coef = (float)(blockLight + skyLight + 1) / 32.0f;
                count += (double)coef;
                count2 += (double)(2.0f * coef);
                blockSum += (double)((float)((long)blockLight * 2L) * coef);
                skySum += (double)((float)skyLight * coef);
            }
        }
        if (count == 0.0) {
            return 0xF000F0;
        }
        return LightTexture.m_109885_((int)((int)(blockSum / count2)), (int)((int)(skySum / count)));
    }

    public void renderCamoBlocks(int combinedOverlay) {
        this.stack.m_85836_();
        ArrayList<Map.Entry<BlockPos, BlockState>> list = new ArrayList<Map.Entry<BlockPos, BlockState>>(this.tileEntity.getMergeHelper().getBlocks().entrySet());
        list.add(new AbstractMap.SimpleEntry<BlockPos, BlockState>(this.tileEntity.m_58899_(), this.tileEntity.m_58900_()));
        for (Map.Entry<BlockPos, BlockState> block : list) {
            CamouflageBE camoBE;
            BlockState camoState;
            BlockEntity tile = this.level.m_7702_(block.getKey());
            if (!(tile instanceof CamouflageBE) || (camoState = (camoBE = (CamouflageBE)tile).getCamoBlock()).m_60795_()) continue;
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)block.getKey());
            BlockRenderer.renderBlockShaded(this.tileEntity.m_58904_(), block.getKey(), camoState, block.getKey().m_121996_((Vec3i)this.tileEntity.m_58899_()), this.stack, this.source, light, combinedOverlay);
        }
        this.stack.m_85849_();
    }

    @ParametersAreNonnullByDefault
    public void render(StargateAbstractBaseBE baseBE, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int ignoredLight, int combinedOverlay) {
        this.renderLink(baseBE.m_58899_(), baseBE, stack, bufferSource);
        this.tileEntity = baseBE;
        this.rendererState = ((StargateAbstractStateManager)baseBE.getStateManager()).getRendererStateClient();
        this.stack = stack;
        this.partialTicks = partialTicks;
        this.source = bufferSource;
        if (this.tileEntity.m_58904_() == null) {
            return;
        }
        this.level = this.tileEntity.m_58904_();
        this.combinedLight = this.getCombinedLight();
        if (!this.shouldRender()) {
            this.renderBuildingHelper(this.tileEntity, stack, this.source, this.combinedLight, combinedOverlay);
        } else {
            ((StargateAbstractStateManager)this.tileEntity.getStateManager()).getChevronsState().update(partialTicks);
            this.renderCamoBlocks(combinedOverlay);
            this.stack.m_85836_();
            if (JSGConfig.Debug.renderBoundingBoxes.get() || Minecraft.m_91087_().m_91290_().m_114377_()) {
                this.stack.m_85836_();
                ((JSGAxisAlignedBB)this.tileEntity.getRenderBoundingBox()).inset(this.tileEntity.m_58899_()).render((Component)Component.m_237113_((String)"RenderBox"), stack, bufferSource);
                this.tileEntity.getEventHorizonManager().getLocalTeleportBox().render((Component)Component.m_237113_((String)"TeleportBox"), stack, bufferSource, 0.16470589f, 0.6627451f, 0.84313726f, 1.0f);
                this.tileEntity.getEventHorizonManager().getLocalTeleportBoxBack().render((Component)Component.m_237113_((String)"TeleportBox_subtickBack"), stack, bufferSource, 0.0627451f, 0.22745098f, 0.6862745f, 1.0f);
                this.tileEntity.getEventHorizonManager().getLocalTeleportBoxFront().render((Component)Component.m_237113_((String)"TeleportBox_subtickFront"), stack, bufferSource, 0.3137255f, 0.8862745f, 0.69803923f, 1.0f);
                int i = 1;
                for (JSGAxisAlignedBB aabb : this.tileEntity.getEventHorizonManager().getLocalInnerBlockBoxes()) {
                    aabb.render((Component)Component.m_237113_((String)("EHFormingBox_" + i)), stack, bufferSource, 0.8980392f, 0.12156863f, 0.12156863f, 1.0f);
                    ++i;
                }
                i = 1;
                for (JSGAxisAlignedBB aabb : this.tileEntity.getEventHorizonManager().getLocalKillingBoxes()) {
                    aabb.render((Component)Component.m_237113_((String)("KawooshBox_" + i)), stack, bufferSource, 0.84705883f, 0.12156863f, 0.8980392f, 1.0f);
                    ++i;
                }
                this.stack.m_85849_();
            }
            this.stack.m_85836_();
            this.stack.m_85837_(0.5, 0.5, 0.5);
            this.stack.m_252781_(RotationUtil.getRotation(this.tileEntity.getFacingVertical(), this.tileEntity.getFacing()));
            this.applyTransformations();
            this.stack.m_85836_();
            StargateRendererStatic.currentStack = this.stack;
            StargateRendererStatic.packedLight = this.combinedLight;
            Vector3f gateRedColor = this.getGateColor();
            this.renderWholeGate();
            this.stack.m_85849_();
            this.stack.m_85849_();
            this.stack.m_85849_();
            this.renderCamoBlocks(combinedOverlay);
        }
    }

    protected Vector3f getGateColor() {
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    protected abstract void applyTransformations();

    public ITextureLoader getTextureLoader() {
        return LoadersHolder.JSG_HOLDER.texture();
    }

    public IModelLoader getModelsLoader() {
        return LoadersHolder.JSG_HOLDER.model();
    }

    public void renderWholeGate() {
        this.renderGate();
        this.renderIris(true);
        if (((StargateAbstractRendererState)this.rendererState).doEventHorizonRender) {
            this.stack.m_85836_();
            this.renderKawoosh();
            this.stack.m_85849_();
        } else if (JSGConfig.Stargate.renderEHifTheyNot.get()) {
            this.stack.m_85836_();
            this.preRenderKawoosh();
            this.stack.m_85849_();
        }
        this.renderIris(false);
    }

    protected boolean shouldRender() {
        if (this.tileEntity == null) {
            return false;
        }
        if (this.rendererState == null) {
            return false;
        }
        return this.tileEntity.m_58900_().m_61138_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) && (Boolean)this.tileEntity.m_58900_().m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) == false;
    }

    protected abstract void renderGate();

    public void scaleVortex() {
    }

    public boolean shouldRenderBackVortex() {
        return false;
    }

    protected ResourceLocation getEventHorizonTextureResource(boolean kawoosh) {
        return new ResourceLocation("jsg", kawoosh ? EV_HORIZON_KAWOOSH_OVERLAY_TEXTURE : EV_HORIZON_OVERLAY_TEXTURE);
    }

    protected void renderKawoosh() {
        this.renderKawoosh((StargateAbstractRendererState)this.rendererState, true);
    }

    protected void preRenderKawoosh() {
        StargateAbstractRendererState rs = new StargateAbstractRendererState().initClient(((StargateAbstractRendererState)this.rendererState).pos, ((StargateAbstractRendererState)this.rendererState).getBiomeOverlay());
        for (int i = 0; i < 2; ++i) {
            rs.vortexState = i == 0 ? EnumVortexState.STILL : EnumVortexState.FORMING;
            this.renderKawoosh(rs, false);
        }
    }

    @Nonnull
    public abstract Pair<Integer, Integer> getEventHorizonColor();

    protected void renderKawoosh(StargateAbstractRendererState rendererState, boolean render) {
        ITexture ehTexture;
        float gateWait = (float)this.tileEntity.getTime() - (float)rendererState.gateWaitStart;
        if (gateWait < 20.0f) {
            return;
        }
        boolean isKawoosh = rendererState.vortexState == EnumVortexState.FORMING || rendererState.vortexState == EnumVortexState.DECREASING || rendererState.vortexState == EnumVortexState.FULL;
        ResourceLocation ehTextureRes = this.getEventHorizonTextureResource(isKawoosh && !rendererState.noxDialing);
        if (!render && EH_RENDERED.get(ehTextureRes).booleanValue()) {
            return;
        }
        EH_RENDERED.put(ehTextureRes, true);
        this.stack.m_85836_();
        this.stack.m_85837_(0.0, 0.0, 0.06);
        if (!render) {
            this.stack.m_85841_(1.0E-7f, 1.0E-7f, 1.0E-7f);
        }
        if ((ehTexture = this.getTextureLoader().getTexture(ehTextureRes)) != null) {
            ehTexture.bindTexture();
        }
        long kawooshStart = rendererState.gateWaitStart + 44L - 24L;
        float tick = (float)(this.level.m_46467_() - kawooshStart) + this.partialTicks;
        float inner = 3.790975f - tick / (rendererState.noxDialing ? 3.2f : 1.0f) / 3.957f;
        float tick2 = tick / 4.0f;
        if ((double)tick2 <= 1.5707963267948966) {
            rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.cos(tick2));
        } else if (!rendererState.zeroAlphaSet) {
            rendererState.zeroAlphaSet = true;
            rendererState.whiteOverlayAlpha = Float.valueOf(0.0f);
        }
        float kawooshRadius = 0.2f;
        if (rendererState.noxDialing) {
            kawooshRadius = 0.2f;
        }
        float noxAlpha = 0.0f;
        if (rendererState.noxDialing) {
            noxAlpha = Math.min(0.8f, Math.max(0.0f, inner / 3.790975f));
        }
        if (rendererState.vortexState != EnumVortexState.STILL && rendererState.vortexState != EnumVortexState.CLOSING) {
            if (inner >= 0.2f) {
                rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, inner - 0.2f, 3.790975f, Float.valueOf(tick));
            }
        } else {
            rendererState.frontStrip = null;
        }
        if (inner >= kawooshRadius) {
            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, inner - 0.2f, 3.790975f, Float.valueOf(tick));
        }
        if (inner < 2.5f) {
            if (rendererState.backStripClamp) {
                float argState;
                if (inner < kawooshRadius) {
                    rendererState.backStripClamp = false;
                    rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, kawooshRadius - 0.2f, 3.790975f, null);
                }
                if ((argState = (tick - 5.275f) / 6.0f) < 1.342f) {
                    rendererState.vortexState = EnumVortexState.FORMING;
                } else if (argState < 4.15f) {
                    rendererState.vortexState = EnumVortexState.FULL;
                } else if (argState < 5.898f) {
                    rendererState.vortexState = EnumVortexState.DECREASING;
                } else if (rendererState.vortexState != EnumVortexState.CLOSING) {
                    rendererState.vortexState = EnumVortexState.STILL;
                }
            }
            if (rendererState.frontStripClamp && inner < 0.2f) {
                rendererState.frontStripClamp = false;
                rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, 0.0f, 3.790975f, null);
            }
            if (rendererState.vortexState != EnumVortexState.STILL) {
                float arg = (tick - 5.275f) / 6.0f;
                if (rendererState.vortexState != EnumVortexState.CLOSING) {
                    if (rendererState.vortexState != EnumVortexState.SHRINKING) {
                        float mul;
                        if (rendererState.vortexState == EnumVortexState.FORMING && arg >= 1.342f) {
                            rendererState.vortexState = EnumVortexState.FULL;
                        }
                        float end = 0.75f;
                        if (rendererState.vortexState == EnumVortexState.DECREASING && (double)arg >= 5.398 + (double)end) {
                            rendererState.vortexState = EnumVortexState.STILL;
                        }
                        if (rendererState.vortexState == EnumVortexState.FULL) {
                            if (arg >= 3.65f + end) {
                                rendererState.vortexState = EnumVortexState.DECREASING;
                            }
                            mul = arg < 2.0f ? (arg - 1.5f) * (arg - 2.5f) / -10.0f + 0.91f : (arg > 3.0f + end ? (arg - 2.5f - end) * (arg - 3.5f - end) / -10.0f + 0.91f : 0.935f);
                        } else {
                            mul = rendererState.vortexState == EnumVortexState.FORMING ? arg * (arg - 4.0f) / -4.0f : (arg - 1.0f - end) * (arg - 5.0f - end) / -5.968f + 0.29333f;
                        }
                        boolean renderWortex = true;
                        if (rendererState instanceof StargateClassicRendererState) {
                            StargateClassicRendererState casted = (StargateClassicRendererState)rendererState;
                            if (casted.irisState == EnumIrisState.CLOSED && casted.irisType != EnumIrisType.NULL) {
                                mul = 0.0f;
                                renderWortex = false;
                            }
                        }
                        if (!rendererState.noxDialing && renderWortex) {
                            this.stack.m_85836_();
                            this.scaleVortex();
                            float prevZ = 0.0f;
                            float prevRad = 0.0f;
                            int index = 0;
                            for (Map.Entry<Float, Float> e : StargateRendererStatic.Z_RadiusMap.entrySet()) {
                                float currentRad;
                                Float currentZ = e.getKey();
                                if (currentZ.floatValue() < 0.0f || currentZ.floatValue() >= 0.0f && mul <= 0.0f) continue;
                                float mulAbs = Math.abs(mul);
                                float f = currentRad = e.getValue().floatValue() == 0.0f ? 0.0f : e.getValue().floatValue() + StargateRendererStatic.getOffset(index, tick, 7.0f, 1);
                                if (index != 0) {
                                    new StargateRendererStatic.QuadStrip(9, currentRad, prevRad, Float.valueOf(tick), 1.4f).render(tick, Float.valueOf(currentZ.floatValue() * mulAbs), Float.valueOf(prevZ * mulAbs), false, Float.valueOf(1.0f - rendererState.whiteOverlayAlpha.floatValue()), 5.0f, false, (Integer)this.getEventHorizonColor().first(), (Integer)this.getEventHorizonColor().second());
                                }
                                prevZ = currentZ.floatValue();
                                prevRad = currentRad;
                                ++index;
                            }
                            this.stack.m_85849_();
                        }
                    } else {
                        long stateChange = rendererState.gateWaitClose + 35L;
                        float arg2 = ((float)(this.level.m_46467_() - stateChange) + this.partialTicks) / 3.0f - 1.0f;
                        rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.sin(arg2));
                        if (arg2 < 3.890975f) {
                            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                            rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        } else {
                            rendererState.whiteOverlayAlpha = null;
                            if (this.level.m_46467_() - stateChange - 9L > 7L) {
                                rendererState.doEventHorizonRender = false;
                            }
                        }
                    }
                } else if (this.level.m_46467_() - rendererState.gateWaitClose > 35L) {
                    float arg2 = ((float)(this.level.m_46467_() - (rendererState.gateWaitClose + 35L)) + this.partialTicks) / 6.0f / 2.0f;
                    if ((double)arg2 <= 0.5235987755982988) {
                        rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.sin(arg2));
                    } else {
                        if (rendererState.backStrip == null) {
                            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        }
                        if (rendererState.frontStrip == null) {
                            rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        }
                        rendererState.vortexState = EnumVortexState.SHRINKING;
                    }
                }
            }
        }
        if (rendererState.vortexState != null && (rendererState.vortexState == EnumVortexState.STILL || rendererState.vortexState == EnumVortexState.CLOSING)) {
            if (rendererState.vortexState == EnumVortexState.CLOSING) {
                this.renderEventHorizon(true, rendererState.whiteOverlayAlpha, false, 1.7f);
            } else {
                this.renderEventHorizon(false, rendererState.horizonUnstable ? Float.valueOf(0.05f + (float)(Math.sin((double)(tick / 4.0f) * Math.PI) * (double)0.05f)) : null, false, rendererState.horizonUnstable ? 1.2f : 1.0f);
            }
            this.stack.m_85849_();
            return;
        }
        if (rendererState.whiteOverlayAlpha != null) {
            if (rendererState.backStrip != null) {
                rendererState.backStrip.render(tick, Float.valueOf(0.0f), Float.valueOf(0.0f), false, Float.valueOf(Math.max(0.0f, 1.0f - rendererState.whiteOverlayAlpha.floatValue() - noxAlpha)), 1.0f, (Integer)this.getEventHorizonColor().first(), (Integer)this.getEventHorizonColor().second());
            }
            if (rendererState.frontStrip != null) {
                if (this.shouldRenderBackVortex()) {
                    this.renderEventHorizon(false, Float.valueOf(0.3f), false, 1.0f, true);
                }
                double tickFromStart = (double)(this.level.m_46467_() - kawooshStart) + (double)this.partialTicks;
                double arg2 = ((tickFromStart - (double)5.275f) / 6.0 - 4.4) / 1.5;
                if (!this.shouldRenderBackVortex() || arg2 <= 0.0) {
                    this.stack.m_85836_();
                    RenderSystem.enableBlend();
                    this.stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                    ehTextureRes = this.getEventHorizonTextureResource(false);
                    ehTexture = this.getTextureLoader().getTexture(ehTextureRes);
                    if (ehTexture != null) {
                        ehTexture.bindTexture();
                    }
                    Float alpha = Float.valueOf(Math.max(0.0f, 1.0f - rendererState.whiteOverlayAlpha.floatValue() - 0.3f - noxAlpha));
                    rendererState.frontStrip.render(tick, Float.valueOf(0.0f), Float.valueOf(0.0f), false, alpha, 1.0f, (Integer)this.getEventHorizonColor().first(), (Integer)this.getEventHorizonColor().second());
                    RenderSystem.disableBlend();
                    this.stack.m_85849_();
                }
            }
        }
        this.stack.m_85849_();
    }

    protected void renderEventHorizon(boolean white, Float alpha, boolean backOnly, float mul) {
        this.renderEventHorizon(white, alpha, backOnly, mul, false);
    }

    protected void renderEventHorizon(boolean white, Float alpha, boolean backOnly, float mul, boolean closingAnimation) {
        if (this.getBlackHoleVortexDepth() != 0.0f || this.getBlackHoleVortexRedMul() > 0.0f) {
            this.renderBackVortex(closingAnimation, false, this.getBlackHoleVortexDepth(), ((StargateAbstractStateManager)this.tileEntity.getStateManager()).getBlackHoleAnimationState().getBackVortexAngle(), this.getBlackHoleVortexRedMul());
            return;
        }
        float tick = JSGMinecraftHelper.getClientTick();
        if (!closingAnimation) {
            RenderSystem.enableBlend();
            for (int k = backOnly ? 1 : 0; k < (this.shouldRenderBackVortex() ? 1 : 2); ++k) {
                this.stack.m_85836_();
                if (k == 1) {
                    this.stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                }
                if (alpha == null) {
                    alpha = Float.valueOf(0.0f);
                }
                if (k == 1) {
                    alpha = Float.valueOf(alpha.floatValue() + 0.3f);
                }
                int outerColor = JSGColorUtil.blendColors((Integer)this.getEventHorizonColor().first(), -1, ((StargateAbstractRendererState)this.rendererState).horizonUnstable ? 0.05f + (float)(Math.sin((double)(tick / 2.0f) * Math.PI) * (double)0.1f) : 0.0f);
                if (white) {
                    StargateRendererStatic.innerCircle.render(tick, true, alpha, mul, (byte)0, outerColor, (Integer)this.getEventHorizonColor().second());
                }
                StargateRendererStatic.innerCircle.render(tick, false, Float.valueOf(1.0f - alpha.floatValue()), mul, (byte)0, outerColor, (Integer)this.getEventHorizonColor().second());
                for (StargateRendererStatic.QuadStrip strip : StargateRendererStatic.quadStrips) {
                    if (white) {
                        strip.render(tick, true, alpha, mul, (byte)0, outerColor, (Integer)this.getEventHorizonColor().second());
                    }
                    strip.render(tick, false, Float.valueOf(1.0f - alpha.floatValue()), mul, (byte)0, outerColor, (Integer)this.getEventHorizonColor().second());
                }
                this.stack.m_85849_();
            }
            RenderSystem.disableBlend();
        }
        if (this.shouldRenderBackVortex()) {
            this.renderBackVortex(closingAnimation, tick);
        }
    }

    public float getBlackHoleVortexDepth() {
        return ((StargateAbstractStateManager)this.tileEntity.getStateManager()).getBlackHoleAnimationState().getBackVortexDepth();
    }

    public float getBlackHoleVortexRedMul() {
        return ((StargateAbstractStateManager)this.tileEntity.getStateManager()).getBlackHoleAnimationState().getBackVortexRed();
    }

    protected void renderBackVortex(boolean closingAnimation, double rotationZ) {
        long kawooshStart = ((StargateAbstractRendererState)this.rendererState).gateWaitStart + 44L - 24L;
        double tickFromStart = (double)(this.level.m_46467_() - kawooshStart) + (double)this.partialTicks;
        double arg = ((tickFromStart - (double)5.275f) / 6.0 - 4.4) / 1.5;
        if (arg < 0.0) {
            return;
        }
        float factor = arg > 1.82 ? 1.0f : (float)(-((arg + (double)2.65f) * (arg + (double)2.65f - 4.0) / -5.6746697425842285) + (double)0.63f);
        float depthMul = 0.3085f * factor * 2.0f;
        this.renderBackVortex(closingAnimation, true, depthMul, rotationZ, 0.0f);
    }

    protected void renderBackVortex(boolean closingAnimation, boolean onlyBack, float depthMul, double rotationZ, float redMul) {
        float ticks = JSGMinecraftHelper.getClientTick();
        Integer c = (Integer)this.getEventHorizonColor().first();
        Integer c2 = (Integer)this.getEventHorizonColor().second();
        int mixColors = JSGColorUtil.blendColors(c, -13171638, redMul);
        int mixColorsInner = JSGColorUtil.blendColors(c2, -16777216, redMul);
        RenderSystem.enableBlend();
        this.stack.m_85836_();
        this.stack.m_85850_().m_252922_().rotate((Quaternionfc)Axis.f_252403_.m_252977_((float)(rotationZ % 360.0)));
        this.scaleVortex();
        for (int i = 0; i < (onlyBack ? 1 : 2); ++i) {
            this.stack.m_85836_();
            if (i == 1) {
                this.stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            }
            float prevZ = 0.0f;
            float prevRad = 0.0f;
            int index = 0;
            for (Map.Entry<Float, Float> e : StargateRendererStatic.Z_RadiusMap.entrySet()) {
                Float currentZ = e.getKey();
                if (currentZ.floatValue() > 0.0f) continue;
                currentZ = Float.valueOf(currentZ.floatValue() * depthMul);
                float currentRad = e.getValue().floatValue() == 0.0f ? 0.0f : e.getValue().floatValue() + StargateRendererStatic.getOffset(index, ticks, 7.0f, 1);
                float mul2 = 0.5f * (-currentZ.floatValue() / 5.0f) * (Math.max(0.0f, 1.0f + currentZ.floatValue()) / 2.0f);
                if (currentZ.floatValue() < 0.2f) {
                    mul2 = 0.0f;
                }
                mul2 *= Math.abs(currentZ.floatValue() / 10.0f);
                if (currentZ.floatValue() == 0.0f) {
                    currentRad = 3.790975f;
                    mul2 = 0.0f;
                }
                if (i == 1) {
                    currentZ = Float.valueOf(currentZ.floatValue() * -1.0f);
                }
                if (((StargateAbstractRendererState)this.rendererState).frontStrip != null && closingAnimation && currentRad < ((StargateAbstractRendererState)this.rendererState).frontStrip.innerRadius) continue;
                if (index != 0) {
                    new StargateRendererStatic.QuadStrip(9, currentRad, prevRad, Float.valueOf(ticks), 1.4f * mul2).renderCurved(ticks, false, Float.valueOf(i == 1 ? 1.0f : 0.7f), currentZ.floatValue(), currentZ.floatValue(), currentZ.floatValue(), currentZ.floatValue(), prevZ, mixColors, mixColorsInner);
                }
                prevZ = currentZ.floatValue();
                prevRad = currentRad;
                ++index;
            }
            this.stack.m_85849_();
        }
        this.stack.m_85849_();
        RenderSystem.disableBlend();
    }

    protected void renderIris(boolean backOnly) {
    }

    static {
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_OVERLAY_TEXTURE), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_KAWOOSH_OVERLAY_TEXTURE), false);
    }

    public static enum EnumVortexState {
        FORMING(0),
        FULL(1),
        DECREASING(2),
        STILL(3),
        CLOSING(4),
        SHRINKING(5);

        private static final Map<Integer, EnumVortexState> map;
        public final int index;

        private EnumVortexState(int index) {
            this.index = index;
        }

        public static EnumVortexState valueOf(int index) {
            return map.get(index);
        }

        public boolean equals(EnumVortexState state) {
            return this.index == state.index;
        }

        static {
            map = new HashMap<Integer, EnumVortexState>();
            for (EnumVortexState packet : EnumVortexState.values()) {
                map.put(packet.index, packet);
            }
        }
    }
}

