/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.StargateWithIris;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.util.math.MathFunctionImpl;
import dev.tauri.jsg.api.util.math.MathHelper;
import dev.tauri.jsg.api.util.vectors.Vector3f;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRenderer;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.renderer.stargate.StargateRendererStatic;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.StargateIrisManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public abstract class StargateClassicRenderer<S extends StargateClassicRendererState>
extends StargateAbstractRenderer<S> {
    protected static final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("jsg", "textures/tesr/iris/shield.jpg");
    public static final int PHYSICAL_IRIS_ANIMATION_LENGTH = 65;
    public static final int SHIELD_IRIS_ANIMATION_LENGTH = 10;
    public static final MathFunctionImpl IRIS_ANIMATION = new MathFunctionImpl(x -> ((x * 1.5f - 1.0f) * (x * 1.5f - 1.0f) * (x * 1.5f - 1.0f) + 1.0f + x * 1.5f / 2.0f) / 1.875f);
    public static final MathFunctionImpl IRIS_ANIMATION_OPENING = new MathFunctionImpl(x -> (float)(Math.sin(10.0f * x) * (double)x / 10.0 + (double)x) / 0.9456f);

    public StargateClassicRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    public abstract float getGateDiameter();

    public abstract double getScaleMultiplier();

    @Override
    protected void applyTransformations() {
        float scale = (float)(((StargateClassicRendererState)this.rendererState).stargateSize.renderScale * this.getScaleMultiplier());
        this.stack.m_85837_(0.0, (double)(this.getGateDiameter() * scale / 2.0f) - 0.3, 0.0);
        this.stack.m_85841_(scale, scale, scale);
    }

    protected abstract void renderChevron(ChevronEnum var1, StargateChevronsState.ChevronState var2, float var3, boolean var4);

    protected void renderChevrons() {
        for (ChevronEnum chevron : ChevronEnum.values()) {
            this.stack.m_85836_();
            StargateChevronsState.ChevronState state = ((StargateAbstractStateManager)this.tileEntity.getStateManager()).getChevronsState().get(chevron);
            this.renderChevron(chevron, state, 1.0f, false);
            int chevronLight = (int)(state.getState() * 1.5f);
            float maxLight = Math.max(this.combinedLight, LightTexture.m_109885_((int)chevronLight, (int)chevronLight));
            this.renderChevron(chevron, state, state.isLocked() ? maxLight / 1.572888E7f : 1.0f, true);
            this.stack.m_85849_();
        }
    }

    @Override
    public void renderIris(boolean backOnly) {
        float irisAnimationStage = (float)(this.level.m_46467_() - ((StargateClassicRendererState)this.rendererState).irisAnimation) + this.partialTicks;
        EnumIrisState irisState = ((StargateClassicRendererState)this.rendererState).irisState;
        EnumIrisType irisType = ((StargateClassicRendererState)this.rendererState).irisType;
        if (irisType == null || irisState == null) {
            return;
        }
        if (irisType == EnumIrisType.SHIELD) {
            if (irisState == EnumIrisState.OPENED) {
                return;
            }
            if ((irisAnimationStage *= 0.07f) > 0.7f) {
                irisAnimationStage = 0.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 0.7f - irisAnimationStage;
            }
            this.stack.m_85836_();
            this.getTextureLoader().getTexture(SHIELD_TEXTURE).bindTexture();
            this.stack.m_85837_(0.0, 0.0, 0.13);
            StargateRendererStatic.currentStack = this.stack;
            StargateRendererStatic.packedLight = this.combinedLight;
            StargateRendererStatic.renderShield(irisAnimationStage, this.getShieldColor(), backOnly);
            this.stack.m_85849_();
        }
        if ((irisType == EnumIrisType.IRIS_TITANIUM || irisType == EnumIrisType.IRIS_TRINIUM || irisType == EnumIrisType.IRIS_CREATIVE) && backOnly) {
            float f;
            Vector3f irisColor = this.getIrisHeatColor();
            if ((irisAnimationStage /= 65.0f) > 1.0f) {
                irisAnimationStage = 1.0f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING || irisState == EnumIrisState.OPENED) {
                irisAnimationStage = IRIS_ANIMATION_OPENING.apply(irisAnimationStage);
                irisAnimationStage = 1.0f - irisAnimationStage;
            } else {
                irisAnimationStage = IRIS_ANIMATION.apply(irisAnimationStage);
            }
            Vec3 irisPivot = this.getIrisPivot();
            StargateAbstractBaseBE stargateAbstractBaseBE = this.tileEntity;
            if (stargateAbstractBaseBE instanceof StargateWithIris) {
                StargateWithIris stargateWithIris = (StargateWithIris)((Object)stargateAbstractBaseBE);
                f = ((StargateIrisManager)stargateWithIris.getIrisManager()).getIrisAnimationState().getIrisImpactOffset(this.tileEntity.getTime(), this.partialTicks);
            } else {
                f = 0.0f;
            }
            float irisImpactOffset = f;
            int irisBladesCount = this.getIrisBladesCount();
            for (float i = 0.0f; i < (float)irisBladesCount; i += 1.0f) {
                float rotateIndex = 360.0f / (float)irisBladesCount * i;
                this.stack.m_85836_();
                this.stack.m_85837_(0.0, 0.0, 0.025);
                this.stack.m_252781_(Axis.f_252403_.m_252977_(rotateIndex));
                this.translateIrisBlade();
                float tiltCoef = (float)MathHelper.clampedLerp(0.0, 1.0, (irisAnimationStage - 0.2f) / 0.8f);
                StargateClassicRenderer.rotateAround(this.stack, Axis.f_252436_.m_252977_(-0.6f + (irisImpactOffset / 3.0f + this.getIrisBladeTilt()) * tiltCoef), irisPivot);
                StargateClassicRenderer.rotateAround(this.stack, Axis.f_252403_.m_252977_(irisAnimationStage * (this.getIrisCloseAngle() - irisImpactOffset * 1.5f * (this.level.f_46441_.m_188501_() * 0.7f + 0.3f))), irisPivot);
                this.getIrisModel().bindTexture().render(this.stack, this.source, this.combinedLight, OverlayTexture.f_118083_, false, irisColor.x, irisColor.y, irisColor.z, 1.0f, false);
                this.stack.m_85849_();
            }
        }
    }

    protected float getIrisCloseAngle() {
        return 45.0f;
    }

    protected ElementEnum getIrisModel() {
        return ElementEnum.IRIS;
    }

    protected int getIrisBladesCount() {
        return 20;
    }

    protected void translateIrisBlade() {
    }

    protected Vec3 getIrisPivot() {
        return new Vec3((double)-5.09075f, 0.0, 0.0);
    }

    protected static void rotateAround(PoseStack stack, Quaternionf rotation, Vec3 pivot) {
        Vec3 pivotN = pivot.m_82542_(-1.0, -1.0, -1.0);
        stack.m_85837_(pivotN.m_7096_(), pivotN.m_7098_(), pivotN.m_7094_());
        stack.m_252781_(rotation);
        stack.m_85837_(pivot.m_7096_(), pivot.m_7098_(), pivot.m_7094_());
    }

    @Override
    protected Vector3f getGateColor() {
        return this.getGateHeatColor();
    }

    public float getIrisBladeTilt() {
        return 1.0f;
    }

    public Vector3f getIrisHeatColor(float red) {
        return new Vector3f(1.0f + red * 3.0f, 1.0f, 1.0f);
    }

    public int getShieldColor() {
        return -1;
    }

    public Vector3f getIrisHeatColor() {
        if (((StargateClassicRendererState)this.rendererState).irisHeat == -1.0) {
            return this.getIrisHeatColor(0.0f);
        }
        float red = (float)(((StargateClassicRendererState)this.rendererState).irisHeat / (((StargateClassicRendererState)this.rendererState).irisType == EnumIrisType.IRIS_TITANIUM ? StargateClassicBaseBE.IRIS_MAX_HEAT_TITANIUM : StargateClassicBaseBE.IRIS_MAX_HEAT_TRINIUM));
        if (((StargateClassicRendererState)this.rendererState).irisType == EnumIrisType.IRIS_CREATIVE) {
            red = 0.0f;
        }
        return this.getIrisHeatColor(red);
    }

    public Vector3f getGateHeatColor() {
        if (((StargateClassicRendererState)this.rendererState).gateHeat == -1.0) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        float red = (float)(((StargateClassicRendererState)this.rendererState).gateHeat / StargateClassicBaseBE.GATE_MAX_HEAT);
        return new Vector3f(1.0f + red * 2.7f, 1.0f, 1.0f);
    }
}

