/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.StargateSizeEnum;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;

public abstract class StargateClassicRendererState
extends StargateAbstractRendererState {
    public StargateSizeEnum stargateSize = JSGConfig.Stargate.stargateSize.get();
    public BiomeOverlayRegistry.BiomeOverlayInstance biomeOverride;
    public EnumIrisType irisType;
    public EnumIrisState irisState;
    public long irisAnimation;
    public double irisHeat = 0.0;
    public double gateHeat = 0.0;

    public StargateClassicRendererState() {
    }

    public StargateClassicRendererState(StargateClassicRendererStateBuilder builder) {
        super(builder);
        this.biomeOverride = builder.biomeOverride;
        this.irisState = builder.irisState;
        this.irisType = builder.irisType;
        this.irisAnimation = builder.irisAnimation;
        this.stargateSize = builder.stargateSize;
    }

    @Override
    public BiomeOverlayRegistry.BiomeOverlayInstance getBiomeOverlay() {
        if (this.biomeOverride != null) {
            return this.biomeOverride;
        }
        return super.getBiomeOverlay();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (this.stargateSize == null) {
            this.stargateSize = JSGConfig.Stargate.stargateSize.get();
        }
        buf.writeInt(this.stargateSize.id);
        if (this.biomeOverride != null) {
            buf.writeBoolean(true);
            new FriendlyByteBuf(buf).m_130085_(this.biomeOverride.id);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte((int)this.irisState.id);
        buf.writeByte((int)this.irisType.id);
        buf.writeLong(this.irisAnimation);
        buf.writeDouble(this.irisHeat);
        buf.writeDouble(this.gateHeat);
        super.toBytes(buf);
    }

    public ITextureLoader getTextureLoader() {
        return LoadersHolder.JSG_HOLDER.texture();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.stargateSize = StargateSizeEnum.fromId(buf.readInt());
        if (buf.readBoolean()) {
            this.biomeOverride = BiomeOverlayRegistry.byId(new FriendlyByteBuf(buf).m_130281_());
        }
        this.irisState = EnumIrisState.getValue(buf.readByte());
        this.irisType = EnumIrisType.byId(buf.readByte());
        this.irisAnimation = buf.readLong();
        this.irisHeat = buf.readDouble();
        this.gateHeat = buf.readDouble();
        super.fromBytes(buf);
    }

    public static StargateClassicRendererStateBuilder builder() {
        return new StargateClassicRendererStateBuilder();
    }

    public static class StargateClassicRendererStateBuilder
    extends StargateAbstractRendererState.StargateAbstractRendererStateBuilder {
        protected AbstractSymbolType<?> symbolType;
        private StargateSizeEnum stargateSize;
        public BiomeOverlayRegistry.BiomeOverlayInstance biomeOverride;
        public EnumIrisState irisState;
        public EnumIrisType irisType;
        public String irisCode;
        public EnumIrisMode irisMode;
        public long irisAnimation;

        public StargateClassicRendererStateBuilder() {
        }

        public StargateClassicRendererStateBuilder(StargateAbstractRendererState.StargateAbstractRendererStateBuilder superBuilder) {
            this.setStargateState(superBuilder.stargateState);
        }

        public StargateClassicRendererStateBuilder setStargateSize(StargateSizeEnum stargateSize) {
            this.stargateSize = stargateSize;
            return this;
        }

        public StargateClassicRendererStateBuilder setSymbolType(AbstractSymbolType<?> symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public StargateClassicRendererStateBuilder setBiomeOverride(BiomeOverlayRegistry.BiomeOverlayInstance biomeOverride) {
            this.biomeOverride = biomeOverride;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisState(EnumIrisState irisState) {
            this.irisState = irisState;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisType(EnumIrisType irisType) {
            this.irisType = irisType;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisCode(String code) {
            this.irisCode = code;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisMode(EnumIrisMode mode) {
            this.irisMode = mode;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisAnimation(long irisAnimation) {
            this.irisAnimation = irisAnimation;
            return this;
        }
    }
}

