/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolPegasusEnum;
import dev.tauri.jsg.api.util.math.NumberUtils;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import dev.tauri.jsg.renderer.stargate.StargateClassicRenderer;
import dev.tauri.jsg.renderer.stargate.StargatePegasusRendererState;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.animation.chevron.StargatePegasusChevronsState;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.animation.spinning.PegasusSpinHelper;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Matrix4f;

public class StargatePegasusRenderer
extends StargateClassicRenderer<StargatePegasusRendererState> {
    public static final float GATE_DIAMETER = 10.1815f;
    private static final int GLYPHS_COUNT = 36;
    private static final Map<Integer, VertexBuffer> SYMBOLS_MODEL_CACHE = new HashMap<Integer, VertexBuffer>();

    public StargatePegasusRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    public float getGateDiameter() {
        return 10.1815f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.0;
    }

    @Override
    protected void renderGate() {
        double tick;
        int slot;
        this.stack.m_85836_();
        ElementEnum.PEGASUS_GATE.bindTexture(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
        this.stack.m_85849_();
        this.renderRing();
        this.renderChevrons();
        this.stack.m_85836_();
        ClassicSpinHelper spinHelper = ((StargateAbstractDialingManager)this.tileEntity.getDialingManager()).getSpinHelper();
        StargatePegasusChevronsState chevronsState = (StargatePegasusChevronsState)((StargateAbstractStateManager)this.tileEntity.getStateManager()).getChevronsState();
        if (spinHelper.isSpinning() && !chevronsState.isSlotActive(slot = (int)Math.floor(spinHelper.apply(tick = (double)((float)this.level.m_46467_() + this.partialTicks), true)))) {
            this.renderGlyph(((PegasusSpinHelper)spinHelper).getTargetSymbol().getId(), slot, false);
        }
        boolean allDim = !chevronsState.isAnySlotActive();
        for (int i = 0; i < 36; ++i) {
            if (allDim && !spinHelper.isSpinning()) {
                this.renderGlyph(i, i, true);
            }
            if (!chevronsState.isSlotActive(i)) continue;
            this.renderGlyph(chevronsState.getSymbolAtSlot(i).orElse(SymbolTypeRegistry.PEGASUS.getOrigin()).getId(), i, false);
        }
        this.stack.m_85849_();
    }

    private void renderRing() {
        this.stack.m_85836_();
        if (ElementEnum.PEGASUS_RING.model != null && ElementEnum.PEGASUS_RING.biomeTextureResourceMap.get(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay()) != null) {
            ElementEnum.PEGASUS_RING.bindTexture(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
        }
        this.stack.m_85849_();
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, StargateChevronsState.ChevronState state, float color, boolean onlyLight) {
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        float chevronOffset = state.getOffset(this.partialTicks, 1.5f);
        boolean renderEmissive = onlyLight && state.isLocked();
        ITexture chevronTexture = this.getTextureLoader().getTexture(state.getTexture(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay(), onlyLight));
        if (chevronTexture != null) {
            chevronTexture.bindTexture();
            this.stack.m_85836_();
            this.stack.m_252880_(0.0f, chevronOffset, 0.0f);
            ElementEnum.PEGASUS_CHEVRON_MOVING.render(this.stack, this.source, this.combinedLight, renderEmissive);
            this.stack.m_252880_(0.0f, -2.0f * chevronOffset, 0.0f);
            ElementEnum.PEGASUS_CHEVRON_LIGHT.render(this.stack, this.source, this.combinedLight, renderEmissive);
            this.stack.m_85849_();
            if (!onlyLight) {
                ElementEnum.PEGASUS_CHEVRON_FRAME.bindTexture(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
                ElementEnum.PEGASUS_CHEVRON_BACK.render(this.stack, this.source, this.combinedLight);
            }
            this.stack.m_85849_();
        }
    }

    private double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated) {
        this.renderGlyph(glyphId, slot, deactivated, false);
        if (deactivated) {
            this.renderGlyph(glyphId, slot, false, true);
        }
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated, boolean translatePos) {
        if (AbstractOBJModel.getRenderMethod() != AbstractOBJModel.EnumOBJRenderMethod.NORMAL) {
            this.renderGlyphGUI(glyphId, slot, deactivated, translatePos);
            return;
        }
        int correctedSlot = StargatePegasusChevronsState.getCorrectedSlot(slot);
        VertexBuffer vertexBuffer = SYMBOLS_MODEL_CACHE.get(glyphId);
        double radius = 0.94;
        int textureSlot = SymbolTypeRegistry.PEGASUS.valueOf((int)glyphId).textureSlot;
        double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
        float x = (float)((uv[0] + radius) / 2.0);
        float y = (float)((uv[1] + radius) / 2.0);
        float tileSize = 0.27f;
        float uvSize = 0.0625f;
        if (vertexBuffer == null) {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
            buffer.m_5483_((double)(-tileSize), 0.0, (double)(-tileSize)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(x, y).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)(-tileSize), 0.0, (double)tileSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(x, y + uvSize).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)tileSize, 0.0, (double)tileSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(x + uvSize, y + uvSize).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)tileSize, 0.0, (double)(-tileSize)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(x + uvSize, y).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            BufferBuilder.RenderedBuffer rb = buffer.m_231175_();
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(rb);
            VertexBuffer.m_85931_();
        }
        VertexBuffer finalVertexBuffer = vertexBuffer;
        EmissiveRenderer.renderWithLightOverlay(this.stack, 0xF000F0, true, () -> {
            String variant = deactivated ? "stargate_off.png" : "stargate.png";
            SymbolPegasusEnum symbol = SymbolTypeRegistry.PEGASUS.valueOf(glyphId);
            if (symbol != null) {
                symbol.bindIconTexture(this.tileEntity.getPointOfOrigin(), variant);
            }
            finalVertexBuffer.m_85921_();
        }, () -> {
            double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, correctedSlot);
            this.stack.m_85837_(NumberUtils.round(slotPos[0], 3), NumberUtils.round(slotPos[1], 3), translatePos ? -0.105 : 0.205);
            this.stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            this.stack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)(correctedSlot - textureSlot) + 180.0f));
            Matrix4f projection = RenderSystem.getProjectionMatrix();
            Matrix4f matrix = this.stack.m_85850_().m_252922_();
            finalVertexBuffer.m_253207_(matrix, projection, Objects.requireNonNull(RenderSystem.getShader()));
            VertexBuffer.m_85931_();
        });
        SYMBOLS_MODEL_CACHE.put(glyphId, vertexBuffer);
    }

    protected void renderGlyphGUI(int glyphId, int slot, boolean deactivated, boolean translatePos) {
        int correctedSlot = StargatePegasusChevronsState.getCorrectedSlot(slot);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        EmissiveRenderer.renderWithLightOverlay(this.stack, this.combinedLight, false, () -> {
            String variant = deactivated ? "stargate_off.png" : "stargate.png";
            SymbolPegasusEnum symbol = SymbolTypeRegistry.PEGASUS.valueOf(glyphId);
            if (symbol != null) {
                symbol.bindIconTexture(this.tileEntity.getPointOfOrigin(), variant);
            }
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        }, () -> {
            double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, correctedSlot);
            double radius = 0.94;
            int textureSlot = SymbolTypeRegistry.PEGASUS.valueOf((int)glyphId).textureSlot;
            double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
            float x = (float)((uv[0] + radius) / 2.0);
            float y = (float)((uv[1] + radius) / 2.0);
            float tileSize = 0.27f;
            float uvSize = 0.0625f;
            this.stack.m_85837_(NumberUtils.round(slotPos[0], 3), NumberUtils.round(slotPos[1], 3), translatePos ? -0.105 : 0.205);
            this.stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            this.stack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)(correctedSlot - textureSlot) + 180.0f));
            Matrix4f matrix = this.stack.m_85850_().m_252922_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, -tileSize).m_7421_(x, y).m_5752_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, tileSize).m_7421_(x, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, tileSize).m_7421_(x + uvSize, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, -tileSize).m_7421_(x + uvSize, y).m_5752_();
            tessellator.m_85914_();
        }, GameRenderer::m_172817_);
    }

    @Override
    @Nonnull
    public Pair<Integer, Integer> getEventHorizonColor() {
        return Pair.of((Object)-13740147, (Object)-1);
    }
}

