/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.ITab;
import dev.tauri.jsg.api.client.screen.TabSideEnum;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.client.screen.util.JSGRect2i;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.forgeutil.SlotHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public abstract class Tab
implements ITab {
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected int defaultX;
    protected int defaultY;
    protected int openX;
    protected int hiddenX;
    protected int width;
    protected int height;
    protected String tabTitle;
    protected TabSideEnum side;
    protected ResourceLocation bgTexLocation;
    protected int textureSize;
    protected int bgTexX;
    protected int bgTexY;
    protected int iconX;
    protected int iconY;
    protected int iconWidth;
    protected int iconHeight;
    protected int iconTexX;
    protected int iconTexY;
    private boolean isVisible = true;
    private boolean animate = false;
    private int startingOffsetX = 0;
    private boolean isTabOpen = false;
    private boolean isTabHidden = false;
    private float offsetPerTick;
    private long animationStart;
    private int animationTime;
    protected int currentOffsetX = 0;

    protected Tab(TabBuilder builder) {
        this.guiLeft = builder.guiLeft;
        this.guiTop = builder.guiTop;
        this.xSize = builder.xSize;
        this.ySize = builder.ySize;
        this.defaultX = builder.defaultX;
        this.defaultY = builder.defaultY;
        this.openX = builder.openX;
        this.hiddenX = builder.hiddenX;
        this.width = builder.width;
        this.height = builder.height;
        this.tabTitle = builder.tabTitle;
        this.side = builder.side;
        this.bgTexLocation = builder.bgTexLocation;
        this.textureSize = builder.textureSize;
        this.bgTexX = builder.bgTexX;
        this.bgTexY = builder.bgTexY;
        this.iconX = builder.iconX;
        this.iconY = builder.iconY;
        this.iconWidth = builder.iconWidth;
        this.iconHeight = builder.iconHeight;
        this.iconTexX = builder.iconTexX;
        this.iconTexY = builder.iconTexY;
        this.startingOffsetX = this.defaultX;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isOpen() {
        return this.isTabOpen;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHidden() {
        return this.isTabHidden;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.isVisible) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        this.updateAnimation(mc);
        Font fontRenderer = mc.f_91062_;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ITexture.bindTextureWithMc(this.bgTexLocation);
        GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.currentOffsetX, this.guiTop + this.defaultY, this.bgTexX, this.bgTexY, this.width, this.height, this.textureSize, this.textureSize);
        GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.iconX + this.currentOffsetX, this.guiTop + this.defaultY + this.iconY, this.iconTexX, this.iconTexY, this.iconWidth, this.iconHeight, this.textureSize, this.textureSize);
        graphics.m_280614_(fontRenderer, (Component)Component.m_237113_((String)this.tabTitle), this.guiLeft + this.currentOffsetX + (this.side.left() ? 24 : 0) + 4, this.guiTop + this.defaultY + 10, 0x404040, false);
        RenderSystem.disableBlend();
    }

    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.isVisible) {
            return;
        }
        if (!this.isTabOpen && this.isCursorOnTab(mouseX, mouseY)) {
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237113_((String)this.tabTitle)), Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public boolean isCursorOnTab(int mouseX, int mouseY) {
        int xOffset = 0;
        if (this.isTabHidden && this.hiddenX < this.defaultX) {
            xOffset = 15;
        }
        return this.isVisible && GuiHelper.isPointInRegion(this.guiLeft + this.iconX + this.currentOffsetX + xOffset, this.guiTop + this.defaultY + this.iconY, this.iconWidth - (this.isTabHidden ? 15 : 0), this.iconHeight, mouseX, mouseY);
    }

    public boolean isCursorOnTabBody(int mouseX, int mouseY) {
        int xOffset = 0;
        if (this.isTabHidden && this.hiddenX < this.defaultX) {
            xOffset = 15;
        }
        return this.isVisible && GuiHelper.isPointInRegion(this.guiLeft + this.currentOffsetX + xOffset, this.guiTop + this.defaultY, this.width, this.height, mouseX, mouseY);
    }

    public void openTab() {
        this.animateTo(this.openX, 10);
        this.isTabHidden = false;
        this.isTabOpen = true;
    }

    public void closeTab() {
        this.animateTo(this.defaultX, this.isTabOpen ? 10 : 5);
        this.isTabHidden = false;
        this.isTabOpen = false;
    }

    public void hideTab() {
        this.animateTo(this.hiddenX, this.isTabOpen ? 10 : 5);
        this.isTabHidden = true;
        this.isTabOpen = false;
    }

    public void animateTo(int targetOffsetX, int animationTime) {
        this.animationTime = animationTime;
        this.startingOffsetX = this.currentOffsetX;
        this.offsetPerTick = (float)(targetOffsetX - this.startingOffsetX) / (float)animationTime;
        this.animationStart = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_();
        this.animate = true;
    }

    public void updateAnimation(Minecraft mc) {
        this.currentOffsetX = this.startingOffsetX;
        if (this.animate) {
            float effTick = (float)(Objects.requireNonNull(mc.f_91073_).m_46467_() - this.animationStart) + mc.getPartialTick();
            if (effTick < (float)this.animationTime) {
                this.currentOffsetX += Math.round(this.offsetPerTick * effTick);
            } else {
                this.animate = false;
                this.currentOffsetX += (int)(this.offsetPerTick * (float)this.animationTime);
                this.startingOffsetX = this.currentOffsetX;
            }
        }
    }

    public JSGRect2i getArea() {
        int tabHeight;
        int n = tabHeight = this.isTabOpen | this.animate ? this.height : 34;
        if (this.side.left()) {
            return new JSGRect2i(this.guiLeft + this.currentOffsetX, this.guiTop + this.defaultY, Math.abs(this.currentOffsetX), tabHeight);
        }
        return new JSGRect2i(this.guiLeft + this.xSize, this.guiTop + this.defaultY, Math.abs(this.width + this.currentOffsetX - this.xSize), tabHeight);
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return false;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void updateScreen() {
    }

    public static boolean tabsInteract(List<Tab> tabs, int tabIndex) {
        Tab tab = tabs.get(tabIndex);
        for (Tab tab2 : tabs.subList(0, tabIndex)) {
            if (tab.side != tab2.side) continue;
            tab2.closeTab();
        }
        for (Tab tab2 : tabs.subList(tabIndex + 1, tabs.size())) {
            if (tab.side != tab2.side) continue;
            if (tab.isOpen()) {
                tab2.closeTab();
                continue;
            }
            tab2.hideTab();
        }
        if (tab.isOpen()) {
            tab.closeTab();
            return false;
        }
        tab.openTab();
        return true;
    }

    public static void updatePositions(List<Tab> tabs) {
        int yPosLeft = 11;
        int yPosRight = 2;
        for (Tab tab : tabs) {
            if (!tab.isVisible()) continue;
            if (tab.side.left()) {
                tab.defaultY = yPosLeft;
                yPosLeft += 22;
                continue;
            }
            tab.defaultY = yPosRight;
            yPosRight += 22;
        }
    }

    public static abstract class TabBuilder
    implements ITab.ITabBuilder {
        private int guiLeft;
        private int guiTop;
        private int xSize;
        private int ySize;
        private int defaultX;
        private int defaultY;
        private int openX;
        private int hiddenX;
        private int width;
        private int height;
        private String tabTitle;
        private TabSideEnum side;
        private ResourceLocation bgTexLocation;
        private int textureSize;
        private int bgTexX;
        private int bgTexY;
        private int iconX;
        private int iconY;
        private int iconWidth;
        private int iconHeight;
        private int iconTexX;
        private int iconTexY;

        @Override
        public TabBuilder setGuiSize(int xSize, int ySize) {
            this.xSize = xSize;
            this.ySize = ySize;
            return this;
        }

        @Override
        public TabBuilder setGuiPosition(int guiLeft, int guiTop) {
            this.guiLeft = guiLeft;
            this.guiTop = guiTop;
            return this;
        }

        @Override
        public TabBuilder setTabPosition(int defaultX, int defaultY) {
            this.defaultX = defaultX;
            this.defaultY = defaultY;
            return this;
        }

        @Override
        public TabBuilder setOpenX(int openX) {
            this.openX = openX;
            return this;
        }

        @Override
        public TabBuilder setHiddenX(int hiddenX) {
            this.hiddenX = hiddenX;
            return this;
        }

        @Override
        public TabBuilder setTabSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public TabBuilder setTabTitle(String tabTitle) {
            this.tabTitle = tabTitle;
            return this;
        }

        @Override
        public TabBuilder setTabSide(TabSideEnum side) {
            this.side = side;
            return this;
        }

        @Override
        public TabBuilder setTexture(ResourceLocation bgTexLocation, int texureSize) {
            this.bgTexLocation = bgTexLocation;
            this.textureSize = texureSize;
            return this;
        }

        @Override
        public TabBuilder setBackgroundTextureLocation(int bgTexX, int bgTexY) {
            this.bgTexX = bgTexX;
            this.bgTexY = bgTexY;
            return this;
        }

        @Override
        public TabBuilder setIconRenderPos(int iconX, int iconY) {
            this.iconX = iconX;
            this.iconY = iconY;
            return this;
        }

        @Override
        public TabBuilder setIconSize(int iconWidth, int iconHeight) {
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
            return this;
        }

        @Override
        public TabBuilder setIconTextureLocation(int iconTexX, int iconTexY) {
            this.iconTexX = iconTexX;
            this.iconTexY = iconTexY;
            return this;
        }

        @Override
        public abstract Tab build();
    }

    public static interface UpdateSlotPositionInterface {
        public SlotTab updatePos(SlotTab var1);
    }

    public class SlotTab
    extends SlotHandler {
        public final Slot slot;
        private final UpdateSlotPositionInterface updateSlotPosition;

        public SlotTab(SlotHandler slot, UpdateSlotPositionInterface updateSlotPosition) {
            this(slot, updateSlotPosition, slot.f_40220_, slot.f_40221_);
        }

        public SlotTab(SlotHandler slot, UpdateSlotPositionInterface updateSlotPosition, int x, int y) {
            super(slot.getItemHandler(), slot.getSlotIndex(), x, y);
            this.slot = slot;
            this.slot.f_40219_ = slot.getSlotIndex();
            this.updateSlotPosition = updateSlotPosition;
        }

        public void setSlotIndex(int id) {
            this.slot.f_40219_ = id;
        }

        public boolean m_6659_() {
            return Tab.this.isTabOpen && !Tab.this.animate && Tab.this.isVisible();
        }

        public SlotTab updatePos() {
            return this.updateSlotPosition.updatePos(this);
        }

        public SlotTab setXY(int x, int y) {
            return new SlotTab(this, this.updateSlotPosition, x, y);
        }
    }
}

