/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.BEConfigOptionWidget;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabScrollAble;
import java.util.LinkedList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;

public class TabConfig
extends TabScrollAble {
    public final LinkedList<BEConfigOptionWidget<?>> optionsWidgets = new LinkedList();
    public BEConfig config;
    private Runnable onTabClose = null;

    protected TabConfig(TabConfigBuilder builder) {
        super(builder);
        this.config = builder.config;
        this.updateConfig(builder.config, true);
    }

    public static TabConfigBuilder builder() {
        return new TabConfigBuilder();
    }

    @Override
    public double scrollRate() {
        return 4.5;
    }

    @Override
    protected void renderContents(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        this.updateConfig(null, false);
        this.optionsWidgets.forEach(optionWidget -> optionWidget.m_88315_(pGuiGraphics, pMouseX, pMouseY, 0.0f));
    }

    @Override
    protected void renderContentsFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (!this.isVisible() || !this.isOpen()) {
            return;
        }
        this.optionsWidgets.forEach(optionWidget -> optionWidget.renderFg(pGuiGraphics, pMouseX, pMouseY));
    }

    @Override
    public int getInnerHeight() {
        return this.optionsWidgets.stream().mapToInt(AbstractWidget::m_93694_).sum();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.optionsWidgets.forEach(widget -> widget.m_6375_(mouseX, mouseY, mouseButton));
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        if (super.keyTyped(typedChar, keyCode)) {
            return true;
        }
        return this.optionsWidgets.stream().anyMatch(widget -> widget.m_7933_(typedChar, keyCode, 0));
    }

    @Override
    public boolean charTyped(char character, int intChar) {
        if (super.charTyped(character, intChar)) {
            return true;
        }
        return this.optionsWidgets.stream().anyMatch(widget -> widget.m_5534_(character, intChar));
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        return this.optionsWidgets.stream().anyMatch(widget -> {
            if (!widget.m_93680_(pMouseX, pMouseY)) {
                return false;
            }
            return widget.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        });
    }

    @Override
    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (super.mouseReleased(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return this.optionsWidgets.stream().anyMatch(widget -> {
            if (!widget.m_93680_(pMouseX, pMouseY)) {
                return false;
            }
            return widget.m_6348_(pMouseX, pMouseY, pButton);
        });
    }

    public void setOnTabClose(Runnable onTabClose) {
        this.onTabClose = onTabClose;
    }

    @Override
    public void closeTab() {
        if (this.onTabClose != null) {
            this.onTabClose.run();
        }
        super.closeTab();
    }

    public BEConfig getConfig() {
        return this.config;
    }

    public void updateConfig(BEConfig config, boolean resetFields) {
        if (config != null) {
            this.config = config;
        }
        if (resetFields) {
            this.optionsWidgets.clear();
            if (config != null) {
                config.getOptions().forEach((id, option) -> {
                    BEConfigOptionWidget widget = option.createGUIWidget(config, this.getWidth() - this.innerPadding(), (String)id);
                    if (widget == null) {
                        return;
                    }
                    this.optionsWidgets.add(widget);
                });
            }
        }
        int y = 0;
        for (BEConfigOptionWidget bEConfigOptionWidget : this.optionsWidgets) {
            bEConfigOptionWidget.m_253211_((int)((double)(y + this.getY()) - this.scrollAmount()));
            bEConfigOptionWidget.m_252865_(this.getX());
            y += bEConfigOptionWidget.m_93694_();
        }
    }

    public static class TabConfigBuilder
    extends Tab.TabBuilder {
        private BEConfig config;

        public TabConfigBuilder setConfig(BEConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public TabConfig build() {
            return new TabConfig(this);
        }
    }
}

