/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.mainmenu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.client.screen.EnumMainMenuGateType;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginsLoader;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolMilkyWayEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolPegasusEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolUniverseEnum;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.api.util.math.NumberUtils;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import dev.tauri.jsg.renderer.stargate.ChevronTextureList;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRenderer;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL14C;

public class MainMenuGateRenderer {
    public static double coefficient = 1.0;
    public static float translationZ = 0.0f;
    public static float disassemblyCoef = 0.0f;

    public static ResourceLocation getIconsTexture(EnumMainMenuGateType gateType) {
        return switch (gateType) {
            case EnumMainMenuGateType.PEGASUS -> new ResourceLocation("jsg", "textures/gui/mainmenu/icons_pg.png");
            case EnumMainMenuGateType.UNIVERSE -> new ResourceLocation("jsg", "textures/gui/mainmenu/icons_uni.png");
            default -> new ResourceLocation("jsg", "textures/gui/mainmenu/icons_mw.png");
        };
    }

    public static void renderGate(EnumMainMenuGateType gateType, int x, int y, float size, double tick) {
        MainMenuGateRenderer.renderGate(gateType, x, y, 0.0f, size, 7, true, tick);
    }

    public static void renderGate(EnumMainMenuGateType gateType, int x, int y, float zFactor, float size, int chevronsActive, boolean finalActive, double tick) {
        coefficient = 0.75;
        GuiCustomMainMenu.poseStack.m_85836_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        translationZ = (ForgeHooksClient.getGuiFarPlane() - 1200.0f) / size;
        GuiCustomMainMenu.poseStack.m_252880_((float)x, (float)y, 0.0f);
        GuiCustomMainMenu.poseStack.m_85841_(size, -size, size);
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, -translationZ);
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, translationZ * zFactor);
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252436_.m_252977_(Math.min(1.0f, disassemblyCoef * 2.0f) * 90.0f));
        AbstractOBJModel.setGUIRender();
        switch (gateType) {
            case MILKYWAY: {
                MainMenuGateRenderer.renderMWGate(tick, chevronsActive, finalActive);
                break;
            }
            case PEGASUS: {
                MainMenuGateRenderer.renderPEGGate(tick);
                break;
            }
            case UNIVERSE: {
                MainMenuGateRenderer.renderUNIGate(tick);
                break;
            }
        }
        AbstractOBJModel.resetRenderType();
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85849_();
        disassemblyCoef = 0.0f;
    }

    public static void renderDHD(EnumMainMenuGateType gateType, int x, int y, float zFactor, float size, double tick) {
        coefficient = 0.75;
        GuiCustomMainMenu.poseStack.m_85836_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        translationZ = (ForgeHooksClient.getGuiFarPlane() - 1200.0f) / size;
        GuiCustomMainMenu.poseStack.m_252880_((float)x, (float)y, 0.0f);
        GuiCustomMainMenu.poseStack.m_85841_(size, -size, size);
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, -translationZ);
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, translationZ * zFactor);
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - Math.min(1.0f, disassemblyCoef * 2.0f) * 90.0f));
        AbstractOBJModel.setGUIRender();
        switch (gateType) {
            case MILKYWAY: {
                MainMenuGateRenderer.renderMWDHD(tick);
                break;
            }
        }
        AbstractOBJModel.resetRenderType();
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85849_();
        disassemblyCoef = 0.0f;
    }

    private static void renderMWGate(double tick, int chevronsActive, boolean finalActive) {
        float disCoef = Math.max(0.0f, disassemblyCoef - 0.5f) * 2.5f;
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_85837_(StargateMilkyWayRenderer.RING_LOC.f_82479_, StargateMilkyWayRenderer.RING_LOC.f_82481_, StargateMilkyWayRenderer.RING_LOC.f_82480_);
        GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(-(tick * ((double)1.8f * coefficient / 2.0)) % 360.0)));
        GuiCustomMainMenu.poseStack.m_85837_(-StargateMilkyWayRenderer.RING_LOC.f_82479_, -StargateMilkyWayRenderer.RING_LOC.f_82481_, -StargateMilkyWayRenderer.RING_LOC.f_82480_);
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, disCoef);
        ElementEnum.MILKYWAY_RING.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        SymbolTypeRegistry.MILKYWAY.getOrigin().getModel(StargateTypes.MILKYWAY, IPointOfOriginsLoader.Defaults.get(StargateTypes.MILKYWAY, IPointOfOriginsLoader.Defaults.MilkyWay.TAURI), "stargate.obj").render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ChevronTextureList chevrons = new ChevronTextureList(LoadersHolder.JSG_HOLDER.texture(), "milkyway/chevron", chevronsActive, finalActive);
        chevrons.initClient();
        for (ChevronEnum chevron : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                float chevronCoef = 1.0f;
                GuiCustomMainMenu.poseStack.m_85836_();
                GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
                GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, disCoef * 2.0f * chevronCoef);
                if (light) {
                    float color = chevrons.getColor(chevron);
                    RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                LoadersHolder.JSG_HOLDER.texture().getTexture(chevrons.get(BiomeOverlayRegistry.NORMAL, chevron, light)).bindTexture();
                ElementEnum.MILKYWAY_CHEVRON_MOVING.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, disCoef * chevronCoef);
                ElementEnum.MILKYWAY_CHEVRON_LIGHT.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, -disCoef * 4.0f * chevronCoef);
                if (!light) {
                    ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                    ElementEnum.MILKYWAY_CHEVRON_BACK.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                }
                GuiCustomMainMenu.poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.MILKYWAY_GATE.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private static void renderMWDHD(double tick) {
        float disCoef = Math.max(0.0f, disassemblyCoef - 0.5f) * 1.5f;
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.MILKYWAY_DHD_BASE.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, disCoef * 4.0f, 0.0f);
        ElementEnum.MILKYWAY_DHD_BUTTON_CONSOLE.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, disCoef, 0.0f);
        ElementEnum.MILKYWAY_DHD_CRYSTAL_HOLDER.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        ElementEnum.MILKYWAY_DHD_UPGRADE_COVER.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, disCoef * 2.0f, 0.0f);
        ElementEnum.MILKYWAY_DHD_CRYSTALS.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, disCoef * 3.0f, 0.0f);
        ElementEnum.MILKYWAY_DHD_CONTROL_CRYSTAL.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        PointOfOrigin origin = IPointOfOriginsLoader.Defaults.get(StargateTypes.MILKYWAY, IPointOfOriginsLoader.Defaults.MilkyWay.TAURI);
        for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
            GuiCustomMainMenu.poseStack.m_85836_();
            GuiCustomMainMenu.poseStack.m_252880_(0.0f, disCoef * 5.0f, 0.0f);
            if (symbol.origin()) {
                ResourceLocation plate = LoadersHolder.JSG_HOLDER.model().getModelResource("milkyway/dhd/buttons/4_base.obj");
                ResourceLocation plateLight = LoadersHolder.JSG_HOLDER.model().getModelResource("milkyway/dhd/buttons/4.obj");
                ElementEnum.MILKYWAY_DHD_BASE.bindTexture(BiomeOverlayRegistry.NORMAL);
                LoadersHolder.JSG_HOLDER.model().getModel(plate).render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                LoadersHolder.JSG_HOLDER.texture().getTexture(MainMenuGateRenderer.getMWDHDButtonTexture(symbol)).bindTexture();
                LoadersHolder.JSG_HOLDER.model().getModel(plateLight).render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
            }
            LoadersHolder.JSG_HOLDER.texture().getTexture(MainMenuGateRenderer.getMWDHDButtonTexture(symbol)).bindTexture();
            symbol.getModel(StargateTypes.MILKYWAY, origin, "dhd_light.obj").render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
            if (symbol.brb()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            ElementEnum.MILKYWAY_DHD_BASE.bindTexture(BiomeOverlayRegistry.NORMAL);
            symbol.getModel(StargateTypes.MILKYWAY, origin, "dhd.obj").render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
            GuiCustomMainMenu.poseStack.m_85849_();
        }
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private static ResourceLocation getMWDHDButtonTexture(SymbolMilkyWayEnum symbol) {
        if (symbol.brb()) {
            return new ResourceLocation("jsg", "textures/tesr/milkyway/dhd/dhd_brb_0.jpg");
        }
        return new ResourceLocation("jsg", "textures/tesr/milkyway/dhd/dhd_button_light_0.jpg");
    }

    private static void renderUNIGate(double tick) {
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_85841_(1.14f, 1.14f, 1.14f);
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(-(tick * ((double)1.8f * coefficient / 2.0)) % 360.0)));
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.UNIVERSE_GATE.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ChevronTextureList chevrons = new ChevronTextureList(LoadersHolder.JSG_HOLDER.texture(), "universe/universe_chevron", 9, true);
        chevrons.initClient();
        for (ChevronEnum chevronEnum : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GuiCustomMainMenu.poseStack.m_85836_();
                GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)chevronEnum.rotation));
                if (light) {
                    float color = chevrons.getColor(chevronEnum);
                    RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                LoadersHolder.JSG_HOLDER.texture().getTexture(chevrons.get(BiomeOverlayRegistry.NORMAL, chevronEnum, light)).bindTexture();
                ElementEnum.UNIVERSE_CHEVRON.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                GuiCustomMainMenu.poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        ElementEnum.UNIVERSE_SYMBOL.bindTexture(BiomeOverlayRegistry.NORMAL);
        for (Enum enum_ : SymbolUniverseEnum.values()) {
            if (enum_ == SymbolUniverseEnum.TOP_CHEVRON) continue;
            float color = 0.25f;
            switch (1.$SwitchMap$dev$tauri$jsg$api$stargate$network$address$symbol$types$SymbolUniverseEnum[enum_.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    color += 0.6f;
                    break;
                }
            }
            GuiCustomMainMenu.poseStack.m_85836_();
            enum_.getModel(((SymbolUniverseEnum)enum_).getSymbolType().getPointOfOriginType(), null, "stargate.obj").render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0, false, color);
            GuiCustomMainMenu.poseStack.m_85849_();
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private static void renderPEGGate(double tick) {
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.PEGASUS_RING.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.PEGASUS_GATE.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
        GuiCustomMainMenu.poseStack.m_85849_();
        int glyphsCount = (int)(tick * coefficient / 2.0 % 111.0);
        if (glyphsCount > 36) {
            glyphsCount = 36;
        }
        int chevronsCount = glyphsCount / 4;
        GuiCustomMainMenu.poseStack.m_85836_();
        for (int i = -8; i < glyphsCount - 8; ++i) {
            int ii = i % 36;
            if (ii < 0) {
                ii = 36 + ii;
            }
            ii = 36 - ii;
            MainMenuGateRenderer.renderPegasusGlyph(ii, ii);
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        if (chevronsCount == 4) {
            chevronsCount = 3;
        }
        if (chevronsCount == 5) {
            chevronsCount = 3;
        }
        if (chevronsCount > 5) {
            chevronsCount -= 2;
        }
        GuiCustomMainMenu.poseStack.m_85836_();
        ChevronTextureList chevrons = new ChevronTextureList(LoadersHolder.JSG_HOLDER.texture(), "pegasus/chevron", chevronsCount, chevronsCount == 7);
        chevrons.initClient();
        for (ChevronEnum chevron : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GuiCustomMainMenu.poseStack.m_85836_();
                GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
                if (light) {
                    float color = chevrons.getColor(chevron);
                    GL14C.glBlendColor((float)color, (float)color, (float)color, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                LoadersHolder.JSG_HOLDER.texture().getTexture(chevrons.get(BiomeOverlayRegistry.NORMAL, chevron, light)).bindTexture();
                ElementEnum.PEGASUS_CHEVRON_MOVING.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                if (!light) {
                    ElementEnum.PEGASUS_CHEVRON_FRAME.bindTexture().render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                    ElementEnum.PEGASUS_CHEVRON_BACK.render(GuiCustomMainMenu.poseStack, (MultiBufferSource)GuiCustomMainMenu.graphics.m_280091_(), 0);
                }
                GuiCustomMainMenu.poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private static double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    private static void renderPegasusGlyph(int glyphId, int slot) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        EmissiveRenderer.renderWithLightOverlay(GuiCustomMainMenu.poseStack, 0, false, () -> {
            SymbolPegasusEnum symbol = SymbolTypeRegistry.PEGASUS.valueOf(glyphId);
            if (symbol != null) {
                symbol.bindIconTexture(null, "stargate.png");
            }
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        }, () -> {
            double[] slotPos = MainMenuGateRenderer.getPositionInRingAtIndex(4.2407502174377445, slot);
            GuiCustomMainMenu.poseStack.m_85837_(NumberUtils.round(slotPos[0], 3), NumberUtils.round(slotPos[1], 3), (double)translationZ + 0.17);
            GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            double radius = 0.94;
            int textureSlot = SymbolTypeRegistry.PEGASUS.valueOf((int)glyphId).textureSlot;
            double[] uv = MainMenuGateRenderer.getPositionInRingAtIndex(radius, -textureSlot);
            float x = (float)((uv[0] + radius) / 2.0);
            float y = (float)((uv[1] + radius) / 2.0);
            float tileSize = 0.27f;
            float uvSize = 0.0625f;
            GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)(slot - textureSlot) + 180.0f));
            Matrix4f matrix = GuiCustomMainMenu.poseStack.m_85850_().m_252922_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, -tileSize).m_7421_(x, y).m_5752_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, tileSize).m_7421_(x, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, tileSize).m_7421_(x + uvSize, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, -tileSize).m_7421_(x + uvSize, y).m_5752_();
            tessellator.m_85914_();
        }, GameRenderer::m_172817_);
    }
}

