/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.mainmenu;

import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.config.data.ProgressJSON;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.ProgressUpdateToClient;
import dev.tauri.jsg.sound.PositionedSound;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public abstract class MainMenuTheme {
    public static final Map<ResourceLocation, MainMenuTheme> THEMES = new HashMap<ResourceLocation, MainMenuTheme>();
    public static final MainMenuTheme ACT_1 = MainMenuTheme.registerAct("jsg", 0, StargateTypes.MILKYWAY, 1, 9, PositionedSound.MAINMENU_ACT1);
    public static final MainMenuTheme ACT_2 = MainMenuTheme.registerAct("jsg", 1, StargateTypes.MILKYWAY, 2, 10, PositionedSound.MAINMENU_ACT2);
    public static final MainMenuTheme ACT_3 = MainMenuTheme.registerAct("jsg", 2, StargateTypes.PEGASUS, 3, 7, PositionedSound.MAINMENU_ACT3);
    public static final MainMenuTheme ACT_6 = MainMenuTheme.registerAct("jsg", 5, StargateTypes.UNIVERSE, 6, 4, PositionedSound.MAINMENU_ACT6);
    public final ResourceLocation id;
    public final int priority;
    @Nullable
    public final StargateType gateType;

    public static MainMenuTheme registerAct(String modId, int priority, @Nullable StargateType gateType, int id, int backCount, PositionedSound sound) {
        return MainMenuTheme.registerAct(modId, priority, gateType, id, backCount, sound, () -> ProgressJSON.get().currentActId.equalsIgnoreCase(modId + ":act" + id));
    }

    public static MainMenuTheme registerAct(String modId, int priority, @Nullable StargateType gateType, int id, int backCount, final PositionedSound sound, final Supplier<Boolean> predicate) {
        final ArrayList<ResourceLocation> backs = new ArrayList<ResourceLocation>();
        for (int i = 0; i < backCount; ++i) {
            backs.add(new ResourceLocation(modId, "textures/gui/mainmenu/act" + id + "/" + i + ".jpg"));
        }
        return new MainMenuTheme(new ResourceLocation(modId, "act" + id), priority, gateType){

            @Override
            public boolean canBeChosen() {
                return (Boolean)predicate.get();
            }

            @Override
            public List<ResourceLocation> getBackgrounds() {
                return backs;
            }

            @Override
            public PositionedSound getSoundTheme() {
                return sound;
            }
        };
    }

    @ParametersAreNonnullByDefault
    public static void sendUpdateActToClient(ServerPlayer player, MainMenuTheme act) {
        JSGPacketHandler.sendTo(new ProgressUpdateToClient(act.id), player);
    }

    public MainMenuTheme(ResourceLocation id, int priority, @Nullable StargateType gateType) {
        this.id = id;
        this.priority = priority;
        this.gateType = gateType;
        THEMES.put(id, this);
    }

    public int getPriority() {
        return this.priority;
    }

    public abstract boolean canBeChosen();

    public abstract List<ResourceLocation> getBackgrounds();

    public abstract PositionedSound getSoundTheme();

    public ResourceLocation getBackground(int id) {
        return this.getBackgrounds().get(id);
    }

    public static void load() {
    }
}

