/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.sggenerator;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.EnumMainMenuGateType;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.util.JSGColorUtil;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import dev.tauri.jsg.screen.gui.mainmenu.MainMenuGateRenderer;
import dev.tauri.jsg.worldgen.generator.StargateGeneratorStepStatus;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractStargateGeneratorScreen
extends GenericDirtMessageScreen {
    final Supplier<String> step;
    final Supplier<Integer> total;
    final Supplier<Component> message;
    final Supplier<ConcurrentHashMap<String, StargateGeneratorStepStatus>> stats;
    final double initTick;
    protected static final double ASSEMBLY_DURATION = 400.0;

    public AbstractStargateGeneratorScreen(Component title, Supplier<String> step, Supplier<Integer> total, Supplier<ConcurrentHashMap<String, StargateGeneratorStepStatus>> stats, Supplier<Component> message) {
        super(title);
        this.step = step;
        this.total = total;
        this.stats = stats;
        this.message = message;
        this.initTick = (double)System.currentTimeMillis() / 1000.0 * 20.0;
    }

    public float getProgress() {
        float t = this.total.get().intValue();
        if (t == 0.0f) {
            t = 1.0f;
        }
        ConcurrentHashMap<String, StargateGeneratorStepStatus> stats = this.stats.get();
        return (float)stats.size() / t;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        double ticks = (double)System.currentTimeMillis() / 1000.0 * 20.0 - this.initTick;
        this.m_280039_(graphics);
        graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        int y = this.f_96544_ - 20 - 8;
        int x = 8;
        MutableComponent s = Component.m_237110_((String)this.step.get(), (Object[])new Object[]{Integer.toString((int)(this.getProgress() * 100.0f))});
        graphics.m_280430_(this.f_96547_, (Component)s, x, y, -1);
        graphics.m_280653_(this.f_96547_, this.message.get(), this.f_96543_ / 2, y - 10, -1);
        int progressSize = this.f_96543_ - 16;
        this.renderProgress(graphics, x, y += 10, progressSize, mouseX, mouseY, ticks);
        graphics.m_280168_().m_85836_();
        RenderSystem.enableDepthTest();
        this.renderGateAssembly(graphics, mouseX, mouseY, ticks);
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85849_();
    }

    protected void renderProgress(@NotNull GuiGraphics graphics, int x, int y, int progressSize, int mouseX, int mouseY, double ticks) {
        graphics.m_280637_(x, y, progressSize, 10, -1);
        double loaderCoef = ticks % 100.0 / 100.0;
        double loaderX = Math.max(0.0, -10.0 + loaderCoef * (double)progressSize);
        double loaderXRight = Math.min((double)(progressSize - 4), loaderCoef * (double)progressSize);
        graphics.m_280509_((int)((double)(x + 2) + loaderX), y + 2, (int)((double)(x + 2) + loaderXRight), y + 8, -1);
        double t = this.total.get().intValue();
        ConcurrentHashMap<String, StargateGeneratorStepStatus> stats = this.stats.get();
        double perDim = (double)(progressSize - 4) / t;
        AtomicInteger i = new AtomicInteger(0);
        stats.forEach((stepName, stepStatus) -> {
            double xOffset = perDim * (double)i.get();
            int pX = (int)((double)(x + 2) + xOffset);
            int pXMax = (int)((double)(x + 2) + xOffset + perDim);
            if ((double)i.get() == t - 1.0) {
                pXMax = x + (progressSize - 2);
            }
            int pY = y + 2;
            int pYMax = y + 8;
            int color = stepStatus.getColor();
            boolean hover = false;
            if (GuiHelper.isPointInRegion(pX, pY, pXMax - pX, pYMax - pY, mouseX, mouseY)) {
                color = JSGColorUtil.blendColors(color, -1, 0.5f);
                hover = true;
            }
            graphics.m_280509_(pX, pY, pXMax, pYMax, color);
            if (hover) {
                graphics.m_280677_(this.f_96547_, List.of(Component.m_237113_((String)stepName), stepStatus.getMessage()), Optional.empty(), mouseX, mouseY);
            }
            i.incrementAndGet();
        });
    }

    protected void renderGateAssembly(@NotNull GuiGraphics graphics, int mouseX, int mouseY, double ticks) {
        int color;
        int x = this.f_96543_ / 4;
        int y = this.f_96544_ / 2;
        graphics.m_280168_().m_85836_();
        float scaleX = (float)this.f_96543_ / 640.0f;
        float scaleY = (float)this.f_96544_ / 337.0f;
        float scale = Math.min(scaleX, scaleY);
        double gateDisCof = ticks % 400.0 / 400.0;
        float coef = (float)(-Math.pow(Math.cos(Math.max(0.0, gateDisCof * 1.25 - 0.25) * Math.PI), 6.0)) + 1.0f;
        double t = this.total.get().intValue();
        ConcurrentHashMap<String, StargateGeneratorStepStatus> stats = this.stats.get();
        double percentDone = (double)stats.size() / t;
        GuiCustomMainMenu.poseStack = graphics.m_280168_();
        GuiCustomMainMenu.graphics = graphics;
        MainMenuGateRenderer.disassemblyCoef = coef;
        MainMenuGateRenderer.renderGate(EnumMainMenuGateType.MILKYWAY, x, y, 1.0f, 25.0f * scale, (int)Math.floor(percentDone * 9.0), percentDone >= 0.99 || (int)Math.floor(percentDone * 9.0) >= 9, ticks);
        graphics.m_280168_().m_85836_();
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"createWorld.stargate_disassemble.milkyway.title"), x, (int)((float)y - 150.0f * scale), 0xFFFFFF);
        if (coef >= 0.99f) {
            color = -1;
            MutableComponent s = Component.m_237115_((String)"createWorld.stargate_disassemble.milkyway.chevron_frame");
            this.drawPartTooltip(graphics, (int)((float)x - 55.0f * scale - (float)this.f_96547_.m_92852_((FormattedText)s)), (int)((float)y + 25.0f * scale), (int)((float)x - 45.0f * scale), (int)((float)y - 20.0f * scale), (Component)s, color);
            this.drawPartTooltip(graphics, (int)((float)x + 130.0f * scale), (int)((float)y - 45.0f * scale), (int)((float)x + 105.0f * scale), (int)((float)y - 22.0f * scale), (Component)Component.m_237115_((String)"createWorld.stargate_disassemble.milkyway.chevron_light"), color);
            this.drawPartTooltip(graphics, (int)((float)x + 75.0f * scale), y, (int)((float)x + 38.0f * scale), (int)((float)y + 25.0f * scale), (Component)Component.m_237115_((String)"createWorld.stargate_disassemble.milkyway.glyph_ring"), color);
            this.drawPartTooltip(graphics, (int)((float)x + 130.0f * scale), (int)((float)y - 65.0f * scale), (int)((float)x + 75.0f * scale), (int)((float)y - 100.0f * scale), (Component)Component.m_237115_((String)"createWorld.stargate_disassemble.milkyway.chevron_lock"), color);
            s = Component.m_237115_((String)"createWorld.stargate_disassemble.milkyway.gate_frame");
            this.drawPartTooltip(graphics, (int)((float)x - 55.0f * scale) - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - 100.0f * scale), (int)((float)x - 15.0f * scale), (int)((float)y - 65.0f * scale), (Component)s, color);
        }
        graphics.m_280168_().m_85849_();
        y = this.f_96544_ - 45;
        x = this.f_96543_ - 75;
        MainMenuGateRenderer.disassemblyCoef = coef;
        MainMenuGateRenderer.renderDHD(EnumMainMenuGateType.MILKYWAY, x, y, 1.0f, 50.0f * scale, ticks);
        graphics.m_280168_().m_85836_();
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.title"), x, y + 15, 0xFFFFFF);
        if (coef >= 0.99f) {
            color = -1;
            int partY = 10;
            MutableComponent s = Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.dhd_table");
            this.drawPartTooltip(graphics, x - 50 - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - (float)partY * scale - 15.0f), x - 25, (int)((float)y - (float)partY * scale), (Component)s, color);
            s = Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.crystals_holder");
            this.drawPartTooltip(graphics, x - 50 - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - (float)(partY += 60) * scale - 15.0f), x - 25, (int)((float)y - (float)partY * scale), (Component)s, color);
            s = Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.crystals");
            this.drawPartTooltip(graphics, x - 50 - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - (float)(partY += 45) * scale - 15.0f), x - 25, (int)((float)y - (float)partY * scale), (Component)s, color);
            s = Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.control_crystal");
            this.drawPartTooltip(graphics, x - 50 - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - (float)(partY += 40) * scale - 15.0f), x - 5, (int)((float)y - (float)partY * scale), (Component)s, color);
            s = Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.buttons_plate");
            this.drawPartTooltip(graphics, x - 50 - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - (float)(partY += 40) * scale - 15.0f), x - 25, (int)((float)y - (float)partY * scale), (Component)s, color);
            s = Component.m_237115_((String)"createWorld.dhd_disassemble.milkyway.buttons");
            this.drawPartTooltip(graphics, x - 50 - this.f_96547_.m_92852_((FormattedText)s), (int)((float)y - (float)(partY += 40) * scale - 15.0f), x - 25, (int)((float)y - (float)partY * scale), (Component)s, color);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85849_();
    }

    protected void drawPartTooltip(@NotNull GuiGraphics graphics, int stringX, int stringY, int partX, int partY, Component text, int color) {
        int underlinedY;
        int n = underlinedY = partY < stringY ? -3 : 10;
        if (partY > stringY && partY - stringY < 11) {
            partY = stringY + 11;
        }
        int w = this.f_96547_.m_92852_((FormattedText)text);
        graphics.m_280430_(this.f_96547_, text, stringX, stringY, color);
        graphics.m_280509_(stringX, stringY + underlinedY, stringX + w, stringY + underlinedY + 1, color);
        if (partY > stringY) {
            graphics.m_280509_(stringX + w / 2, stringY + underlinedY, stringX + w / 2 + 1, partY, color);
        } else {
            graphics.m_280509_(stringX + w / 2, partY, stringX + w / 2 + 1, stringY + underlinedY, color);
        }
        if (partX > stringX + w / 2) {
            graphics.m_280509_(stringX + w / 2, partY - 1, partX, partY, color);
        } else {
            graphics.m_280509_(partX, partY - 1, stringX + w / 2, partY, color);
        }
        graphics.m_280509_(partX, partY - 3, partX + 1, partY + 2, color);
    }
}

