/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.stargate;

import dev.tauri.jsg.api.client.screen.util.ContainerHelper;
import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.stargate.StargateUpgrade;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.IUpgradeItem;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.item.energy.CapacitorItemBlock;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.registry.MenuTypeRegistry;
import dev.tauri.jsg.screen.inventory.JSGContainer;
import dev.tauri.jsg.screen.inventory.OpenTabHolderInterface;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.util.CreativeItemsChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class StargateContainer
extends JSGContainer
implements OpenTabHolderInterface {
    public StargateClassicBaseBE<?> gateTile;
    public boolean hasCreative;
    private final BlockPos pos;
    private int lastEnergyStored;
    private int energyTransferredLastTick;
    private double lastEnergySecondsToClose;
    private int lastProgress;
    protected final List<Integer> openedTabsSlotsIds = new ArrayList<Integer>();
    private EnumIrisMode irisMode;
    private String irisCode = "";
    public long openedSince;
    private double gateTemp;
    private double irisTemp;
    public final Inventory playerInventory;

    public StargateContainer(int containerID, Inventory playerInventory, BlockEntity baseTile) {
        super((MenuType)MenuTypeRegistry.STARGATE_MENU_TYPE.get(), containerID);
        int col;
        this.playerInventory = playerInventory;
        this.hasCreative = playerInventory.f_35978_.m_7500_();
        if (baseTile == null) {
            throw new NullPointerException("Gate tile is null inside the container! Can not continue!");
        }
        this.gateTile = (StargateClassicBaseBE)baseTile;
        this.pos = this.gateTile.m_58899_();
        IItemHandler itemHandler = this.gateTile.getItemHandler();
        for (col = 0; col < 4; ++col) {
            this.m_38897_(new SlotHandler(itemHandler, col, 9 + 18 * col, 27));
        }
        for (col = 0; col < 3; ++col) {
            final int capacitorIndex = col;
            this.m_38897_(new SlotHandler(itemHandler, col + 4, 115 + 18 * col, 27){

                public boolean m_6659_() {
                    return capacitorIndex + 1 <= StargateContainer.this.gateTile.getSupportedCapacitors() || this.m_6657_();
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            this.m_38897_(new SlotHandler(itemHandler, i + 7, -22, 89 + 22 * i));
        }
        this.m_38897_(new SlotHandler(itemHandler, 10, 0, 0));
        this.m_38897_(new SlotHandler(itemHandler, 11, 81, 27));
        for (Slot slot : ContainerHelper.generatePlayerSlots((Container)playerInventory, 91)) {
            this.m_38897_(slot);
        }
    }

    public StargateContainer(int containerID, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerID, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(buf.m_130135_()));
    }

    @Override
    public List<Integer> getOpenTabsSlotsIds() {
        return this.openedTabsSlotsIds;
    }

    @Override
    public void modifyOpenTabSlotId(int slotId, boolean add) {
        if (add) {
            this.openedTabsSlotsIds.add(slotId);
        } else {
            this.openedTabsSlotsIds.removeIf(v -> v == slotId);
        }
    }

    public void m_7511_(int id, int data) {
        this.gateTile.setPageProgress(data);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack stack = this.m_38853_(index).m_7993_();
        if (!CreativeItemsChecker.canInteractWith(stack, this.hasCreative)) {
            return ItemStack.f_41583_;
        }
        if (index < 12) {
            if (!this.m_38903_(stack, 12, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
        } else {
            List<Integer> openedSlots = this.getOpenTabsSlotsIds();
            int biomeSlotId = 7 + AbstractSymbolType.values(SymbolUsage.STARGATES).length;
            List<Integer> addressSlots = openedSlots.stream().filter(slot -> slot >= 7 && slot <= 6 + AbstractSymbolType.values(SymbolUsage.STARGATES).length && this.gateTile.getItemHandler().isItemValid(slot.intValue(), stack) && !this.m_38853_((int)slot).m_6657_()).toList();
            if (stack.m_41720_() instanceof CapacitorItemBlock) {
                for (int i = 4; i < 7; ++i) {
                    if (this.m_38853_(i).m_6657_() || !this.m_38853_(i).m_5857_(stack)) continue;
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.m_150404_(i, stack1);
                    this.m_38853_(i).m_5852_(stack1);
                    stack.m_41774_(1);
                    return stack;
                }
            } else {
                StargateUpgrade stargateUpgrade;
                IUpgradeItem upgradeItem;
                Object i = stack.m_41720_();
                if (i instanceof IUpgradeItem && (i = (upgradeItem = (IUpgradeItem)i).getUpgrade()) instanceof StargateUpgrade && !this.gateTile.hasUpgrade(stargateUpgrade = (StargateUpgrade)i)) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        if (this.m_38853_(i2).m_6657_()) continue;
                        ItemStack stack1 = stack.m_41777_();
                        stack1.m_41764_(1);
                        this.m_150404_(i2, stack1);
                        this.m_38853_(i2).m_5852_(stack1);
                        stack.m_41774_(1);
                        return ItemStack.f_41583_;
                    }
                } else {
                    int irisSlot;
                    if (!addressSlots.isEmpty()) {
                        Integer s = addressSlots.get(0);
                        ItemStack stack1 = stack.m_41777_();
                        stack1.m_41764_(1);
                        this.m_150404_(s, stack1);
                        this.m_38853_(s).m_5852_(stack1);
                        stack.m_41774_(1);
                        return ItemStack.f_41583_;
                    }
                    if (openedSlots.contains(biomeSlotId) && this.gateTile.getItemHandler().isItemValid(biomeSlotId, stack)) {
                        if (!this.m_38853_(biomeSlotId).m_6657_()) {
                            ItemStack stack1 = stack.m_41777_();
                            stack1.m_41764_(1);
                            this.m_150404_(biomeSlotId, stack1);
                            this.m_38853_(biomeSlotId).m_5852_(stack1);
                            stack.m_41774_(1);
                            return ItemStack.f_41583_;
                        }
                    } else if (this.gateTile.getIrisManager().canInsertItemAsIris(stack.m_41720_()) && !this.gateTile.hasUpgrade(stack.m_41720_()) && !this.m_38853_(irisSlot = 8 + AbstractSymbolType.values(SymbolUsage.STARGATES).length).m_6657_()) {
                        ItemStack stack1 = stack.m_41777_();
                        stack1.m_41764_(1);
                        this.m_150404_(irisSlot, stack1);
                        this.m_38853_(irisSlot).m_5852_(stack1);
                        stack.m_41774_(1);
                        return ItemStack.f_41583_;
                    }
                }
            }
            return ItemStack.f_41583_;
        }
        this.m_38853_(index).m_5852_(ItemStack.f_41583_);
        this.m_150404_(index, ItemStack.f_41583_);
        return stack;
    }

    @ParametersAreNonnullByDefault
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        try {
            if (slotId >= 0 && slotId < this.f_38839_.size() && !CreativeItemsChecker.canInteractWith(this.m_38853_(slotId).m_7993_(), this.hasCreative)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_38946_() {
        super.m_38946_();
        LargeEnergyStorage energyStorage = (LargeEnergyStorage)((Object)this.gateTile.getStargateCapability(ForgeCapabilities.ENERGY, null).resolve().orElseThrow());
        if (this.lastEnergyStored != Objects.requireNonNull(energyStorage).getEnergyStoredInternally() || this.lastEnergySecondsToClose != ((StargateEnergyManager)this.gateTile.getEnergyManager()).getSecondsToClose() || this.energyTransferredLastTick != ((StargateEnergyManager)this.gateTile.getEnergyManager()).getTransferredLastTick() || this.irisMode != this.gateTile.getIrisManager().getIrisMode() || !Objects.equals(this.irisCode, this.gateTile.getIrisManager().getIrisCode()) || this.openedSince != ((StargateAbstractDialingManager)this.gateTile.getDialingManager()).getConnection().getSince() || Math.abs(this.gateTemp - this.gateTile.gateHeat) > 5.0 || this.gateTemp == -1.0 && this.gateTile.gateHeat != -1.0 || Math.abs(this.irisTemp - this.gateTile.irisHeat) > 5.0 || this.irisTemp == -1.0 && this.gateTile.irisHeat != -1.0 || this.lastProgress != this.gateTile.getPageProgress()) {
            Player player = this.playerInventory.f_35978_;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                JSGPacketHandler.sendTo(new StateUpdatePacketToClient(this.pos, StateType.GUI_UPDATE, this.gateTile.getState(StateType.GUI_UPDATE)), sp);
            }
            this.lastEnergyStored = energyStorage.getEnergyStoredInternally();
            this.energyTransferredLastTick = ((StargateEnergyManager)this.gateTile.getEnergyManager()).getTransferredLastTick();
            this.lastEnergySecondsToClose = ((StargateEnergyManager)this.gateTile.getEnergyManager()).getSecondsToClose();
            this.openedSince = ((StargateAbstractDialingManager)this.gateTile.getDialingManager()).getConnection().getSince();
            this.irisMode = this.gateTile.getIrisManager().getIrisMode();
            this.irisCode = this.gateTile.getIrisManager().getIrisCode();
            this.gateTemp = this.gateTile.gateHeat;
            this.irisTemp = this.gateTile.irisHeat;
            this.lastProgress = this.gateTile.getPageProgress();
        }
    }

    @Override
    public void m_38893_(@Nonnull ContainerListener listener) {
        super.m_38893_(listener);
        if (listener instanceof ServerPlayer) {
            JSGPacketHandler.sendTo(new StateUpdatePacketToClient(this.pos, StateType.GUI_STATE, this.gateTile.getState(StateType.GUI_STATE)), (ServerPlayer)listener);
        }
    }
}

