/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.stargate;

import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.stargate.manager.StargateConnection;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.FriendlyByteBuf;

public class StargateContainerGuiUpdate
extends State {
    public int energyStored;
    public int transferredLastTick;
    public double secondsToClose;
    public EnumIrisMode irisMode;
    public String irisCode;
    public StargateConnection stargateConnection;
    public double gateTemp;
    public double irisTemp;
    public int pageProgress;

    public StargateContainerGuiUpdate(StargateConnection stargateConnection) {
        this.stargateConnection = stargateConnection;
    }

    public StargateContainerGuiUpdate(int energyStored, int transferredLastTick, double secondsToClose, EnumIrisMode irisMode, String irisCode, StargateConnection stargateConnection, double gateTemp, double irisTemp, int pageProgress) {
        this.energyStored = energyStored;
        this.transferredLastTick = transferredLastTick;
        this.secondsToClose = secondsToClose;
        this.irisMode = irisMode;
        this.irisCode = irisCode;
        this.stargateConnection = stargateConnection;
        this.gateTemp = gateTemp;
        this.irisTemp = irisTemp;
        this.pageProgress = pageProgress;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energyStored);
        buf.writeInt(this.transferredLastTick);
        buf.writeDouble(this.secondsToClose);
        buf.writeByte((int)this.irisMode.id);
        buf.writeInt(this.irisCode.length());
        buf.writeCharSequence((CharSequence)this.irisCode, StandardCharsets.UTF_8);
        this.stargateConnection.toBytes(new FriendlyByteBuf(buf));
        buf.writeDouble(this.gateTemp);
        buf.writeDouble(this.irisTemp);
        buf.writeInt(this.pageProgress);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.energyStored = buf.readInt();
        this.transferredLastTick = buf.readInt();
        this.secondsToClose = buf.readDouble();
        this.irisMode = EnumIrisMode.getValue(buf.readByte());
        int codeSize = buf.readInt();
        this.irisCode = buf.readCharSequence(codeSize, StandardCharsets.UTF_8).toString();
        this.stargateConnection.fromBytes(new FriendlyByteBuf(buf));
        this.gateTemp = buf.readDouble();
        this.irisTemp = buf.readDouble();
        this.pageProgress = buf.readInt();
    }
}

