/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.iris.codesender.CodeSender;
import dev.tauri.jsg.api.stargate.listener.IStargateListener;
import dev.tauri.jsg.api.stargate.listener.IStargateListenerHandler;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StargateListenerHandler
extends AbstractStargateManager<StargateAbstractBaseBE<?, ?>>
implements IStargateListenerHandler {
    private final List<BlockPos> LISTENERS = new ArrayList<BlockPos>();

    public StargateListenerHandler(StargateAbstractBaseBE<?, ?> stargate) {
        super(stargate);
    }

    @Override
    public void addListener(IStargateListener listener) {
        this.LISTENERS.add(listener.getListenerBlockPos());
    }

    @Override
    public void removeListener(IStargateListener listener) {
        this.LISTENERS.remove(listener.getListenerBlockPos());
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        CompoundTag ent = new CompoundTag();
        ent.m_128405_("size", this.LISTENERS.size());
        int i = 0;
        for (BlockPos pos : this.LISTENERS) {
            ent.m_128356_("pos_" + i, pos.m_121878_());
            ++i;
        }
        compound.m_128365_("listeners", (Tag)ent);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.LISTENERS.clear();
        CompoundTag ent = compound.m_128469_("listeners");
        int size = ent.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            this.LISTENERS.add(BlockPos.m_122022_((long)ent.m_128454_("pos_" + i)));
        }
    }

    private void mapListener(BlockPos pos, Consumer<IStargateListener> runnable) {
        this.mapListener(pos, (IStargateListener l) -> {
            runnable.accept((IStargateListener)l);
            return true;
        });
    }

    private boolean mapListener(BlockPos pos, Predicate<IStargateListener> runnable) {
        Level level = ((StargateAbstractBaseBE)this.stargate).m_58904_();
        if (level == null) {
            return false;
        }
        BlockEntity entity = level.m_7702_(pos);
        Block block = level.m_8055_(pos).m_60734_();
        if (entity instanceof IStargateListener) {
            IStargateListener listener = (IStargateListener)entity;
            return runnable.test(listener);
        }
        if (block instanceof IStargateListener) {
            IStargateListener listener = (IStargateListener)block;
            return runnable.test(listener);
        }
        return false;
    }

    @Override
    public void gateOpen() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::gateOpen);
        }
    }

    @Override
    public void gateClose(StargateClosedReasonEnum reason) {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, (IStargateListener l) -> l.gateClose(reason));
        }
    }

    @Override
    public void gateDisconnect() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::gateDisconnect);
        }
    }

    @Override
    public void gateReset() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::gateReset);
        }
    }

    @Override
    public void gateStateChanged(EnumStargateState oldState, EnumStargateState newState) {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, (IStargateListener l) -> l.gateStateChanged(oldState, newState));
        }
    }

    @Override
    public void gateSymbolEngage(SymbolInterface symbol) {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, (IStargateListener l) -> l.gateSymbolEngage(symbol));
        }
    }

    @Override
    public void gateFail(StargateOpenResult result) {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, (IStargateListener l) -> l.gateFail(result));
        }
    }

    @Override
    public void gateIncoming(int dialedAddressSize) {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, (IStargateListener l) -> l.gateIncoming(dialedAddressSize));
        }
    }

    @Override
    public void gateBeginDial() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::gateBeginDial);
        }
    }

    @Override
    public void irisCloses() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::irisCloses);
        }
    }

    @Override
    public void irisOpens() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::irisOpens);
        }
    }

    @Override
    public void irisHit() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::irisHit);
        }
    }

    @Override
    public boolean receiveIDC(CodeSender sender, String code) {
        boolean result = false;
        for (BlockPos p : this.LISTENERS) {
            result |= this.mapListener(p, (IStargateListener l) -> l.receiveIDC(sender, code));
        }
        return result;
    }

    @Override
    public void gateRingSpin() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::gateRingSpin);
        }
    }

    @Override
    public void gateDialAbort() {
        for (BlockPos p : this.LISTENERS) {
            this.mapListener(p, IStargateListener::gateDialAbort);
        }
    }
}

