/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.chevron;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.animation.IChevronsState;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.api.util.blockentity.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.api.util.math.MathFunction;
import dev.tauri.jsg.api.util.math.MathFunctionImpl;
import dev.tauri.jsg.api.util.math.MathHelper;
import dev.tauri.jsg.api.util.math.MathRange;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.renderer.activation.Activation;
import dev.tauri.jsg.renderer.activation.StargateActivation;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class StargateChevronsState
extends State
implements INBTSerializable<CompoundTag>,
ITickable,
ScheduledTaskExecutorInterface,
IChevronsState {
    protected final Map<ChevronEnum, ChevronState> states = new HashMap<ChevronEnum, ChevronState>();
    protected final StargateAbstractStateManager<?, ?> stateManager;
    protected static final MathRange CHEVRON_OPEN_RANGE = new MathRange(0.0f, 1.57f);
    protected static final MathFunction CHEVRON_OPEN_FUNCTION = new MathFunctionImpl(x -> x * x * x * x / 80.0f);
    protected static final MathRange CHEVRON_CLOSE_RANGE = new MathRange(0.0f, 1.428f);
    protected static final MathFunction CHEVRON_CLOSE_FUNCTION = new MathFunctionImpl(x0 -> MathHelper.cos(x0 * 1.1f) / 12.0f);
    public static final int A_CHEVRON_OPEN_AFTER_STOPPED_DELAY = 10;
    public static final int A_CHEVRON_ACTIVATE_AFTER_OPEN_DELAY = 7;
    public static final int A_CHEVRON_CLOSE_AFTER_ACTIVATE_DELAY = 15;
    protected final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public StargateChevronsState(StargateAbstractStateManager<?, ?> stateManager) {
        this.stateManager = stateManager;
        for (ChevronEnum ch : ChevronEnum.values()) {
            this.states.put(ch, this.getEmptyState(stateManager, ch));
        }
    }

    public MathRange getChevronOpenRange() {
        return CHEVRON_OPEN_RANGE;
    }

    public MathRange getChevronCloseRange() {
        return CHEVRON_CLOSE_RANGE;
    }

    public MathFunction getChevronOpenFunction() {
        return CHEVRON_OPEN_FUNCTION;
    }

    public MathFunction getChevronCloseFunction() {
        return CHEVRON_CLOSE_FUNCTION;
    }

    public ChevronState get(ChevronEnum chevron) {
        ChevronState state = this.states.get(chevron);
        if (state == null) {
            state = this.getEmptyState(this.stateManager, chevron);
            this.states.put(chevron, state);
        }
        return state;
    }

    public ChevronState get(int dialedAddressSize, boolean isFinal) {
        if (isFinal) {
            return this.get(ChevronEnum.getFinal());
        }
        ChevronEnum chevron = ChevronEnum.valueOf(dialedAddressSize);
        if (chevron == null) {
            return this.get(ChevronEnum.getFinal());
        }
        return this.get(chevron);
    }

    protected abstract ChevronState getEmptyState(StargateAbstractStateManager<?, ?> var1, ChevronEnum var2);

    protected abstract ChevronState chevronStateFromNBT(StargateAbstractStateManager<?, ?> var1, CompoundTag var2);

    protected abstract ChevronState chevronStateFromBytes(StargateAbstractStateManager<?, ?> var1, ByteBuf var2);

    public void update(float partialTicks) {
        for (ChevronState s : this.states.values()) {
            s.update(partialTicks);
        }
    }

    public void dimAll() {
        for (ChevronState s : this.states.values()) {
            s.dim();
        }
    }

    public void lockAll() {
        for (ChevronState s : this.states.values()) {
            s.lock();
        }
    }

    public void lockMultiple(List<ChevronEnum> chevrons) {
        for (ChevronEnum c : chevrons) {
            this.get(c).lock();
        }
    }

    public void openMultiple(List<ChevronEnum> chevrons) {
        for (ChevronEnum c : chevrons) {
            this.get(c).open();
        }
    }

    public void openAll() {
        for (ChevronState s : this.states.values()) {
            s.open();
        }
    }

    public void closeAll() {
        for (ChevronState s : this.states.values()) {
            s.close();
        }
    }

    public boolean isOpenedAny() {
        for (ChevronState s : this.states.values()) {
            if (!s.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void send() {
        if (((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_() == null || ((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_().f_46443_) {
            return;
        }
        this.stateManager.getAndSendState(StateType.CHEVRONS_STATE);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag states = new ListTag();
        for (ChevronEnum ch : ChevronEnum.values()) {
            states.add((Object)this.states.getOrDefault(ch, this.getEmptyState(this.stateManager, ch)).serializeNBT());
        }
        compound.m_128365_("states", (Tag)states);
        compound.m_128365_("scheduledTasks", (Tag)ScheduledTask.serializeList(this.scheduledTasks));
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        ListTag states = compound.m_128437_("states", 10);
        for (Tag s : states) {
            ChevronState state = this.chevronStateFromNBT(this.stateManager, (CompoundTag)s);
            this.states.put(state.getChevron(), state);
        }
        try {
            ScheduledTask.deserializeList(compound.m_128469_("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.logger.warn("Exception at reading NBT");
            JSG.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it", e);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        for (ChevronEnum ch : ChevronEnum.values()) {
            this.states.getOrDefault(ch, this.getEmptyState(this.stateManager, ch)).toBytes(buf);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        for (ChevronEnum ch : ChevronEnum.values()) {
            this.states.put(ch, this.chevronStateFromBytes(this.stateManager, buf));
        }
    }

    @Override
    public void tick(Level level) {
        if (level.f_46443_) {
            return;
        }
        ScheduledTask.iterate(this.scheduledTasks, level.m_46467_());
        for (ChevronState s : this.states.values()) {
            boolean chevronOpen = s.chevronOpen;
            boolean chevronOpening = s.chevronOpening;
            boolean chevronClosing = s.chevronClosing;
            long chevronActionStart = s.chevronActionStart;
            Activation<ChevronEnum> activation = s.activation;
            float lightStage = s.lightStage;
            s.tick(level);
            if (chevronOpen == s.chevronOpen && chevronOpening == s.chevronOpening && chevronClosing == s.chevronClosing && chevronActionStart == s.chevronActionStart && activation == s.activation && lightStage == s.lightStage) continue;
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
        }
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(((StargateAbstractBaseBE)this.stateManager.stargate).getTime());
        if (scheduledTask.getWaitTime() <= 0) {
            scheduledTask.execute();
            return;
        }
        this.scheduledTasks.add(scheduledTask);
        ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
    }

    public void clearTasks() {
        this.scheduledTasks.clear();
        ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        StargateAbstractBaseBE stargate = (StargateAbstractBaseBE)this.stateManager.stargate;
        IStargateDialingManager dialingManager = stargate.getDialingManager();
        if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_LIGHT_UP) {
            StargateChevronEngageResult result = ((StargateAbstractDialingManager)dialingManager).onChevronActivates(customData);
            if (result != null && result != StargateChevronEngageResult.OK) {
                if (result == StargateChevronEngageResult.FAILED_FAIL_GATE) {
                    this.onChevronFailedToLock(true);
                } else {
                    this.onChevronFailedToLock(customData.m_128471_("checkConnection"));
                }
            } else {
                if (customData.m_128471_("setIdle")) {
                    ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
                }
                stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                if (customData.m_128471_("litAll")) {
                    this.lockAll();
                } else {
                    this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).lock();
                }
                if (customData.m_128471_("animateTopChevronLock")) {
                    this.scheduleChevronClose(15, ChevronEnum.getFinal(), false);
                    if (!customData.m_128471_("isFinal")) {
                        this.get(ChevronEnum.getFinal().getKey(), true).lock();
                        this.scheduleChevronDim(17, ChevronEnum.getFinal(), true);
                    }
                }
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_OPEN) {
            stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
            this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).open();
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_CLOSE) {
            stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
            this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).close();
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_FAIL) {
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
            }
            this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).close();
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_DIM) {
            this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).dim();
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CLEAR_CHEVRONS) {
            this.dimAll();
            this.closeAll();
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else if (scheduledTask == ScheduledTaskType.LIGHT_UP_CHEVRONS) {
            if (customData.m_128471_("playSound")) {
                stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
            }
            if (customData.m_128441_("chevrons")) {
                ArrayList<ChevronEnum> chevrons = new ArrayList<ChevronEnum>();
                for (int i : customData.m_128465_("chevrons")) {
                    chevrons.add(ChevronEnum.valueOf(i));
                }
                this.lockMultiple(chevrons);
            } else {
                this.lockAll();
            }
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        }
    }

    @Override
    public void scheduleChevronActivate(int waitTicks, ChevronEnum chevron, @Nullable SymbolInterface symbolToLock, boolean setIdle) {
        this.scheduleChevronActivate(waitTicks, chevron, symbolToLock, setIdle, false, false);
    }

    @Override
    public void scheduleChevronFinalOpenAndActivate(int waitTicks, @Nullable SymbolInterface symbolToLock, boolean setIdle) {
        this.scheduleChevronOpen(waitTicks, ChevronEnum.getFinal(), false);
        this.scheduleChevronActivate(waitTicks + 7, ChevronEnum.getFinal(), symbolToLock, false);
        this.scheduleChevronClose(waitTicks + 7 + 15, ChevronEnum.getFinal(), setIdle);
    }

    @Override
    public void scheduleChevronActivate(int waitTicks, ChevronEnum chevron, @Nullable SymbolInterface symbolToLock, boolean setIdle, boolean checkConnection, boolean animateTopChevronLock) {
        this.scheduleChevronActivate(waitTicks, chevron, symbolToLock, setIdle, checkConnection, animateTopChevronLock, false, false);
    }

    @Override
    public void scheduleChevronActivate(int waitTicks, ChevronEnum chevron, @Nullable SymbolInterface symbolToLock, boolean setIdle, boolean checkConnection, boolean animateTopChevronLock, boolean noEnergy, boolean ignoreMaxChevrons) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("chevron", chevron.getKey().intValue());
        data.m_128379_("isFinal", chevron.isFinal());
        data.m_128379_("setIdle", setIdle);
        data.m_128379_("checkConnection", checkConnection);
        data.m_128379_("noEnergy", noEnergy);
        data.m_128379_("ignoreMaxChevrons", ignoreMaxChevrons);
        data.m_128379_("animateTopChevronLock", animateTopChevronLock);
        if (symbolToLock != null) {
            data.m_128405_("symbol", symbolToLock.getId());
        }
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_LIGHT_UP, waitTicks, data));
    }

    @Override
    public void scheduleChevronDim(int waitTicks, ChevronEnum chevron, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("chevron", chevron.getKey().intValue());
        data.m_128379_("isFinal", chevron.isFinal());
        data.m_128379_("setIdle", setIdle);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_DIM, waitTicks, data));
    }

    @Override
    public void scheduleChevronOpen(int waitTicks, ChevronEnum chevron, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("chevron", chevron.getKey().intValue());
        data.m_128379_("isFinal", chevron.isFinal());
        data.m_128379_("setIdle", setIdle);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_OPEN, waitTicks, data));
    }

    @Override
    public void scheduleChevronClose(int waitTicks, ChevronEnum chevron, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("chevron", chevron.getKey().intValue());
        data.m_128379_("isFinal", chevron.isFinal());
        data.m_128379_("setIdle", setIdle);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_CLOSE, waitTicks, data));
    }

    @Override
    public void scheduleChevronFail(int waitTicks, ChevronEnum chevron, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("chevron", chevron.getKey().intValue());
        data.m_128379_("isFinal", chevron.isFinal());
        data.m_128379_("setIdle", setIdle);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_FAIL, waitTicks, data));
    }

    @Override
    public void scheduleChevronsActivateMultiple(int waitTicks, boolean setIdle, boolean playSound, List<ChevronEnum> chevrons) {
        CompoundTag data = new CompoundTag();
        data.m_128379_("playSound", playSound);
        data.m_128379_("setIdle", setIdle);
        data.m_128408_("chevrons", chevrons.stream().map(ChevronEnum::getKey).toList());
        this.addTask(new ScheduledTask(ScheduledTaskType.LIGHT_UP_CHEVRONS, waitTicks, data));
    }

    @Override
    public void scheduleChevronsDimAll(int waitTicks, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128379_("setIdle", setIdle);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CLEAR_CHEVRONS, waitTicks, data));
    }

    @Override
    public void scheduleChevronsLockAll(int waitTicks, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128379_("setIdle", setIdle);
        data.m_128379_("litAll", true);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_LIGHT_UP, waitTicks, data));
    }

    protected void onChevronFailedToLock(boolean checkingForConnection) {
        if (!checkingForConnection && !this.get(ChevronEnum.getFinal()).isOpen()) {
            return;
        }
        this.scheduleChevronFail(60, ChevronEnum.getFinal(), checkingForConnection);
    }

    public static class ChevronState
    extends State
    implements INBTSerializable<CompoundTag>,
    ITickable {
        private final Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> CHEVRON_RESOURCE_MAP = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation>();
        private final Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> CHEVRON_LIGHT_RESOURCE_MAP = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation>();
        private final Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> CHEVRON_LIGHT_RESOURCE_MAP_OFF = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation>();
        protected final StargateAbstractStateManager<?, ?> stateManager;
        protected ChevronEnum chevron = ChevronEnum.getFinal();
        @javax.annotation.Nullable
        protected Activation<ChevronEnum> activation;
        protected float lightStage;
        protected boolean chevronOpen;
        protected long chevronActionStart;
        protected boolean chevronOpening;
        protected boolean chevronClosing;

        protected Activation<ChevronEnum> getActivation(CompoundTag tag) {
            return new StargateActivation(this.getChevron(), tag);
        }

        protected Activation<ChevronEnum> getActivation(ByteBuf buf) {
            return new StargateActivation(this.getChevron(), buf);
        }

        protected ChevronState(StargateAbstractStateManager<?, ?> stateManager, ITextureLoader textureLoader, String chevronTexBase) {
            this.stateManager = stateManager;
            for (BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay : BiomeOverlayRegistry.values()) {
                this.CHEVRON_LIGHT_RESOURCE_MAP.put(biomeOverlay, textureLoader.getTextureResource(chevronTexBase + "_light" + biomeOverlay.getSuffix() + ".png"));
                this.CHEVRON_LIGHT_RESOURCE_MAP_OFF.put(biomeOverlay, textureLoader.getTextureResource(chevronTexBase + "_light_off" + biomeOverlay.getSuffix() + ".png"));
                this.CHEVRON_RESOURCE_MAP.put(biomeOverlay, textureLoader.getTextureResource(chevronTexBase + biomeOverlay.getSuffix() + ".png"));
            }
        }

        public ChevronState(StargateAbstractStateManager<?, ?> stateManager, ITextureLoader textureLoader, String chevronTexBase, ChevronEnum chevron) {
            this(stateManager, textureLoader, chevronTexBase);
            this.chevron = chevron;
        }

        public ChevronState(StargateAbstractStateManager<?, ?> stateManager, ITextureLoader textureLoader, String chevronTexBase, CompoundTag compound) {
            this(stateManager, textureLoader, chevronTexBase);
            this.deserializeNBT(compound);
        }

        public ChevronState(StargateAbstractStateManager<?, ?> stateManager, ITextureLoader textureLoader, String chevronTexBase, ByteBuf buf) {
            this(stateManager, textureLoader, chevronTexBase);
            this.fromBytes(buf);
        }

        protected double getTickCompensation() {
            return 2.0;
        }

        public void open() {
            if (this.isOpen()) {
                return;
            }
            if (this.chevronClosing || this.chevronOpening) {
                return;
            }
            this.chevronActionStart = ((StargateAbstractBaseBE)this.stateManager.stargate).getTime();
            this.chevronClosing = false;
            this.chevronOpen = false;
            this.chevronOpening = true;
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
            this.send();
            this.onServer(() -> StargateComputerEvents.CHEVRON_OPEN.apply(this.chevron).sendVia(this.stateManager.stargate));
        }

        public void close() {
            if (!this.isOpen()) {
                return;
            }
            if (this.chevronClosing || this.chevronOpening) {
                return;
            }
            this.chevronActionStart = ((StargateAbstractBaseBE)this.stateManager.stargate).getTime();
            this.chevronOpening = false;
            this.chevronOpen = true;
            this.chevronClosing = true;
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
            this.send();
            this.onServer(() -> StargateComputerEvents.CHEVRON_CLOSE.apply(this.chevron).sendVia(this.stateManager.stargate));
        }

        public void lock() {
            if (this.isLocked()) {
                return;
            }
            this.activation = new StargateActivation(this.getChevron(), ((StargateAbstractBaseBE)this.stateManager.stargate).getTime(), false);
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
            this.send();
            this.onServer(() -> StargateComputerEvents.CHEVRON_LIT.apply(this.chevron).sendVia(this.stateManager.stargate));
        }

        public void dim() {
            if (!this.isLocked()) {
                return;
            }
            this.activation = new StargateActivation(this.getChevron(), ((StargateAbstractBaseBE)this.stateManager.stargate).getTime(), true);
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
            this.send();
            this.onServer(() -> StargateComputerEvents.CHEVRON_DIM.apply(this.chevron).sendVia(this.stateManager.stargate));
        }

        public boolean isOpen() {
            return this.chevronOpen;
        }

        public boolean isLocked() {
            return this.lightStage > 0.0f;
        }

        public float getState() {
            return this.lightStage;
        }

        public ResourceLocation getTexture(BiomeOverlayRegistry.BiomeOverlayInstance overlayEnum, boolean onlyLight) {
            if (onlyLight) {
                if (this.getState() < 1.0f) {
                    return this.CHEVRON_LIGHT_RESOURCE_MAP_OFF.get(overlayEnum);
                }
                return this.CHEVRON_LIGHT_RESOURCE_MAP.get(overlayEnum);
            }
            return this.CHEVRON_RESOURCE_MAP.get(overlayEnum);
        }

        public void update(float partialTicks) {
            this.getOffset(partialTicks, 1.0f);
            if (this.activation != null) {
                Activation.ActivationState result = this.activation.activate(((StargateAbstractBaseBE)this.stateManager.stargate).getTime(), partialTicks);
                this.lightStage = result.stage;
                if (result.remove) {
                    this.lightStage = this.activation.getFinalState();
                    this.activation = null;
                }
            }
        }

        public void send() {
            if (((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_() == null || ((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_().f_46443_) {
                return;
            }
            this.stateManager.getAndSendState(StateType.CHEVRONS_STATE);
        }

        public void onServer(Runnable runnable) {
            if (((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_() == null || ((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_().f_46443_) {
                return;
            }
            runnable.run();
        }

        public ChevronEnum getChevron() {
            return this.chevron;
        }

        public float getOffset(float partialTicks, float mul) {
            float tick = (float)(((StargateAbstractBaseBE)this.stateManager.stargate).getTime() - this.chevronActionStart) + partialTicks;
            float x = tick / 6.0f;
            if (x < 0.0f) {
                x = 0.0f;
            }
            StargateChevronsState chStates = this.stateManager.getChevronsState();
            if (this.chevronOpening) {
                if (chStates.getChevronOpenRange().test(Float.valueOf(x))) {
                    return chStates.getChevronOpenFunction().apply(x) * mul;
                }
                this.chevronOpen = true;
                this.chevronOpening = false;
            } else if (this.chevronClosing) {
                if (chStates.getChevronCloseRange().test(Float.valueOf(x))) {
                    return chStates.getChevronCloseFunction().apply(x) * mul;
                }
                this.chevronOpen = false;
                this.chevronClosing = false;
            }
            return this.chevronOpen ? 0.08333f * mul : 0.0f;
        }

        @Override
        public void tick(Level level) {
            this.update(0.0f);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("chevronOpen", this.chevronOpen);
            compound.m_128356_("chevronActionStart", this.chevronActionStart);
            compound.m_128379_("chevronOpening", this.chevronOpening);
            compound.m_128379_("chevronClosing", this.chevronClosing);
            compound.m_128350_("lightStage", this.lightStage);
            compound.m_128405_("chevron", this.chevron.getKey().intValue());
            if (this.activation != null) {
                compound.m_128365_("activation", (Tag)this.activation.serializeNBT());
            }
            return compound;
        }

        @Override
        public void deserializeNBT(CompoundTag compound) {
            this.chevronOpen = compound.m_128471_("chevronOpen");
            this.chevronActionStart = compound.m_128454_("chevronActionStart");
            this.chevronOpening = compound.m_128471_("chevronOpening");
            this.chevronClosing = compound.m_128471_("chevronClosing");
            this.lightStage = compound.m_128457_("lightStage");
            this.chevron = ChevronEnum.valueOf(compound.m_128451_("chevron"));
            if (compound.m_128441_("activation")) {
                this.activation = this.getActivation(compound.m_128469_("activation"));
            }
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.chevronOpen);
            buf.writeLong(this.chevronActionStart);
            buf.writeBoolean(this.chevronOpening);
            buf.writeBoolean(this.chevronClosing);
            buf.writeFloat(this.lightStage);
            buf.writeInt(this.chevron.getKey().intValue());
            if (this.activation != null) {
                buf.writeBoolean(true);
                this.activation.toBytes(buf);
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            this.chevronOpen = buf.readBoolean();
            this.chevronActionStart = buf.readLong();
            this.chevronOpening = buf.readBoolean();
            this.chevronClosing = buf.readBoolean();
            this.lightStage = buf.readFloat();
            this.chevron = ChevronEnum.valueOf(buf.readInt());
            if (buf.readBoolean()) {
                this.activation = this.getActivation(buf);
                this.activation.stateChange = (long)Math.ceil((double)this.activation.stateChange + this.getTickCompensation());
            }
            this.chevronActionStart = (long)Math.ceil((double)this.chevronActionStart + this.getTickCompensation());
        }
    }
}

