/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.chevron;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.exception.StargateException;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.math.MathFunction;
import dev.tauri.jsg.api.util.math.MathFunctionImpl;
import dev.tauri.jsg.api.util.math.MathRange;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.manager.state.StargateMovieStateManager;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class StargateMovieChevronsState
extends StargateChevronsState {
    protected static final MathRange CHEVRON_RANGE = new MathRange(0.0f, 0.49997997f);
    protected static final MathFunction CHEVRON_OPEN_FUNCTION = new MathFunctionImpl(x -> x / 6.0f);
    protected static final MathFunction CHEVRON_CLOSE_FUNCTION = new MathFunctionImpl(x -> (0.49997997f - x) / 6.0f);

    public StargateMovieChevronsState(StargateMovieStateManager stateManager) {
        super(stateManager);
    }

    public void openDialed() {
        for (int i = 0; i < ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stateManager.stargate).getDialingManager()).getDialedAddressSize() - 1; ++i) {
            this.get(ChevronEnum.valueOf(i)).open();
        }
    }

    @Override
    public MathRange getChevronOpenRange() {
        return CHEVRON_RANGE;
    }

    @Override
    public MathRange getChevronCloseRange() {
        return CHEVRON_RANGE;
    }

    @Override
    public MathFunction getChevronOpenFunction() {
        return CHEVRON_OPEN_FUNCTION;
    }

    @Override
    public MathFunction getChevronCloseFunction() {
        return CHEVRON_CLOSE_FUNCTION;
    }

    @Override
    protected void onChevronFailedToLock(boolean checkingForConnection) {
        if (!checkingForConnection && !this.isOpenedAny()) {
            return;
        }
        this.scheduleChevronFail(60, ChevronEnum.getFinal(), checkingForConnection);
    }

    @Override
    public void scheduleChevronsLockAll(int waitTicks, boolean setIdle) {
        CompoundTag data = new CompoundTag();
        data.m_128379_("setIdle", setIdle);
        data.m_128379_("litAll", true);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_OPEN, waitTicks, data));
    }

    @Override
    public void scheduleChevronActivate(int waitTicks, ChevronEnum chevron, @Nullable SymbolInterface symbolToLock, boolean setIdle, boolean checkConnection, boolean animateTopChevronLock, boolean noEnergy, boolean ignoreMaxChevrons) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("chevron", chevron.getKey().intValue());
        data.m_128379_("isFinal", chevron.isFinal());
        data.m_128379_("setIdle", setIdle);
        data.m_128379_("checkConnection", checkConnection);
        data.m_128379_("noEnergy", noEnergy);
        data.m_128379_("ignoreMaxChevrons", ignoreMaxChevrons);
        data.m_128379_("animateTopChevronLock", animateTopChevronLock);
        if (symbolToLock != null) {
            data.m_128405_("symbol", symbolToLock.getId());
        }
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CHEVRON_OPEN, waitTicks, data));
    }

    @Override
    public void scheduleChevronDim(int waitTicks, ChevronEnum chevron, boolean setIdle) {
        JSG.logger.error("", new StargateException("Tried to schedule chevron dim on a movie gate!", this.stateManager.stargate));
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        StargateAbstractBaseBE stargate = (StargateAbstractBaseBE)this.stateManager.stargate;
        IStargateDialingManager dialingManager = stargate.getDialingManager();
        if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_LIGHT_UP) {
            JSG.logger.error("", new StargateException("Tried to light up chevron on a movie gate!", stargate));
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_OPEN) {
            stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
            StargateChevronEngageResult result = ((StargateAbstractDialingManager)dialingManager).onChevronActivates(customData);
            if (result != null && result != StargateChevronEngageResult.OK) {
                if (result == StargateChevronEngageResult.FAILED_FAIL_GATE) {
                    ((StargateAbstractStateManager)stargate.getStateManager()).getChevronsState().onChevronFailedToLock(true);
                } else {
                    ((StargateAbstractStateManager)stargate.getStateManager()).getChevronsState().onChevronFailedToLock(customData.m_128471_("checkConnection"));
                }
            } else {
                if (customData.m_128471_("setIdle")) {
                    ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
                }
                if (customData.m_128471_("litAll")) {
                    this.openAll();
                } else if (customData.m_128471_("isFinal")) {
                    this.openDialed();
                } else {
                    this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).open();
                }
                if (customData.m_128471_("animateTopChevronLock")) {
                    if (!customData.m_128471_("isFinal")) {
                        this.scheduleChevronClose(30, ChevronEnum.valueOf(customData.m_128451_("chevron")), true);
                    } else {
                        ((StargateAbstractDialingManager)stargate.getDialingManager()).setStargateState(EnumStargateState.IDLE);
                    }
                }
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_CLOSE) {
            stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
            this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal")).close();
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_FAIL) {
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
            }
            this.closeAll();
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_DIM) {
            JSG.logger.error("", new StargateException("Tried to dim chevron on a movie gate!", stargate));
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CLEAR_CHEVRONS) {
            this.closeAll();
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else if (scheduledTask == ScheduledTaskType.LIGHT_UP_CHEVRONS) {
            if (customData.m_128471_("playSound")) {
                stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
            }
            if (customData.m_128441_("chevrons")) {
                ArrayList<ChevronEnum> chevrons = new ArrayList<ChevronEnum>();
                for (int i : customData.m_128465_("chevrons")) {
                    chevrons.add(ChevronEnum.valueOf(i));
                }
                this.openMultiple(chevrons);
            } else {
                this.openAll();
            }
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }
}

