/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.chevron;

import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.NBTUtils;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.renderer.activation.Activation;
import dev.tauri.jsg.renderer.activation.UniverseActivation;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class StargateUniverseChevronsState
extends StargateChevronsState {
    protected final Map<SymbolInterface, SymbolState> symbolsStates = new HashMap<SymbolInterface, SymbolState>();

    public StargateUniverseChevronsState(StargateAbstractStateManager<?, ?> stateManager) {
        super(stateManager);
        for (SymbolInterface s : ((StargateAbstractBaseBE)stateManager.stargate).getSymbolType().getValues()) {
            this.symbolsStates.put(s, new SymbolState(stateManager, s));
        }
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        StargateAbstractBaseBE stargate = (StargateAbstractBaseBE)this.stateManager.stargate;
        IStargateDialingManager dialingManager = stargate.getDialingManager();
        if (scheduledTask == ScheduledTaskType.STARGATE_SYMBOL_LOCK) {
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
            if (customData.m_128471_("litAll")) {
                this.lockAllSymbols();
            } else if (customData.m_128471_("litAddress")) {
                for (SymbolInterface symbol : ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stateManager.stargate).getDialingManager()).getDialedAddress().subList(0, ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stateManager.stargate).getDialingManager()).getDialedAddressSize())) {
                    this.getSymbol(symbol).lock();
                }
            } else {
                Object symbol = stargate.getSymbolType().valueOf(customData.m_128451_("symbol"));
                this.getSymbol((SymbolInterface)symbol).lock();
            }
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }

    public SymbolState getSymbol(SymbolInterface symbol) {
        SymbolState state = this.symbolsStates.get(symbol);
        if (state == null) {
            state = new SymbolState(this.stateManager, symbol);
            this.symbolsStates.put(symbol, state);
        }
        return state;
    }

    public void lockAllSymbols() {
        for (SymbolState s : this.symbolsStates.values()) {
            s.lock();
        }
    }

    public void dimAllSymbols() {
        for (SymbolState s : this.symbolsStates.values()) {
            s.dim();
        }
    }

    @Override
    public void dimAll() {
        super.dimAll();
        this.dimAllSymbols();
    }

    @Override
    public void update(float partialTicks) {
        super.update(partialTicks);
        for (SymbolState s : this.symbolsStates.values()) {
            s.update(partialTicks);
        }
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        if (level.f_46443_) {
            return;
        }
        for (SymbolState s : this.symbolsStates.values()) {
            s.tick(level);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128365_("symbolsStates", (Tag)NBTUtils.serializeMap(this.symbolsStates, (c, k) -> c.m_128405_("symbol", k.getId()), (c, v) -> c.m_128365_("state", (Tag)v.serializeNBT())));
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        NBTUtils.deSerializeMap(this.symbolsStates, compound.m_128469_("symbolsStates"), c -> ((StargateAbstractBaseBE)this.stateManager.stargate).getSymbolType().valueOf(c.m_128451_("symbol")), c -> new SymbolState(this.stateManager, c.m_128469_("state")));
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NBTUtils.mapToBytes(this.symbolsStates, buf, (b, k) -> b.writeInt(k.getId()), (b, v) -> v.toBytes((ByteBuf)b));
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        NBTUtils.mapFromBytes(this.symbolsStates, buf, b -> ((StargateAbstractBaseBE)this.stateManager.stargate).getSymbolType().valueOf(b.readInt()), b -> new SymbolState((StargateAbstractStateManager<?, ?>)this.stateManager, (ByteBuf)b));
    }

    public static class SymbolState
    extends State
    implements INBTSerializable<CompoundTag>,
    ITickable {
        protected final StargateAbstractStateManager<?, ?> stateManager;
        protected SymbolInterface symbol;
        protected float lightStage;
        @Nullable
        protected Activation<SymbolInterface> activation;

        public SymbolState(StargateAbstractStateManager<?, ?> stateManager, SymbolInterface symbol) {
            this.stateManager = stateManager;
            this.symbol = symbol;
        }

        public SymbolState(StargateAbstractStateManager<?, ?> stateManager, CompoundTag compound) {
            this.stateManager = stateManager;
            this.symbol = ((StargateAbstractBaseBE)stateManager.stargate).getSymbolType().getOrigin();
            this.deserializeNBT(compound);
        }

        public SymbolState(StargateAbstractStateManager<?, ?> stateManager, ByteBuf buf) {
            this.stateManager = stateManager;
            this.symbol = ((StargateAbstractBaseBE)stateManager.stargate).getSymbolType().getOrigin();
            this.fromBytes(buf);
        }

        public boolean isLocked() {
            return this.lightStage > 0.0f;
        }

        public float getLightStage() {
            return this.lightStage;
        }

        public void lock() {
            if (this.isLocked()) {
                return;
            }
            this.activation = new UniverseActivation(this.getSymbol(), ((StargateAbstractBaseBE)this.stateManager.stargate).getTime(), false);
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
            this.send();
        }

        public void dim() {
            if (!this.isLocked()) {
                return;
            }
            this.activation = new UniverseActivation(this.getSymbol(), ((StargateAbstractBaseBE)this.stateManager.stargate).getTime(), true);
            ((StargateAbstractBaseBE)this.stateManager.stargate).m_6596_();
            this.send();
        }

        public void send() {
            if (((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_() == null || ((StargateAbstractBaseBE)this.stateManager.stargate).m_58904_().f_46443_) {
                return;
            }
            this.stateManager.getAndSendState(StateType.CHEVRONS_STATE);
        }

        public SymbolInterface getSymbol() {
            return this.symbol;
        }

        protected Activation<SymbolInterface> getActivation(ByteBuf buf) {
            return new UniverseActivation(this.getSymbol(), buf);
        }

        protected long getTickCompensation() {
            return 3L;
        }

        public void update(float partialTicks) {
            if (this.activation != null) {
                Activation.ActivationState result = this.activation.activate(((StargateAbstractBaseBE)this.stateManager.stargate).getTime(), partialTicks);
                this.lightStage = result.stage;
                if (result.remove) {
                    this.lightStage = this.activation.getFinalState();
                    this.activation = null;
                }
            }
        }

        @Override
        public void tick(Level level) {
            this.update(0.0f);
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeFloat(this.lightStage);
            buf.writeInt(this.symbol.getId());
            if (this.activation != null) {
                buf.writeBoolean(true);
                this.activation.toBytes(buf);
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            this.lightStage = buf.readFloat();
            this.symbol = ((StargateAbstractBaseBE)this.stateManager.stargate).getSymbolType().valueOf(buf.readInt());
            if (buf.readBoolean()) {
                this.activation = this.getActivation(buf);
                if (this.activation.stateChange >= ((StargateAbstractBaseBE)this.stateManager.stargate).getTime() - this.getTickCompensation()) {
                    this.activation.stateChange = (long)Math.ceil((double)((StargateAbstractBaseBE)this.stateManager.stargate).getTime() + (double)Minecraft.m_91087_().getPartialTick());
                }
            }
        }
    }
}

