/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.incoming;

import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.animation.EnumSpinDirection;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class MilkyWayIncomingAnimation
extends IncomingAnimation<StargateAbstractDialingManager<? extends StargateMilkyWayBaseBE>> {
    protected boolean shouldLockWhenStop = false;

    public MilkyWayIncomingAnimation(StargateAbstractDialingManager<? extends StargateMilkyWayBaseBE> dialer, CompoundTag tag) {
        super(dialer, tag);
    }

    public MilkyWayIncomingAnimation(long time, StargateAbstractDialingManager<? extends StargateMilkyWayBaseBE> dialer, int addressLength, int duration) {
        super(time, dialer, addressLength, duration);
    }

    @Override
    public void start() {
        super.start();
        if (this.duration < 30) {
            return;
        }
        if (((StargateMilkyWayBaseBE)this.dialer.stargate).getConfig().getValueOrDefault(StargateConfigOptions.MilkyWay.INCOMING_RING_SPIN).booleanValue()) {
            this.dialer.getSpinHelper().rotateFreely(EnumSpinDirection.random(new Random()));
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.dialer.getSpinHelper().stopSpinning(true);
        if (this.shouldLockWhenStop) {
            ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.dialer.stargate).getStateManager()).getChevronsState().scheduleChevronFinalOpenAndActivate((int)this.dialer.getSpinHelper().getTickToStop(), null, false);
            this.shouldLockWhenStop = false;
        }
    }

    @Override
    public void runPart(int partIndex) {
        super.runPart(partIndex);
        if (partIndex >= this.getParts() - 1) {
            this.shouldLockWhenStop = true;
            return;
        }
        ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.dialer.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(0, ChevronEnum.valueOf(partIndex % 9), null, false);
    }

    @Override
    public void deserializeNBT(CompoundTag compoundTag) {
        super.deserializeNBT(compoundTag);
        this.shouldLockWhenStop = compoundTag.m_128471_("shouldLockWhenStop");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128379_("shouldLockWhenStop", this.shouldLockWhenStop);
        return compound;
    }
}

