/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.incoming;

import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.blockentity.stargate.StargatePegasusBaseBE;
import dev.tauri.jsg.stargate.animation.chevron.StargatePegasusChevronsState;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargatePegasusDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import net.minecraft.nbt.CompoundTag;

public class PegasusIncomingAnimation
extends IncomingAnimation<StargatePegasusDialingManager> {
    public PegasusIncomingAnimation(StargatePegasusDialingManager dialer, CompoundTag tag) {
        super(dialer, tag);
    }

    public PegasusIncomingAnimation(long time, StargatePegasusDialingManager dialer, int addressLength, int duration) {
        super(time, dialer, addressLength, duration);
    }

    @Override
    public void start() {
        super.start();
        if (this.duration >= 2) {
            ((StargateSoundManager)((StargatePegasusBaseBE)((StargatePegasusDialingManager)this.dialer).stargate).getSoundManager()).updateRingRollSound(true);
        }
    }

    @Override
    public void stop() {
        if (!this.finished) {
            ((StargateSoundManager)((StargatePegasusBaseBE)((StargatePegasusDialingManager)this.dialer).stargate).getSoundManager()).updateRingRollSound(false);
            ((StargatePegasusBaseBE)((StargatePegasusDialingManager)this.dialer).stargate).playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
        }
        super.stop();
    }

    @Override
    public void runPart(int partIndex) {
        super.runPart(partIndex);
        ((StargatePegasusChevronsState)((StargateAbstractStateManager)((StargatePegasusBaseBE)((StargatePegasusDialingManager)this.dialer).stargate).getStateManager()).getChevronsState()).activateSlot(partIndex, SymbolTypeRegistry.PEGASUS.valueOf(partIndex));
        StargatePegasusChevronsState.chevronFromSlot(partIndex).ifPresent(chevron -> {
            if (chevron.additionalIndex > 0 && chevron.additionalIndex + chevron.index + 1 > this.addressLength) {
                return;
            }
            ((StargateAbstractStateManager)((StargatePegasusBaseBE)((StargatePegasusDialingManager)this.dialer).stargate).getStateManager()).getChevronsState().get((ChevronEnum)chevron).lock();
            ((StargatePegasusBaseBE)((StargatePegasusDialingManager)this.dialer).stargate).playSoundEvent(StargateSoundEventEnum.INCOMING);
        });
    }

    @Override
    public int getParts() {
        return 36;
    }
}

