/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.spinning;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.animation.EnumSpinDirection;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolPegasusEnum;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.stargate.animation.chevron.StargatePegasusChevronsState;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class PegasusSpinHelper
extends ClassicSpinHelper {
    protected SymbolInterface targetSymbol = SymbolPegasusEnum.SUBIDO;
    protected int slotsToMove;
    protected int currentSlot;

    public PegasusSpinHelper(StargateAbstractBaseBE<?, ?> stargate, Consumer<CompoundTag> onSpinStop) {
        super(stargate, onSpinStop);
    }

    public SymbolInterface getTargetSymbol() {
        return this.targetSymbol;
    }

    @Override
    public SymbolInterface getCurrentTopSymbol(float bounds) {
        return SymbolTypeRegistry.PEGASUS.getOrigin();
    }

    @Override
    public float getRingAngle() {
        return -1.0f;
    }

    @Override
    public double apply(double tick, boolean clampAngle) {
        double a;
        if (!clampAngle) {
            return a;
        }
        for (a = this.calculate(tick - this.ringRotationStart); a < 0.0; a += 36.0) {
        }
        return a % 36.0;
    }

    @Override
    protected double calculate(double tick) {
        if (tick < 0.0) {
            return this.currentSlot;
        }
        if (!this.isSpinning()) {
            return this.currentSlot;
        }
        double slotsMoved = tick * (double)this.speedFactor;
        if (slotsMoved >= (double)this.slotsToMove) {
            double currentSlot;
            slotsMoved = this.slotsToMove;
            if (this.stargate.m_58904_() != null && !this.stargate.m_58904_().m_5776_()) {
                int currentSlot2;
                for (currentSlot2 = (int)((double)this.currentSlot + slotsMoved * (double)this.direction.mul); currentSlot2 < 0; currentSlot2 += 36) {
                }
                this.currentSlot = currentSlot2;
                this.onStopped();
                ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
                return 0.0;
            }
            for (currentSlot = slotsMoved * (double)this.direction.mul + (double)this.currentSlot; currentSlot < 0.0; currentSlot += 36.0) {
            }
            return currentSlot % 36.0;
        }
        return slotsMoved * (double)this.direction.mul + (double)this.currentSlot;
    }

    @Override
    public boolean stopSpinning(boolean clearStopData) {
        if (!this.isSpinning()) {
            return false;
        }
        if (clearStopData) {
            this.stopSpinData = null;
        }
        this.onStopped();
        return true;
    }

    @Override
    protected void onStopped() {
        this.isSpinning = false;
        if (this.stargate.m_58904_() != null && !this.stargate.m_58904_().f_46443_) {
            if (this.stopSpinData == null || !this.stopSpinData.m_128471_("keepRingRoll")) {
                ((StargateSoundManager)this.stargate.getSoundManager()).updateRingRollSound(false);
            }
            this.stargate.playSoundEvent(StargateSoundEventEnum.RING_STOP);
            CompoundTag data = this.stopSpinData;
            this.stopSpinData = null;
            this.onSpinStop.accept(Optional.ofNullable(data).orElseGet(CompoundTag::new));
            this.stargate.m_6596_();
            ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
            this.sendSpinStop();
        }
    }

    @ParametersAreNonnullByDefault
    public Pair<Boolean, Float> moveTo(SymbolInterface targetSymbol, ChevronEnum chevronToMoveTo, EnumSpinDirection direction, ChevronEnum startingPoint, boolean playRingRollStart) {
        if (this.isSpinning()) {
            return Pair.of((Object)false, (Object)Float.valueOf(-1.0f));
        }
        this.isSpinning = true;
        this.updateRingSpeedFromConfig();
        this.direction = direction;
        this.targetSymbol = targetSymbol;
        this.ringRotationStart = this.stargate.getTime();
        this.currentSlot = StargatePegasusChevronsState.slotFromChevron(startingPoint);
        int targetSlot = StargatePegasusChevronsState.slotFromChevron(chevronToMoveTo);
        this.slotsToMove = direction == EnumSpinDirection.CLOCKWISE ? (targetSlot > this.currentSlot ? targetSlot - this.currentSlot : 36 - (this.currentSlot - targetSlot)) : (targetSlot > this.currentSlot ? 36 - (targetSlot - this.currentSlot) : this.currentSlot - targetSlot);
        if (this.slotsToMove <= 16) {
            this.slotsToMove += 36;
        }
        this.stargate.m_6596_();
        ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
        if (this.stargate.m_58904_() != null && !this.stargate.m_58904_().f_46443_ && playRingRollStart) {
            ((StargateSoundManager)this.stargate.getSoundManager()).updateRingRollSound(true);
            this.sendSpinStart();
        }
        return Pair.of((Object)true, (Object)Float.valueOf(this.speedFactor * (float)this.slotsToMove));
    }

    public Pair<Boolean, Float> moveToAndEngage(SymbolInterface targetSymbol, ChevronEnum chevronToMoveTo, ChevronEnum startingPoint, boolean noEnergy, boolean ignoreMaxChevrons, boolean playRingRollStart, boolean stopRingRollAfterStop) {
        EnumSpinDirection direction = startingPoint == ChevronEnum.getFinal() ? EnumSpinDirection.CLOCKWISE : (this.direction != null ? this.direction.opposite() : EnumSpinDirection.CLOCKWISE);
        return this.moveToAndEngage(targetSymbol, chevronToMoveTo, direction, startingPoint, noEnergy, ignoreMaxChevrons, playRingRollStart, stopRingRollAfterStop);
    }

    public Pair<Boolean, Float> moveToAndEngage(SymbolInterface targetSymbol, ChevronEnum chevronToMoveTo, EnumSpinDirection direction, ChevronEnum startingPoint, boolean noEnergy, boolean ignoreMaxChevrons, boolean playRingRollStart, boolean stopRingRollAfterStop) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("symbol", targetSymbol.getId());
        data.m_128379_("isFinal", chevronToMoveTo.isFinal());
        data.m_128379_("noEnergy", noEnergy);
        data.m_128379_("ignoreMaxChevrons", ignoreMaxChevrons);
        data.m_128379_("keepRingRoll", !stopRingRollAfterStop);
        Pair<Boolean, Float> r = this.moveTo(targetSymbol, chevronToMoveTo, direction, startingPoint, playRingRollStart);
        if (((Boolean)r.first()).booleanValue()) {
            this.setSpinStopData(data);
        }
        return r;
    }

    @Override
    public Pair<Boolean, Float> moveTo(@NotNull SymbolInterface symbol, @NotNull EnumSpinDirection direction) {
        JSG.logger.error("Move to without start offset parameter is unsupported in pegasus spin helper!");
        return Pair.of((Object)false, (Object)Float.valueOf(-1.0f));
    }

    @Override
    public Pair<Boolean, Float> moveTo(double angle, @NotNull EnumSpinDirection direction) {
        JSG.logger.error("Move to with angle parameter is unsupported in pegasus spin helper!");
        return Pair.of((Object)false, (Object)Float.valueOf(-1.0f));
    }

    @Override
    public boolean rotateFreely(@NotNull EnumSpinDirection direction) {
        JSG.logger.error("Rotate freely is unsupported in pegasus spin helper!");
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.targetSymbol != null) {
            compound.m_128405_("targetSymbol", this.targetSymbol.getId());
        }
        compound.m_128405_("slotsToMove", this.slotsToMove);
        compound.m_128405_("currentSlot", this.currentSlot);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_("targetSymbol")) {
            this.targetSymbol = SymbolTypeRegistry.PEGASUS.valueOf(compound.m_128451_("targetSymbol"));
        }
        this.slotsToMove = compound.m_128451_("slotsToMove");
        this.currentSlot = compound.m_128451_("currentSlot");
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.targetSymbol != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.targetSymbol.getId());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.slotsToMove);
        buf.writeInt(this.currentSlot);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.targetSymbol = SymbolTypeRegistry.PEGASUS.valueOf(buf.readInt());
        }
        this.slotsToMove = buf.readInt();
        this.currentSlot = buf.readInt();
    }

    @Override
    public void from(ClassicSpinHelper state) {
        super.from(state);
        this.targetSymbol = ((PegasusSpinHelper)state).targetSymbol;
        this.slotsToMove = ((PegasusSpinHelper)state).slotsToMove;
        this.currentSlot = ((PegasusSpinHelper)state).currentSlot;
    }
}

