/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.manager.StargateIrisManager;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class StargateClassicDialingManager<SG extends StargateClassicBaseBE<?>>
extends StargateAbstractDialingManager<SG> {
    protected final ClassicSpinHelper spinHelper = this.generateSpinHelper();

    public StargateClassicDialingManager(SG stargate) {
        super(stargate);
    }

    @Override
    public ClassicSpinHelper generateSpinHelper() {
        return new ClassicSpinHelper((StargateAbstractBaseBE)this.stargate, this::onRingStopSpinning);
    }

    @Override
    public ClassicSpinHelper getSpinHelper() {
        return this.spinHelper;
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        this.getSpinHelper().tick(level);
    }

    @Override
    public void onLoad(Level level) {
        super.onLoad(level);
        this.getSpinHelper().onLoad(level);
    }

    @Override
    protected StargateOpenResult getCanOpenDialed() {
        if (((StargateClassicBaseBE)this.stargate).isGateBurried()) {
            return StargateOpenResult.GATE_BURRIED;
        }
        if (this.getConnection().callConnected((c, sg) -> sg.isGateBurried(), () -> false).booleanValue()) {
            return StargateOpenResult.TARGET_GATE_BURRIED;
        }
        return super.getCanOpenDialed();
    }

    @Override
    protected boolean openGate() {
        if (!super.openGate()) {
            return false;
        }
        ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateRingRollSound(false);
        ((StargateClassicBaseBE)this.stargate).tryHeatUp(8.0);
        ((StargateClassicBaseBE)this.stargate).m_6596_();
        return true;
    }

    @Override
    protected void onWormholeDisconnected() {
        super.onWormholeDisconnected();
        ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateRingRollSound(false);
        ((StargateClassicBaseBE)this.stargate).getIrisManager().onGateDisconnected();
    }

    @Override
    protected void onIncoming(int addressSize, int duration) {
        super.onIncoming(addressSize, duration);
        ((StargateClassicBaseBE)this.stargate).getIrisManager().onIncomingWormhole();
    }

    @Override
    protected void failGate() {
        super.failGate();
        ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateRingRollSound(false);
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.STARGATE_CLOSE) {
            super.executeTask(scheduledTask, customData);
            StargateIrisManager iris = ((StargateClassicBaseBE)this.stargate).getIrisManager();
            if (iris.isIrisClosed() && iris.getIrisMode() == EnumIrisMode.AUTO) {
                iris.toggleIris();
            }
        } else if (scheduledTask == ScheduledTaskType.GATE_RING_ROLL) {
            ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateRingRollSound(true);
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128365_("spinHelper", (Tag)this.spinHelper.serializeNBT());
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.spinHelper.deserializeNBT(compound.m_128469_("spinHelper"));
    }
}

