/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.animation.incoming.MilkyWayIncomingAnimation;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateClassicDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class StargateMilkyWayDialingManager
extends StargateClassicDialingManager<StargateMilkyWayBaseBE> {
    public StargateMilkyWayDialingManager(StargateMilkyWayBaseBE stargate) {
        super(stargate);
    }

    @Override
    public StargateChevronEngageResult engageSymbolDHD(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle()) {
            return StargateChevronEngageResult.BUSY;
        }
        StargateChevronEngageResult r = this.engageSymbolInternal(symbol, false, noEnergy, ignoreMaxChevrons);
        if (!r.ok()) {
            return r;
        }
        StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.DHD, symbol, this.getNextChevron(symbol, true, ignoreMaxChevrons), this.getDialedAddressSize()).sendVia(this.stargate);
        this.setStargateState(EnumStargateState.DIALING);
        if (r == StargateChevronEngageResult.OK_CONNECTED) {
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 30));
        }
        int plusTime = new Random().nextInt(5);
        if (this.isLockChevron(symbol, ignoreMaxChevrons)) {
            if (((StargateMilkyWayBaseBE)this.stargate).getConfig().getValueOrDefault(StargateConfigOptions.MilkyWay.DHD_POO_LOCK).booleanValue()) {
                ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronFinalOpenAndActivate(5 + plusTime, null, true);
                if (this.addressDialSequence != null) {
                    this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 15 + plusTime + 15 + 7));
                }
            } else {
                ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(10 + plusTime, ChevronEnum.getFinal(), null, true);
                if (this.addressDialSequence != null) {
                    this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 15 + plusTime));
                }
            }
        } else {
            ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(10 + plusTime, this.getNextChevron(symbol, true, ignoreMaxChevrons), null, true);
            if (this.addressDialSequence != null) {
                this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 15 + plusTime));
            }
        }
        ((StargateMilkyWayBaseBE)this.stargate).m_6596_();
        return r;
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(CompoundTag tag) {
        return new MilkyWayIncomingAnimation(this, tag);
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(int addressSize, int duration) {
        return new MilkyWayIncomingAnimation(((StargateMilkyWayBaseBE)this.stargate).getTime(), this, addressSize, duration);
    }

    @Override
    protected void clearIncomingWormholeOnSelf() {
        this.getSpinHelper().stopSpinning(true);
        ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsDimAll(0, true);
    }

    @Override
    public void runIncomingWormhole(int addressSize, int duration) {
        super.runIncomingWormhole(addressSize, duration);
        DHDAbstractBE dhd = ((StargateMilkyWayBaseBE)this.stargate).getLinkedDevice();
        if (((StargateMilkyWayBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        DHDAbstractBE dhd = ((StargateMilkyWayBaseBE)this.stargate).getLinkedDevice();
        if (((StargateMilkyWayBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void onWormholeDisconnected() {
        super.onWormholeDisconnected();
        DHDAbstractBE dhd = ((StargateMilkyWayBaseBE)this.stargate).getLinkedDevice();
        if (((StargateMilkyWayBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void onGateOpen(boolean initiating) {
        super.onGateOpen(initiating);
        DHDAbstractBE dhd = ((StargateMilkyWayBaseBE)this.stargate).getLinkedDevice();
        if (((StargateMilkyWayBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.activateSymbol((SymbolInterface)((StargateMilkyWayBaseBE)this.stargate).getSymbolType().getBRB());
        }
    }

    @Override
    protected StargateChevronEngageResult engageSymbolInternal(SymbolInterface symbol, boolean isNox, boolean noEnergy, boolean ignoreMaxChevrons) {
        StargateChevronEngageResult result = super.engageSymbolInternal(symbol, isNox, noEnergy, ignoreMaxChevrons);
        if (result.ok()) {
            DHDAbstractBE dhd = ((StargateMilkyWayBaseBE)this.stargate).getLinkedDevice();
            if (((StargateMilkyWayBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
                dhd.activateSymbol(symbol);
            }
        }
        return result;
    }
}

