/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateMovieBaseBE;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.animation.incoming.MovieIncomingAnimation;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateMilkyWayDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StargateMovieDialingManager
extends StargateMilkyWayDialingManager {
    public StargateMovieDialingManager(StargateMovieBaseBE stargate) {
        super(stargate);
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(CompoundTag tag) {
        return new MovieIncomingAnimation(this, tag);
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(int addressSize, int duration) {
        return new MovieIncomingAnimation(((StargateMilkyWayBaseBE)this.stargate).getTime(), this, addressSize, duration);
    }

    @Override
    @Nullable
    public StargateChevronEngageResult onChevronActivates(CompoundTag customData) {
        if (!customData.m_128441_("symbol")) {
            return null;
        }
        Object symbol = ((StargateMilkyWayBaseBE)this.stargate).getSymbolType().valueOf(customData.m_128451_("symbol"));
        if (symbol == null) {
            return StargateChevronEngageResult.BLOCKED_BY_EVENT;
        }
        StargateChevronEngageResult result = this.engageSymbolInternal((SymbolInterface)symbol, customData.m_128471_("noxDialing"), customData.m_128471_("noEnergy"), customData.m_128471_("ignoreMaxChevrons"));
        if (!result.ok()) {
            return result;
        }
        StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.BY_SPIN, (SymbolInterface)symbol, this.getNextChevron((SymbolInterface)symbol, true, customData.m_128471_("ignoreMaxChevrons")), this.getDialedAddressSize()).sendVia(this.stargate);
        if (customData.m_128471_("checkConnection") && customData.m_128471_("isFinal") && !this.getConnection().getStatus().waiting()) {
            return StargateChevronEngageResult.FAILED_FAIL_GATE;
        }
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 40));
        }
        return StargateChevronEngageResult.OK;
    }

    @Override
    public StargateChevronEngageResult engageSymbolDHD(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle()) {
            return StargateChevronEngageResult.BUSY;
        }
        StargateChevronEngageResult r = this.engageSymbolInternal(symbol, false, noEnergy, ignoreMaxChevrons);
        if (!r.ok()) {
            return r;
        }
        StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.DHD, symbol, this.getNextChevron(symbol, true, ignoreMaxChevrons), this.getDialedAddressSize()).sendVia(this.stargate);
        this.setStargateState(EnumStargateState.DIALING);
        if (r == StargateChevronEngageResult.OK_CONNECTED) {
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 30));
        }
        int plusTime = new Random().nextInt(5);
        ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(10 + plusTime, this.getNextChevron(symbol, true, ignoreMaxChevrons), null, true, false, true, noEnergy, ignoreMaxChevrons);
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 15 + plusTime + 30));
        }
        ((StargateMilkyWayBaseBE)this.stargate).m_6596_();
        return r;
    }

    @Override
    protected void onRingStopSpinning(CompoundTag stopSpinData) {
        if (((StargateMilkyWayBaseBE)this.stargate).getStargateLevel() == null || ((StargateMilkyWayBaseBE)this.stargate).getStargateLevel().m_5776_()) {
            return;
        }
        if (stopSpinData.m_128441_("symbol")) {
            Object symbol = ((StargateMilkyWayBaseBE)this.stargate).getSymbolType().valueOf(stopSpinData.m_128451_("symbol"));
            ChevronEnum chevron = this.getNextChevron((SymbolInterface)symbol, false, stopSpinData.m_128471_("ignoreMaxChevrons"));
            ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(10, chevron, (SymbolInterface)symbol, false, true, true, stopSpinData.m_128471_("noEnergy"), stopSpinData.m_128471_("ignoreMaxChevrons"));
        } else if (this.getStargateState().dialingComputer()) {
            this.setStargateState(EnumStargateState.IDLE);
        }
    }

    @Override
    public StargateChevronEngageResult engageCurrentSymbol() {
        SymbolInterface symbol = this.getSpinHelper().getCurrentTopSymbol();
        if (symbol == null) {
            return StargateChevronEngageResult.BLOCKED_BY_EVENT;
        }
        ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(17, this.getNextChevron(symbol, false, false), symbol, false, true, true);
        return StargateChevronEngageResult.OK;
    }
}

