/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.state;

import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.stargate.manager.IStargateStateManager;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.stargate.animation.BlackHoleAnimationState;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.stargate.StargateFlashState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.state.stargate.StargateSoundUpdateState;
import dev.tauri.jsg.state.stargate.StargateVaporizeBlockParticlesRequest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class StargateAbstractStateManager<SG extends StargateAbstractBaseBE<?, ?>, S extends StargateAbstractRendererState>
extends AbstractStargateManager<SG>
implements IStargateStateManager,
StateProviderInterface {
    private PacketDistributor.TargetPoint targetPoint;
    protected StargateChevronsState chevronsState = this.generateChevronsState();
    protected BlackHoleAnimationState blackHoleAnimationState;
    protected S rendererStateClient;

    public StargateAbstractStateManager(SG stargate) {
        super(stargate);
        this.blackHoleAnimationState = new BlackHoleAnimationState((Stargate<?>)stargate);
    }

    protected abstract StargateChevronsState generateChevronsState();

    @Override
    public StargateChevronsState getChevronsState() {
        return this.chevronsState;
    }

    @Override
    public BlackHoleAnimationState getBlackHoleAnimationState() {
        return this.blackHoleAnimationState;
    }

    @Override
    public State getState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.CHEVRONS_STATE, () -> this.chevronsState).tryType(StateType.SOUND_UPDATE, () -> new StargateSoundUpdateState((StargateSoundManager<?>)((StargateAbstractBaseBE)this.stargate).getSoundManager())).tryType(StateType.RENDERER_STATE, () -> this.getRendererStateServer().build()).tryType(StateType.BLACK_HOLE_ANIMATION_UPDATE, () -> this.blackHoleAnimationState).orElseGet(() -> null);
    }

    @Override
    public State createState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.RENDERER_STATE, this::createRendererStateClient).tryType(StateType.SOUND_UPDATE, () -> new StargateSoundUpdateState((StargateSoundManager<?>)((StargateAbstractBaseBE)this.stargate).getSoundManager())).tryType(StateType.RENDERER_UPDATE, StargateRendererActionState::new).tryType(StateType.STARGATE_VAPORIZE_BLOCK_PARTICLES, StargateVaporizeBlockParticlesRequest::new).tryType(StateType.FLASH_STATE, StargateFlashState::new).tryType(StateType.CHEVRONS_STATE, this::generateChevronsState).tryType(StateType.BLACK_HOLE_ANIMATION_UPDATE, () -> this.blackHoleAnimationState).orElseGet(() -> null);
    }

    protected S castState(State state) {
        return (S)((StargateAbstractRendererState)state);
    }

    @Override
    public void setState(StateType stateType, State state) {
        stateType.stateExecutor().tryType(StateType.SOUND_UPDATE, () -> ((StargateSoundManager)((StargateAbstractBaseBE)this.stargate).getSoundManager()).updateClient()).tryType(StateType.RENDERER_STATE, () -> {
            this.setRendererStateClient(this.castState(((StargateAbstractRendererState)this.castState(state)).initClient(this.m_58899_(), ((StargateAbstractBaseBE)this.stargate).getBiomeOverlayWithOverride(false))));
            ((StargateAbstractBaseBE)this.stargate).updateFacing();
        }).tryType(StateType.CHEVRONS_STATE, () -> {
            this.chevronsState = (StargateChevronsState)state;
            ((StargateAbstractBaseBE)this.stargate).m_6596_();
        }).tryType(StateType.BLACK_HOLE_ANIMATION_UPDATE, () -> {
            this.blackHoleAnimationState = (BlackHoleAnimationState)state;
            ((StargateAbstractBaseBE)this.stargate).m_6596_();
        }).tryType(StateType.RENDERER_UPDATE, () -> {
            if (this.getRendererStateClient() == null && ((StargateRendererActionState)state).action != StargateRendererActionState.EnumGateAction.GATE_RENDER_CHANGED) {
                return;
            }
            switch (((StargateRendererActionState)state).action) {
                case OPEN_GATE: {
                    boolean noxDialing = ((StargateRendererActionState)state).modifyFinal;
                    ((StargateAbstractRendererState)this.getRendererStateClient()).horizonSegments = 0;
                    ((StargateAbstractRendererState)this.getRendererStateClient()).openGate(((StargateAbstractBaseBE)this.stargate).getTime(), noxDialing);
                    break;
                }
                case CLOSE_GATE: {
                    ((StargateAbstractRendererState)this.getRendererStateClient()).closeGate(((StargateAbstractBaseBE)this.stargate).getTime());
                    break;
                }
                case STARGATE_HORIZON_WIDEN: {
                    ++((StargateAbstractRendererState)this.getRendererStateClient()).horizonSegments;
                    break;
                }
                case STARGATE_HORIZON_SHRINK: {
                    --((StargateAbstractRendererState)this.getRendererStateClient()).horizonSegments;
                    break;
                }
                case GATE_RENDER_CHANGED: {
                    ((StargateAbstractBaseBE)this.stargate).setMerged(((StargateRendererActionState)state).modifyFinal);
                    ((StargateAbstractBaseBE)this.stargate).m_6596_();
                    break;
                }
            }
        }).tryType(StateType.STARGATE_VAPORIZE_BLOCK_PARTICLES, () -> {
            if (((StargateAbstractBaseBE)this.stargate).m_58904_() == null) {
                return;
            }
            Level level = ((StargateAbstractBaseBE)this.stargate).m_58904_();
            RandomSource random = level.f_46441_;
            for (int i = 0; i < 20; ++i) {
                StargateVaporizeBlockParticlesRequest s = (StargateVaporizeBlockParticlesRequest)state;
                if (s.waterParticles && !random.m_188499_()) continue;
                double d0 = random.m_188583_() * 0.02;
                double d1 = random.m_188583_() * 0.02;
                double d2 = random.m_188583_() * 0.02;
                float x = (float)s.block.m_123341_() + random.m_188501_();
                float y = (float)s.block.m_123342_() + random.m_188501_();
                float z = (float)s.block.m_123343_() + random.m_188501_();
                level.m_7106_((ParticleOptions)(s.waterParticles ? ParticleTypes.f_123774_ : ParticleTypes.f_123759_), (double)x, (double)y, (double)z, d0, d1, d2);
            }
        }).tryType(StateType.FLASH_STATE, () -> {
            if (this.getRendererStateClient() != null) {
                ((StargateAbstractRendererState)this.getRendererStateClient()).horizonUnstable = ((StargateFlashState)state).flash;
            }
        }).run();
    }

    public S getRendererStateClient() {
        return this.rendererStateClient;
    }

    protected StargateAbstractRendererState.StargateAbstractRendererStateBuilder getRendererStateServer() {
        return StargateAbstractRendererState.builder().setStargateState(((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getStargateState());
    }

    protected abstract S createRendererStateClient();

    protected void setRendererStateClient(S rendererState) {
        this.rendererStateClient = rendererState;
        ((StargateAbstractBaseBE)this.stargate).addTask(new ScheduledTask(ScheduledTaskType.STARGATE_LIGHTING_UPDATE_CLIENT, 10));
    }

    public PacketDistributor.TargetPoint getTargetPoint() {
        if (((StargateAbstractBaseBE)this.stargate).m_58904_() == null) {
            return this.targetPoint;
        }
        if (this.targetPoint == null) {
            BlockPos pos = this.m_58899_();
            this.targetPoint = new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 512.0, ((StargateAbstractBaseBE)this.stargate).m_58904_().m_46472_());
        }
        return this.targetPoint;
    }

    public void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, int chevronCount, boolean modifyFinal, EnumIrisType irisType, EnumIrisState irisState, long irisAnimation) {
        this.sendState(StateType.RENDERER_UPDATE, new StargateRendererActionState(gateAction, chevronCount, modifyFinal, irisType, irisState, irisAnimation));
    }

    public void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, int chevronCount, boolean modifyFinal) {
        this.sendState(StateType.RENDERER_UPDATE, new StargateRendererActionState(gateAction, chevronCount, modifyFinal));
    }

    public void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, boolean parameter) {
        this.sendState(StateType.RENDERER_UPDATE, new StargateRendererActionState(gateAction, -1, parameter));
    }

    @Override
    public void sendState(StateType type, State state) {
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), type, state), this.getTargetPoint());
    }

    @Override
    public BlockPos m_58899_() {
        return ((StargateAbstractBaseBE)this.stargate).m_58899_();
    }

    @Override
    public void onLoad(@NotNull Level level) {
        boolean clientSide = level.m_5776_();
        if (clientSide) {
            this.requestState(StateType.RENDERER_STATE);
            this.requestState(StateType.CHEVRONS_STATE);
            this.requestState(StateType.BLACK_HOLE_ANIMATION_UPDATE);
        } else {
            this.getAndSendState(StateType.RENDERER_STATE);
            this.getAndSendState(StateType.CHEVRONS_STATE);
        }
    }

    @Override
    public void tick(@NotNull Level level) {
        if (level.m_5776_() && this.getRendererStateClient() == null) {
            this.requestState(StateType.RENDERER_STATE);
        }
        this.getChevronsState().tick(level);
        this.blackHoleAnimationState.tick(level);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("blackHoleAnimationManager", (Tag)this.blackHoleAnimationState.serializeNBT());
        compound.m_128365_("chevronsState", (Tag)this.chevronsState.serializeNBT());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.blackHoleAnimationState.deserializeNBT(compound.m_128469_("blackHoleAnimationManager"));
        this.chevronsState.deserializeNBT(compound.m_128469_("chevronsState"));
    }
}

