/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.state;

import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGuiState;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGuiUpdate;
import dev.tauri.jsg.stargate.animation.IrisAnimationState;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class StargateClassicStateManager<SG extends StargateClassicBaseBE<?>, S extends StargateClassicRendererState>
extends StargateAbstractStateManager<SG, S> {
    public StargateClassicStateManager(SG stargate) {
        super(stargate);
    }

    @Override
    public void onLoad(@NotNull Level level) {
        super.onLoad(level);
        if (level.m_5776_()) {
            this.requestState(StateType.SPIN_STATE);
        }
    }

    @Override
    public void tick(@NotNull Level level) {
        super.tick(level);
        if (level.f_46443_ && ((StargateClassicBaseBE)this.stargate).getTime() % 40L == 0L && this.rendererStateClient != null && ((StargateClassicRendererState)this.getRendererStateClient()).biomeOverride == null) {
            ((StargateClassicRendererState)this.rendererStateClient).setBiomeOverlay(((StargateClassicBaseBE)this.stargate).getBiomeOverlayWithOverride(false));
        }
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        StargateClassicRendererState.StargateClassicRendererStateBuilder b = new StargateClassicRendererState.StargateClassicRendererStateBuilder(super.getRendererStateServer()).setSymbolType(((StargateClassicBaseBE)this.stargate).getSymbolType());
        return ((StargateClassicBaseBE)this.stargate).getIrisManager().processRenderState(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).processRenderState(b));
    }

    @Override
    public void setState(StateType stateType, State state) {
        stateType.stateExecutor().tryType(StateType.RENDERER_UPDATE, () -> {
            if (this.getRendererStateClient() == null) {
                return;
            }
            StargateRendererActionState gateActionState = (StargateRendererActionState)state;
            switch (gateActionState.action) {
                case IRIS_UPDATE: {
                    ((StargateClassicRendererState)this.getRendererStateClient()).irisState = gateActionState.irisState;
                    ((StargateClassicRendererState)this.getRendererStateClient()).irisType = gateActionState.irisType;
                    if (gateActionState.irisState != EnumIrisState.CLOSING && gateActionState.irisState != EnumIrisState.OPENING) break;
                    ((StargateClassicRendererState)this.getRendererStateClient()).irisAnimation = gateActionState.irisAnimation;
                    break;
                }
                case HEAT_UPDATE: {
                    ((StargateClassicRendererState)this.getRendererStateClient()).irisHeat = gateActionState.irisHeat;
                    ((StargateClassicRendererState)this.getRendererStateClient()).gateHeat = gateActionState.gateHeat;
                    ((StargateClassicBaseBE)this.stargate).irisHeat = gateActionState.irisHeat;
                    ((StargateClassicBaseBE)this.stargate).gateHeat = gateActionState.gateHeat;
                    ((StargateClassicBaseBE)this.stargate).m_6596_();
                    break;
                }
            }
        }).tryType(StateType.IRIS_ANIMATION, () -> ((StargateClassicBaseBE)this.stargate).getIrisManager().setIrisAnimationState((IrisAnimationState)state)).tryType(StateType.GUI_STATE, () -> {
            StargateContainerGuiState guiState = (StargateContainerGuiState)state;
            ((StargateClassicBaseBE)this.stargate).gateAddressMapClient = guiState.gateAdddressMap;
            ((StargateClassicBaseBE)this.stargate).setConfig(guiState.config);
            ((StargateClassicBaseBE)this.stargate).m_6596_();
        }).tryType(StateType.GUI_UPDATE, () -> {
            StargateContainerGuiUpdate guiUpdate = (StargateContainerGuiUpdate)state;
            ((LargeEnergyStorage)((Object)((Object)((StargateClassicBaseBE)this.stargate).getEnergyManager().getStorage()))).setEnergyStoredInternally(guiUpdate.energyStored);
            ((StargateEnergyManager)((StargateClassicBaseBE)this.stargate).getEnergyManager()).setSecondsToClose((long)guiUpdate.secondsToClose);
            ((StargateEnergyManager)((StargateClassicBaseBE)this.stargate).getEnergyManager()).setTransferredLastTick(guiUpdate.transferredLastTick);
            ((StargateClassicBaseBE)this.stargate).getIrisManager().setIrisMode(guiUpdate.irisMode);
            ((StargateClassicBaseBE)this.stargate).getIrisManager().setIrisCode(guiUpdate.irisCode);
            ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection().setStatusSince(guiUpdate.stargateConnection.getSince());
            ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection().setStatusUnsafe(guiUpdate.stargateConnection.getStatus());
            ((StargateClassicBaseBE)this.stargate).gateHeat = guiUpdate.gateTemp;
            ((StargateClassicBaseBE)this.stargate).irisHeat = guiUpdate.irisTemp;
            ((StargateClassicBaseBE)this.stargate).setPageProgress((short)guiUpdate.pageProgress);
            ((StargateClassicBaseBE)this.stargate).m_6596_();
        }).tryType(StateType.SPIN_STATE, () -> ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getSpinHelper().from((ClassicSpinHelper)state)).tryType(StateType.BIOME_OVERRIDE_STATE, () -> {
            StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
            if (this.rendererStateClient != null) {
                ((StargateClassicRendererState)this.getRendererStateClient()).biomeOverride = overrideState.biomeOverride;
            }
        }).run();
        super.setState(stateType, state);
    }

    @Override
    public State getState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.GUI_STATE, () -> new StargateContainerGuiState(((StargateClassicBaseBE)this.stargate).getAddressMap(), ((StargateClassicBaseBE)this.stargate).getConfig())).tryType(StateType.GUI_UPDATE, () -> new StargateContainerGuiUpdate(((LargeEnergyStorage)((Object)((Object)((StargateClassicBaseBE)this.stargate).getEnergyManager().getStorage()))).getEnergyStoredInternally(), ((StargateEnergyManager)((StargateClassicBaseBE)this.stargate).getEnergyManager()).getTransferredLastTick(), ((StargateEnergyManager)((StargateClassicBaseBE)this.stargate).getEnergyManager()).getSecondsToClose(), ((StargateClassicBaseBE)this.stargate).getIrisManager().getIrisMode(), ((StargateClassicBaseBE)this.stargate).getIrisManager().getIrisCode(), ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection(), ((StargateClassicBaseBE)this.stargate).gateHeat, ((StargateClassicBaseBE)this.stargate).irisHeat, ((StargateClassicBaseBE)this.stargate).getPageProgress())).tryType(StateType.SPIN_STATE, () -> ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getSpinHelper()).tryType(StateType.IRIS_ANIMATION, () -> ((StargateClassicBaseBE)this.stargate).getIrisManager().getIrisAnimationState()).orElseGet(() -> super.getState(stateType));
    }

    @Override
    public State createState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.GUI_STATE, () -> new StargateContainerGuiState(((StargateClassicBaseBE)this.stargate).getConfig())).tryType(StateType.GUI_UPDATE, () -> new StargateContainerGuiUpdate(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection())).tryType(StateType.SPIN_STATE, () -> ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).generateSpinHelper()).tryType(StateType.BIOME_OVERRIDE_STATE, StargateBiomeOverrideState::new).tryType(StateType.IRIS_ANIMATION, IrisAnimationState::new).orElseGet(() -> super.createState(stateType));
    }
}

